/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryLocator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQuery;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.document.viewing.NewInstanceHelper;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PreparedIVQuerySourceQuery
extends PreparedDataSourceQuery {
    protected DataEngineImpl engine;
    protected IQueryDefinition queryDefn;
    protected IQueryResults queryResults;
    protected boolean hasBinding;

    PreparedIVQuerySourceQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        super(dataEngine, queryDefn, null, appContext);
        Object[] params = new Object[]{dataEngine, queryDefn};
        logger.entering(PreparedIVDataSourceQuery.class.getName(), "PreparedIVNestedQuery", params);
        this.queryDefn = queryDefn;
        this.hasBinding = this.queryDefn.getBindings().size() > 0;
        this.engine = dataEngine;
        this.prepareQuery();
        this.preparedQuery = new PreparedQuery(dataEngine.getSession(), dataEngine.getContext(), this.queryDefn, this, appContext);
        logger.exiting(PreparedIVDataSourceQuery.class.getName(), "PreparedIVNestedQuery");
    }

    protected abstract void prepareQuery() throws DataException;

    protected static void getSubQueryBindings(IBaseQueryDefinition queryDefinition, String subQueryName, List<IBinding> resultBindingList) throws DataException {
        List groups = queryDefinition.getGroups();
        if (groups != null) {
            int i = 0;
            while (i < groups.size()) {
                GroupDefinition groupDefinition = (GroupDefinition)groups.get(i);
                if (groupDefinition.getSubqueries() != null) {
                    SubqueryDefinition[] subqueryDefinitions = groupDefinition.getSubqueries().toArray(new SubqueryDefinition[0]);
                    PreparedIVQuerySourceQuery.getSubQueryBindings(subqueryDefinitions, subQueryName, resultBindingList);
                    if (resultBindingList.size() > 0) {
                        return;
                    }
                }
                ++i;
            }
        }
        if (queryDefinition.getSubqueries() != null) {
            SubqueryDefinition[] subqueryDefinitions = queryDefinition.getSubqueries().toArray(new SubqueryDefinition[0]);
            PreparedIVQuerySourceQuery.getSubQueryBindings(subqueryDefinitions, subQueryName, resultBindingList);
            if (resultBindingList.size() > 0) {
                return;
            }
        }
    }

    protected static void addQueryBindings(List<IBinding> resultBindingList, Map bindings) throws DataException {
        Map<String, Boolean> aggrInfo = PreparedQueryUtil.parseAggregations(bindings);
        for (String name : bindings.keySet()) {
            if (aggrInfo.get(name).booleanValue()) continue;
            IBinding binding = (IBinding)bindings.get(name);
            boolean exist = false;
            int i = 0;
            while (i < resultBindingList.size()) {
                if (resultBindingList.get(i) != null && resultBindingList.get(i).getBindingName().equals(binding.getBindingName())) {
                    exist = true;
                }
                ++i;
            }
            if (exist) continue;
            resultBindingList.add(binding);
        }
    }

    private static void getSubQueryBindings(SubqueryDefinition[] subqueryDefinitions, String subQueryName, List<IBinding> resultBindingList) throws DataException {
        int j = 0;
        while (j < subqueryDefinitions.length) {
            if (subqueryDefinitions[j].getName() != null && subqueryDefinitions[j].getName().equals(subQueryName)) {
                PreparedIVQuerySourceQuery.addQueryBindings(resultBindingList, subqueryDefinitions[j].getBindings());
                return;
            }
            PreparedIVQuerySourceQuery.getSubQueryBindings(subqueryDefinitions[j], subQueryName, resultBindingList);
            if (resultBindingList.size() > 0) {
                PreparedIVQuerySourceQuery.addQueryBindings(resultBindingList, subqueryDefinitions[j].getBindings());
                return;
            }
            ++j;
        }
    }

    @Override
    protected QueryExecutor newExecutor() {
        return new IVQuerySourceExecutor(this.engine.getSession().getSharedScope());
    }

    @Override
    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    @Override
    protected IQueryResults produceQueryResults(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        QueryResults queryResults = this.preparedQuery.doPrepare(outerResults, scope, this.newExecutor(), this);
        return queryResults;
    }

    private class IVQuerySourceExecutor
    extends QueryExecutor {
        private Scriptable queryScope;
        private BaseQuery query;
        private DataSetRuntime dsRuntime;
        private IResultClass resultClass;

        IVQuerySourceExecutor(Scriptable sharedScope) {
            super(PreparedIVQuerySourceQuery.this.preparedQuery.getSharedScope(), PreparedIVQuerySourceQuery.this.preparedQuery.getBaseQueryDefn(), PreparedIVQuerySourceQuery.this.preparedQuery.getAggrTable(), PreparedIVQuerySourceQuery.this.dataEngine.getSession());
        }

        protected IDataSource createOdiDataSource() throws DataException {
            return NewInstanceHelper.newDataSource();
        }

        protected DataSourceRuntime findDataSource() throws DataException {
            return NewInstanceHelper.newDataSourceRuntime(this.queryScope);
        }

        protected DataSetRuntime newDataSetRuntime() throws DataException {
            this.dsRuntime = new DataSetRuntime(NewInstanceHelper.newIVDataSetDesign(), this, this.getSession());
            return this.dsRuntime;
        }

        public IResultMetaData getResultMetaData() throws DataException {
            return new ResultMetaData(this.getResultClass());
        }

        protected IQuery createOdiQuery() throws DataException {
            this.query = new IVQuerySourceQuery(this.getResultClass());
            return this.query;
        }

        private IResultClass getResultClass() throws DataException {
            IBinding[] bindings = null;
            IQueryDefinition queryDefinition = PreparedIVQuerySourceQuery.this.queryResults.getPreparedQuery().getReportQueryDefn();
            if (PreparedIVQuerySourceQuery.this.queryDefn.getSourceQuery() instanceof SubqueryLocator) {
                ArrayList<IBinding> bindingList = new ArrayList<IBinding>();
                PreparedIVQuerySourceQuery.getSubQueryBindings(queryDefinition, ((SubqueryLocator)PreparedIVQuerySourceQuery.this.queryDefn.getSourceQuery()).getName(), bindingList);
                PreparedIVQuerySourceQuery.addQueryBindings(bindingList, queryDefinition.getBindings());
                bindings = bindingList.toArray(new IBinding[0]);
            } else {
                bindings = queryDefinition.getBindings().values().toArray(new IBinding[0]);
            }
            this.resultClass = PreparedIVQuerySourceQuery.this.hasBinding ? this.createResultClass(this.getRefBinding(bindings), this.temporaryComputedColumns) : this.createResultClass(bindings, this.temporaryComputedColumns);
            return this.resultClass;
        }

        private IBinding[] getRefBinding(IBinding[] sourceBinding) throws DataException {
            ArrayList<IBinding> refBinding = new ArrayList<IBinding>();
            IBinding[] queryBindings = PreparedIVQuerySourceQuery.this.queryDefn.getBindings().values().toArray(new IBinding[0]);
            int i = 0;
            while (i < sourceBinding.length) {
                if (this.isDirectColumnRef(sourceBinding[i].getBindingName(), queryBindings)) {
                    refBinding.add(sourceBinding[i]);
                }
                ++i;
            }
            return refBinding.toArray(new IBinding[0]);
        }

        private boolean isDirectColumnRef(String columnName, IBinding[] bindings) throws DataException {
            int i = 0;
            while (i < bindings.length) {
                if (bindings[i].getExpression() instanceof ScriptExpression) {
                    try {
                        if (columnName.equals(ExpressionUtil.getColumnName((String)((ScriptExpression)bindings[i].getExpression()).getText()))) {
                            return true;
                        }
                    }
                    catch (BirtException e) {
                        throw DataException.wrap(e);
                    }
                }
                ++i;
            }
            return false;
        }

        private IResultClass createResultClass(IBinding[] bindings, List temporaryComputedColumns) throws DataException {
            int i;
            ResultFieldMetadata rfm = null;
            ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
            if (bindings != null) {
                i = 0;
                while (i < bindings.length) {
                    Class<String> result = null;
                    result = DataType.getClass((int)bindings[i].getDataType());
                    if (result == null) {
                        result = String.class;
                    }
                    rfm = new ResultFieldMetadata(i, bindings[i].getBindingName(), "", result, null, false);
                    projectedColumns.add(rfm);
                    ++i;
                }
            }
            i = 0;
            while (i < temporaryComputedColumns.size()) {
                IComputedColumn computedColumn = (IComputedColumn)temporaryComputedColumns.get(i);
                Class<String> result = DataType.getClass((int)computedColumn.getDataType());
                if (result == null) {
                    result = String.class;
                }
                rfm = new ResultFieldMetadata(i, computedColumn.getName(), "", result, null, true);
                projectedColumns.add(rfm);
                ++i;
            }
            return new ResultClass(projectedColumns);
        }

        protected org.eclipse.birt.data.engine.odi.IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            try {
                IResultIterator sourceResultIterator = PreparedIVQuerySourceQuery.this.queryResults.getResultIterator();
                if (PreparedIVQuerySourceQuery.this.queryDefn.getSourceQuery() instanceof SubqueryLocator) {
                    sourceResultIterator = this.getSubQueryIterator((SubqueryLocator)PreparedIVQuerySourceQuery.this.queryDefn.getSourceQuery(), sourceResultIterator);
                }
                IVQuerySourcePopulator querySourcePopulator = new IVQuerySourcePopulator(sourceResultIterator, this.getResultClass(), this.query, PreparedIVQuerySourceQuery.this.queryDefn.getStartingRow());
                this.query.setDistinctValueFlag(PreparedIVQuerySourceQuery.this.queryDefn.getDistinctValue());
                CachedResultSet resultIterator = new CachedResultSet(this.query, this.resultClass, querySourcePopulator, eventHandler, PreparedIVQuerySourceQuery.this.engine.getSession());
                return resultIterator;
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }

        private IResultIterator getSubQueryIterator(SubqueryLocator subqueryLocator, IResultIterator sourceResultIterator) throws BirtException {
            IResultIterator resultIterator = sourceResultIterator;
            if (subqueryLocator.getParentQuery() != null && subqueryLocator.getParentQuery() instanceof SubqueryLocator) {
                resultIterator = this.getSubQueryIterator((SubqueryLocator)subqueryLocator.getParentQuery(), sourceResultIterator);
            }
            resultIterator.moveTo(subqueryLocator.getRowId());
            return resultIterator.getSecondaryIterator(subqueryLocator.getName(), null);
        }
    }

    private class IVQuerySourcePopulator
    implements IDataSetPopulator {
        private IResultIterator apiResultIterator = null;
        private IResultClass resultClass = null;
        private String[] fieldNames = null;

        IVQuerySourcePopulator(IResultIterator apiResultIterator, IResultClass resultClass, BaseQuery query, int startingRow) throws DataException {
            this.apiResultIterator = apiResultIterator;
            this.resultClass = resultClass;
            this.fieldNames = resultClass.getFieldNames();
            if (startingRow > 0) {
                try {
                    this.apiResultIterator.moveTo(startingRow - 1);
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
        }

        public IResultObject next() throws DataException {
            try {
                if (!this.apiResultIterator.next()) {
                    return null;
                }
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            Object[] fields = new Object[this.fieldNames.length];
            int i = 0;
            while (i < fields.length) {
                try {
                    if (!this.resultClass.isCustomField(i + 1)) {
                        fields[i] = this.apiResultIterator.getValue(this.fieldNames[i]);
                    }
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
                ++i;
            }
            ResultObject result = new ResultObject(this.resultClass, fields);
            return result;
        }
    }

    public class IVQuerySourceQuery
    extends BaseQuery {
        private IResultClass meta;

        public IVQuerySourceQuery(IResultClass resultClass) {
            this.meta = resultClass;
        }

        public void close() {
        }

        public IResultClass getResultClass() {
            return this.meta;
        }
    }
}

