/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupUtil;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;

public final class RDGroupUtil {
    private List[] groups;
    private int leafGroupIdx = 0;
    private CacheProvider cacheProvider;
    private Map<Integer, int[]> groupStartEndIndexCache = new HashMap<Integer, int[]>();

    RDGroupUtil(String tempDir, int groupNumber, RAInputStream[] inputStreams, CacheProvider cacheProvider) throws DataException {
        this.groups = new List[groupNumber];
        int i = 0;
        while (i < groupNumber) {
            this.groups[i] = new GroupCachedList(inputStreams[i]);
            ++i;
        }
        this.cacheProvider = cacheProvider;
    }

    public void saveGroupsToStream(OutputStream outputStream) throws IOException {
        int size = this.groups.length;
        IOUtil.writeInt((OutputStream)outputStream, (int)size);
        int i = 0;
        while (i < size) {
            List list = this.groups[i];
            int asize = list.size();
            IOUtil.writeInt((OutputStream)outputStream, (int)asize);
            int j = 0;
            while (j < asize) {
                GroupInfo groupInfo = (GroupInfo)list.get(j);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.parent);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.firstChild);
                ++j;
            }
            ++i;
        }
    }

    public RDGroupUtil(String tempDir, int groupNumber, RAInputStream[] inputStreams) throws DataException {
        this(tempDir, groupNumber, inputStreams, null);
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public List[] getGroups() {
        return this.groups;
    }

    public void setGroups(List[] groups) {
        this.groups = groups;
    }

    private GroupInfo findGroup(int groupLevel, int groupIndex) {
        if (groupIndex >= this.groups[groupLevel].size()) {
            return null;
        }
        return (GroupInfo)this.groups[groupLevel].get(groupIndex);
    }

    private void checkStarted() throws DataException {
        if (this.cacheProvider == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    private void checkHasCurrentRow() throws DataException {
        this.checkStarted();
        if (this.cacheProvider.getCurrentIndex() >= this.cacheProvider.getCount() && this.cacheProvider.getCount() != -1) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    public int getEndingGroupLevel() throws DataException {
        this.checkHasCurrentRow();
        if (this.cacheProvider.getCurrentIndex() == this.cacheProvider.getCount() - 1) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.cacheProvider.getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level >= 0) {
            GroupInfo nextGroup = this.findGroup(level, currentGroupIdx + 1);
            if (nextGroup == null || childGroupIdx != nextGroup.firstChild - 1) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = this.findGroup((int)level, (int)currentGroupIdx).parent;
            --level;
        }
        return level + 2;
    }

    public int getStartingGroupLevel() throws DataException {
        this.checkHasCurrentRow();
        if (this.cacheProvider.getCurrentIndex() == 0) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.cacheProvider.getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level >= 0) {
            GroupInfo currentGroup = this.findGroup(level, currentGroupIdx);
            if (childGroupIdx != currentGroup.firstChild) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = currentGroup.parent;
            --level;
        }
        return level + 2;
    }

    private int findCurrentGroup(int groupLevel) {
        int currentGroupIdx = this.leafGroupIdx;
        int i = this.groups.length - 1;
        while (i > groupLevel) {
            currentGroupIdx = this.findGroup((int)i, (int)currentGroupIdx).parent;
            --i;
        }
        return currentGroupIdx;
    }

    public void last(int groupLevel) throws DataException {
        if (groupLevel > this.groups.length || groupLevel < 0) {
            throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
        }
        int currentGroupIdx = -1;
        if (--groupLevel >= 0) {
            currentGroupIdx = this.findCurrentGroup(groupLevel);
        }
        if (groupLevel < 0 || currentGroupIdx >= this.groups[groupLevel].size() - 1) {
            int currentRowID = this.cacheProvider.getCount() - 1;
            this.cacheProvider.moveTo(currentRowID);
            if (this.groups.length > 0) {
                this.leafGroupIdx = this.groups[this.groups.length - 1].size() - 1;
            }
            return;
        }
        ++currentGroupIdx;
        int i = groupLevel + 1;
        while (i < this.groups.length) {
            currentGroupIdx = this.findGroup((int)(i - 1), (int)currentGroupIdx).firstChild;
            ++i;
        }
        int currentRowID = this.findGroup((int)(this.groups.length - 1), (int)currentGroupIdx).firstChild - 1;
        this.cacheProvider.moveTo(currentRowID);
        this.leafGroupIdx = currentGroupIdx - 1;
    }

    public void next(boolean hasNext) throws DataException {
        GroupInfo nextLeafGroup;
        if (hasNext && this.groups.length > 0 && (nextLeafGroup = this.findGroup(this.groups.length - 1, this.leafGroupIdx + 1)) != null && this.cacheProvider.getCurrentIndex() >= nextLeafGroup.firstChild) {
            ++this.leafGroupIdx;
        }
    }

    public void move() throws DataException {
        if (this.groups.length > 0) {
            this.binaryMove();
        }
    }

    private void binaryMove() throws DataException {
        List groupList = this.getGroups()[this.groups.length - 1];
        int low = this.leafGroupIdx;
        int high = groupList.size() - 1;
        while (low <= high) {
            int mid = (high + low) / 2;
            if (((GroupInfo)groupList.get((int)mid)).firstChild > this.cacheProvider.getCurrentIndex()) {
                high = mid - 1;
                continue;
            }
            if (mid == groupList.size() - 1 || ((GroupInfo)groupList.get((int)(mid + 1))).firstChild > this.cacheProvider.getCurrentIndex()) {
                this.leafGroupIdx = mid;
                return;
            }
            low = mid + 1;
        }
    }

    public int getGroupLevel() {
        return this.groups.length;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        this.checkHasCurrentRow();
        if (groupLevel == 0) {
            return 0;
        }
        if (groupLevel < 0 || groupLevel > this.groups.length) {
            throw new DataException("data.engine.InvalidGroupLevel", new Integer(groupLevel));
        }
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level > groupLevel - 1) {
            GroupInfo currentGroup = this.findGroup(level, currentGroupIdx);
            currentGroupIdx = currentGroup.parent;
            --level;
        }
        return currentGroupIdx;
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) {
        if (this.groupStartEndIndexCache.containsKey(groupLevel)) {
            return this.groupStartEndIndexCache.get(groupLevel);
        }
        int max = -1;
        if (this.cacheProvider != null) {
            max = this.cacheProvider.getCount();
        }
        if (groupLevel == 0) {
            int[] nArray = new int[2];
            nArray[1] = max;
            this.groupStartEndIndexCache.put(groupLevel, nArray);
            return this.groupStartEndIndexCache.get(groupLevel);
        }
        int unitCountInOneGroup = this.groups[groupLevel - 1].size();
        if (unitCountInOneGroup == 1) {
            int[] nArray = new int[2];
            nArray[1] = max;
            this.groupStartEndIndexCache.put(groupLevel, nArray);
            return this.groupStartEndIndexCache.get(groupLevel);
        }
        int[] unitInfo = new int[unitCountInOneGroup * 2];
        int i = 0;
        while (i < unitCountInOneGroup) {
            int startIndex = i;
            int endIndex = startIndex + 1;
            startIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, startIndex, this.groups, max);
            endIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, endIndex, this.groups, max);
            unitInfo[i * 2] = startIndex;
            unitInfo[i * 2 + 1] = endIndex;
            ++i;
        }
        this.groupStartEndIndexCache.put(groupLevel, unitInfo);
        return this.groupStartEndIndexCache.get(groupLevel);
    }

    private class GroupCachedList
    implements List {
        private int size;
        private RAInputStream dataSource;
        private long initOffset;

        public GroupCachedList(RAInputStream input) throws DataException {
            this.dataSource = input;
            try {
                this.initOffset = this.dataSource.getOffset();
                this.size = IOUtil.readInt((InputStream)this.dataSource);
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Group Info");
            }
        }

        public int size() {
            return this.size;
        }

        public Object get(int index) {
            GroupInfo groupInfo = new GroupInfo();
            try {
                this.dataSource.seek((long)((index * 2 + 1) * 4) + this.initOffset);
                groupInfo.parent = IOUtil.readInt((InputStream)this.dataSource);
                groupInfo.firstChild = IOUtil.readInt((InputStream)this.dataSource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return groupInfo;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public List subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray(Object[] a) {
            throw new UnsupportedOperationException();
        }

        public void finalize() {
            try {
                this.dataSource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

