/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.IViewingSessionManager;
import org.eclipse.birt.report.session.ViewingCache;
import org.eclipse.birt.report.session.ViewingSessionConfig;
import org.eclipse.birt.report.session.ViewingSessionManager;

public class ViewingSessionUtil {
    public static ViewingCache viewingCache = null;
    public static ViewingSessionConfig defaultConfig = new ViewingSessionConfig();

    public static IViewingSessionManager getSessionManager(HttpServletRequest request, boolean create) {
        HttpSession httpSession = request.getSession(create);
        if (httpSession != null) {
            IViewingSessionManager sessionManager = (IViewingSessionManager)httpSession.getAttribute("viewingSessionManager");
            if (sessionManager == null && create) {
                long aSessionTimeout = defaultConfig.getSessionTimeout();
                if (aSessionTimeout == 0L) {
                    aSessionTimeout = httpSession.getMaxInactiveInterval();
                    if (aSessionTimeout <= 0L) {
                        aSessionTimeout = 600000L;
                    }
                    defaultConfig.setSessionTimeout(aSessionTimeout);
                }
                sessionManager = new ViewingSessionManager(viewingCache, httpSession.getId(), defaultConfig);
                httpSession.setAttribute("viewingSessionManager", (Object)sessionManager);
            }
            return sessionManager;
        }
        return null;
    }

    public static IViewingSession getSession(HttpServletRequest request) {
        IViewingSessionManager manager;
        IViewingSession session = (IViewingSession)request.getAttribute("ViewingSession");
        if (session == null && (manager = ViewingSessionUtil.getSessionManager(request, false)) != null) {
            session = manager.getSession(ViewingSessionUtil.getSessionId(request));
            request.setAttribute("ViewingSession", (Object)session);
        }
        return session;
    }

    public static IViewingSession createSession(HttpServletRequest request) throws ViewerException {
        IViewingSessionManager manager = ViewingSessionUtil.getSessionManager(request, true);
        IViewingSession session = manager.createSession();
        request.setAttribute("ViewingSession", (Object)session);
        return session;
    }

    public static String getSessionId(HttpServletRequest request) {
        String sessionId = request.getParameter("__sessionId");
        if (sessionId == null) {
            sessionId = (String)request.getAttribute("__sessionId");
        }
        return sessionId;
    }
}

