/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.LevelViewDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddLevelHandleAction
extends AbstractCrosstabAction {
    DimensionViewHandle viewHandle = null;
    private static final String ID = "add_levelViewhandle";
    private static final String NAME = Messages.getString("AddLevelHandleAction_TransName");
    private static final String TEXT = Messages.getString("AddLevelHandleAction_Displayname");

    public AddLevelHandleAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(TEXT);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.viewHandle = CrosstabAdaptUtil.getDimensionViewHandle(extendedHandle);
        Image image = CrosstabUIHelper.getImage("icons/pal/show-hide-level.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    public boolean isEnabled() {
        return !DEUtil.isReferenceElement((DesignElementHandle)this.viewHandle.getCrosstabHandle());
    }

    public void run() {
        this.transStar(NAME);
        try {
            LevelViewDialog dialog = new LevelViewDialog(UIUtil.getDefaultShell());
            ArrayList<LevelHandle> showLevels = new ArrayList<LevelHandle>();
            ArrayList<Integer> nullLevelHandle = new ArrayList<Integer>();
            int viewCount = this.viewHandle.getLevelCount();
            int i = 0;
            while (i < viewCount) {
                LevelViewHandle levelHandle = this.viewHandle.getLevel(i);
                if (levelHandle.getCubeLevel() == null) {
                    nullLevelHandle.add(levelHandle.getIndex());
                } else {
                    showLevels.add(levelHandle.getCubeLevel());
                }
                ++i;
            }
            dialog.setInput(this.viewHandle.getCubeDimension(), showLevels);
            if (dialog.open() == 0) {
                CrosstabReportItemHandle reportHandle = this.viewHandle.getCrosstab();
                List result = (List)dialog.getResult();
                boolean isLevelRemoved = this.processor(showLevels, result, nullLevelHandle, false);
                if (isLevelRemoved) {
                    boolean bool = CrosstabAdaptUtil.needRemoveInvaildBindings(reportHandle);
                    this.processor(showLevels, result, nullLevelHandle, true);
                    if (bool) {
                        CrosstabAdaptUtil.removeInvalidBindings(reportHandle);
                    }
                } else {
                    this.processor(showLevels, result, nullLevelHandle, true);
                }
                AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(reportHandle);
                providerWrapper.updateAllAggregationCells(0);
            }
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionHandler.handle((Throwable)e);
            return;
        }
        this.transEnd();
    }

    private boolean processor(List ori, List newList, List nullLevelHandle, boolean doChange) throws SemanticException {
        boolean isLevelRemoved = false;
        int i = nullLevelHandle.size() - 1;
        while (i >= 0) {
            int index = (Integer)nullLevelHandle.get(i);
            if (doChange) {
                this.viewHandle.removeLevel(index);
            }
            isLevelRemoved = true;
            --i;
        }
        i = 0;
        while (i < ori.size()) {
            LevelHandle tempHandle = (LevelHandle)ori.get(i);
            if (!newList.contains(tempHandle)) {
                if (doChange) {
                    this.viewHandle.removeLevel(tempHandle.getQualifiedName());
                }
                isLevelRemoved = true;
            }
            ++i;
        }
        Collections.sort(newList, new LevelComparator());
        if (doChange) {
            i = 0;
            while (i < newList.size()) {
                LevelHandle tempHandle = (LevelHandle)newList.get(i);
                if (this.viewHandle.getLevel(tempHandle.getQualifiedName()) == null) {
                    this.insertLevelHandle(tempHandle, i);
                }
                ++i;
            }
        }
        return isLevelRemoved;
    }

    private void insertLevelHandle(LevelHandle levelHandle, int pos) throws SemanticException {
        CrosstabReportItemHandle reportHandle = this.viewHandle.getCrosstab();
        DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)reportHandle.getModelHandle()), levelHandle);
        LevelViewHandle levelViewHandle = this.viewHandle.insertLevel(levelHandle, pos);
        CrosstabCellHandle cellHandle = levelViewHandle.getCell();
        cellHandle.addContent((DesignElementHandle)dataHandle);
    }

    private static class LevelComparator
    implements Comparator {
        private LevelComparator() {
        }

        public int compare(Object o1, Object o2) {
            LevelHandle handle1 = (LevelHandle)o1;
            LevelHandle handle2 = (LevelHandle)o2;
            return handle1.getIndex() - handle2.getIndex();
        }
    }
}

