/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CrosstabUIHelper {
    public static final String CROSSTAB_LINK_IMAGE = "icons/pal/crosstab-link.gif";
    public static final String CROSSTAB_IMAGE = "icons/pal/crosstab.gif";
    public static final String MEASURE_IMAGE = "icons/pal/data.gif";
    public static final String COLUMNS_AREA_IMAGE = "icons/pal/column-area.gif";
    public static final String ROWS_AREA_IMAGE = "icons/pal/row-area.gif";
    public static final String DETAIL_AREA_IMAGE = "icons/pal/detail-area.gif";
    public static final String LEVEL_IMAGE = "icons/pal/level.gif";
    public static final String CELL_IMAGE = "icons/pal/cell.gif";
    public static final String DETAIL_IMAGE = "icons/pal/details.gif";
    public static final String HEADER_IMAGE = "icons/pal/header.gif";
    public static final String AGGREGATION_IMAGE = "icons/pal/aggregation.gif";
    public static final String LEVEL_AGGREGATION = "icons/pal/cell-level-aggregation.gif";
    public static final String SHOW_HIDE_LEVEL = "icons/pal/show-hide-level.gif";
    public static final String LEVEL_ARROW = "icons/pal/level-arrow.gif";
    public static final String COLUMN_GRAND_TOTAL_IMAGE = "icons/pal/col-grand-total.gif";
    public static final String ROW_GRAND_TOTAL_IMAGE = "icons/pal/row-grand-total.gif";
    public static final String COLUMN_SUB_TOTAL_IMAGE = "icons/pal/col-subtotal.gif";
    public static final String ROW_SUB_TOTAL_IMAGE = "icons/pal/row-subtotal.gif";
    public static final String OPTIONS_ICON = "icons/pal/options.gif";
    public static final String ADD_DERIVED_MEASURE = "icons/pal/derived-measure.gif";
    private static final String LABEL_NAME = Messages.getString("AddSubTotalAction.LabelName");
    private static final String DISPALY_NAME = Messages.getString("AddSubTotalAction.TotalName");

    private static Image createImage(String sPluginRelativePath) {
        Image img = null;
        try {
            try {
                img = new Image((Device)Display.getCurrent(), CrosstabUIHelper.getURL(sPluginRelativePath).openStream());
            }
            catch (MalformedURLException malformedURLException) {
                img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(CrosstabUIHelper.getURL(sPluginRelativePath).toString()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static URL getURL(String sPluginRelativePath) {
        URL url = null;
        try {
            url = new URL(CrosstabPlugin.getDefault().getBundle().getEntry("/"), sPluginRelativePath);
        }
        catch (MalformedURLException malformedURLException) {}
        return url;
    }

    public static Image getImage(String sPluginRelativePath) {
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(sPluginRelativePath);
        if (image == null) {
            image = CrosstabUIHelper.createImage(sPluginRelativePath);
            registry.put(sPluginRelativePath, image);
        }
        return image;
    }

    public static void createGrandTotalLabel(CrosstabCellHandle cellHandle) throws SemanticException {
        LabelHandle dataHandle = DesignElementFactory.getInstance().newLabel(null);
        dataHandle.setText(LABEL_NAME);
        cellHandle.addContent((DesignElementHandle)dataHandle);
    }

    public static void createSubTotalLabel(LevelViewHandle levelView, CrosstabCellHandle cellHandle) throws SemanticException {
        CrosstabReportItemHandle crosstab = levelView.getCrosstab();
        DataItemHandle dataHandle = CrosstabUIHelper.createColumnBindingAndDataItemForSubTotal((ReportItemHandle)((ExtendedItemHandle)crosstab.getModelHandle()), levelView.getCubeLevel());
        cellHandle.addContent((DesignElementHandle)dataHandle);
    }

    public static DataItemHandle createColumnBindingAndDataItemForSubTotal(ReportItemHandle owner, LevelHandle levelHandle) throws SemanticException {
        ComputedColumn bindingColumn = CrosstabAdaptUtil.createLevelDisplayComputedColumn(owner, levelHandle);
        String expression = bindingColumn.getExpression();
        bindingColumn.setDataType("string");
        bindingColumn.setExpression(String.valueOf(expression) + "+\" " + DISPALY_NAME + "\"");
        bindingColumn.setName(String.valueOf(levelHandle.getName()) + "_" + DISPALY_NAME);
        ComputedColumnHandle bindingHandle = owner.addColumnBinding(bindingColumn, false);
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(String.valueOf(levelHandle.getName()) + "_" + DISPALY_NAME);
        dataHandle.setResultSetColumn(bindingHandle.getName());
        if (levelHandle.getDateTimeFormat() != null && levelHandle.getContainer() != null && levelHandle.getContainer().getContainer() != null) {
            Iterator itr = levelHandle.attributesIterator();
            boolean hasDateAttribute = false;
            while (itr != null && itr.hasNext()) {
                LevelAttributeHandle att = (LevelAttributeHandle)itr.next();
                if (!"DateTime".equals(att.getName())) continue;
                hasDateAttribute = true;
                break;
            }
            if (hasDateAttribute) {
                String dimensionName = levelHandle.getContainer().getContainer().getName();
                bindingHandle.setDataType("date-time");
                bindingHandle.setExpression(ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)levelHandle.getName(), (String)"DateTime"));
                dataHandle.getPrivateStyle().setDateTimeFormatCategory("Custom");
                dataHandle.getPrivateStyle().setDateTimeFormat(levelHandle.getDateTimeFormat());
            }
        }
        return dataHandle;
    }

    public static ICubeQueryDefinition createBindingQuery(CrosstabReportItemHandle crosstabItem) throws Exception {
        return CrosstabQueryUtil.createCubeQuery((CrosstabReportItemHandle)crosstabItem, null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
    }
}

