/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SimpleComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.section.CrosstabSimpleComboSection;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.dialogs.MessageDialog;

public class CrosstabSimpleComboPropertyDescriptorProvider
extends SimpleComboPropertyDescriptorProvider {
    private static final String NONE = Messages.getString("BindingPage.None");
    private CrosstabSimpleComboSection section;

    public CrosstabSimpleComboPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    public String[] getItems() {
        ExtendedItemHandle handle;
        String[] items = null;
        items = super.getItems();
        if (items != null) {
            return items;
        }
        Object selecteObj = this.input;
        if (this.input instanceof List) {
            selecteObj = ((List)this.input).get(0);
        }
        if (!(handle = (ExtendedItemHandle)selecteObj).getExtensionName().equals("Crosstab")) {
            return items;
        }
        String[] tmpItems = new String[]{};
        if ("cube".equals(this.getProperty())) {
            tmpItems = ChoiceSetFactory.getCubes();
        }
        items = new String[tmpItems.length + 1];
        items[0] = Messages.getString("ChoiceSetFactory.choice.None");
        System.arraycopy(tmpItems, 0, items, 1, tmpItems.length);
        return items;
    }

    public boolean isSpecialProperty() {
        if ("cube".equals(this.getProperty())) {
            return true;
        }
        return super.isSpecialProperty();
    }

    public String getDisplayName() {
        if ("cube".equals(this.getProperty())) {
            return Messages.getString("Element.ReportElement.Cube");
        }
        return super.getDisplayName();
    }

    public void save(Object value) throws SemanticException {
        int ret = 0;
        if (!NONE.equals(this.getCubeName())) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString("CrosstabDataBinding.title.ChangeCube"), null, Messages.getString("CrosstabDataBinding.message.changeCube"), 2, new String[]{org.eclipse.birt.report.designer.nls.Messages.getString((String)"AttributeView.dialg.Message.Yes"), org.eclipse.birt.report.designer.nls.Messages.getString((String)"AttributeView.dialg.Message.No"), org.eclipse.birt.report.designer.nls.Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
            ret = prefDialog.open();
            switch (ret) {
                case 0: {
                    this.resetCubeReference(value, true);
                    break;
                }
                case 1: {
                    this.resetCubeReference(value, false);
                    break;
                }
                case 2: {
                    this.section.getSimpleComboControl().setStringValue(this.getCubeName());
                }
            }
        } else {
            this.resetCubeReference(value, false);
        }
    }

    private String getCubeName() {
        String cubeName = this.getExtendedItemHandle().getCube() == null ? NONE : this.getExtendedItemHandle().getCube().getQualifiedName();
        if (StringUtil.isBlank((String)cubeName)) {
            cubeName = NONE;
        }
        return cubeName;
    }

    private void resetCubeReference(Object value, boolean clearHistory) {
        try {
            this.startTrans("Reset Reference");
            CubeHandle cubeHandle = null;
            if (value != null) {
                cubeHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().findCube(value.toString());
            }
            this.getExtendedItemHandle().setCube(cubeHandle);
            if (clearHistory) {
                this.getExtendedItemHandle().getColumnBindings().clearValue();
                this.getExtendedItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle((Throwable)e);
        }
        this.load();
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private ExtendedItemHandle getExtendedItemHandle() {
        return (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
    }

    private void startTrans(String name) {
        this.getActionStack().startTrans(name);
    }

    private void commit() {
        this.getActionStack().commit();
    }

    private void rollback() {
        this.getActionStack().rollback();
    }

    public void setCrosstabSimpleComboSection(CrosstabSimpleComboSection section) {
        this.section = section;
    }
}

