/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.dialogs.CrosstabGrandTotalDialog;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Table;

public class GrandTotalProvider
extends AbstractFormHandleProvider {
    private CellEditor[] editors;
    private String[] columnNames = new String[]{Messages.getString("GrandTotalProvider.Column.DataField"), Messages.getString("GrandTotalProvider.Column.Function")};
    protected CrosstabReportItemHandle crosstabReportItemHandle;
    private int[] columnWidths = new int[]{200, 200};
    private int axis;

    public boolean canModify(Object element, String property) {
        return false;
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public boolean doAddItem(int pos) throws Exception {
        CrosstabReportItemHandle reportHandle = null;
        try {
            reportHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)((List)this.input).get(0)).getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        CrosstabGrandTotalDialog grandTotalDialog = new CrosstabGrandTotalDialog(reportHandle, this.axis);
        return grandTotalDialog.open() != 1;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        Object[] obj = this.getGrandTotalInfo(this.crosstabReportItemHandle);
        GrandTotalInfo info = (GrandTotalInfo)obj[pos];
        MeasureViewHandle measure = this.crosstabReportItemHandle.getMeasure(info.getMeasureName());
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.crosstabReportItemHandle.getModelHandle();
        List measureList = itemHandle.getPropertyHandle("measures").getContents();
        ExtendedItemHandle extend = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)extend.getReportItem();
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        if (crossTab == null) {
            return false;
        }
        int i = 0;
        while (i < measureList.size()) {
            ExtendedItemHandle extMeasure = (ExtendedItemHandle)measureList.get(i);
            if (extMeasure.getReportItem() == measure) {
                if (CrosstabUtil.isAggregationAffectAllMeasures((CrosstabReportItemHandle)crossTab, (int)this.axis)) {
                    this.crosstabReportItemHandle.removeGrandTotal(this.axis);
                } else {
                    this.crosstabReportItemHandle.removeGrandTotal(this.axis, i);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean doEditItem(int pos) {
        CrosstabGrandTotalDialog grandTotalDialog = new CrosstabGrandTotalDialog(this.crosstabReportItemHandle, this.axis);
        Object[] obj = this.getGrandTotalInfo(this.crosstabReportItemHandle);
        GrandTotalInfo info = (GrandTotalInfo)obj[pos];
        grandTotalDialog.setInput(info);
        return grandTotalDialog.open() != 1;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        return false;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnText(Object element, int columnIndex) {
        GrandTotalInfo info = (GrandTotalInfo)element;
        switch (columnIndex) {
            case 0: {
                return info.getMeasureName() == null ? "" : info.getMeasureName();
            }
            case 1: {
                if (info.getFunction() == null || info.getFunction().trim().equals("")) {
                    info.setFunction(this.getFunctionNames()[0]);
                }
                return this.getFunctionDisplayName(info.getFunction());
            }
        }
        return "";
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnNames.length];
            this.editors[0] = new TextCellEditor();
            this.editors[1] = new TextCellEditor();
        }
        return this.editors;
    }

    public Object[] getElements(Object inputElement) {
        this.input = inputElement;
        Object obj = null;
        obj = inputElement instanceof List ? ((List)inputElement).get(0) : inputElement;
        try {
            this.crosstabReportItemHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)obj).getReportItem();
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return this.getGrandTotalInfo(this.crosstabReportItemHandle);
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    public boolean needRefreshed(NotificationEvent event) {
        return event instanceof ContentEvent || event instanceof PropertyEvent;
    }

    public String getDisplayName() {
        return Messages.getString("CrosstabPageGenerator.List.GrandTotals");
    }

    public String[] getFunctionDisplayNames() {
        IChoice[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    public String[] getFunctionNames() {
        IChoice[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getName();
            ++i;
        }
        return displayNames;
    }

    public String getFunctionDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices());
    }

    private IChoice[] getFunctions() {
        return DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices().getChoices();
    }

    private Object[] getGrandTotalInfo(CrosstabReportItemHandle reportHandle) {
        ArrayList<GrandTotalInfo> retValue = new ArrayList<GrandTotalInfo>();
        List measures = reportHandle.getAggregationMeasures(this.axis);
        int i = 0;
        while (i < measures.size()) {
            MeasureViewHandle measureViewHandle = (MeasureViewHandle)measures.get(i);
            if (!(measureViewHandle instanceof ComputedMeasureViewHandle)) {
                GrandTotalInfo info = new GrandTotalInfo();
                info.setMeasureName(measureViewHandle.getCubeMeasureName());
                info.setFunction(reportHandle.getAggregationFunction(this.axis, measureViewHandle));
                retValue.add(info);
            }
            ++i;
        }
        return retValue.toArray(new Object[retValue.size()]);
    }

    public boolean isAddEnable() {
        ExtendedItemHandle extend = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)extend.getReportItem();
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        if (crossTab == null) {
            return false;
        }
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)crossTab.getModelHandle();
        int measureCount = extendedItem.getPropertyHandle("measures").getContentCount() - crossTab.getComputedMeasures().size();
        if (measureCount == 0 || this.getGrandTotalInfo(crossTab).length >= measureCount) {
            return false;
        }
        int dimCount = this.getDimensionCount(this.crosstabReportItemHandle);
        return dimCount != 0;
    }

    private int getDimensionCount(CrosstabReportItemHandle crosstab) {
        CrosstabViewHandle crosstabView = crosstab.getCrosstabView(this.axis);
        if (crosstabView == null) {
            return 0;
        }
        return crosstabView.getDimensionCount();
    }

    public static class GrandTotalInfo {
        private String measureName = "";
        private String function = "";

        public String getMeasureName() {
            return this.measureName;
        }

        public void setMeasureName(String name) {
            this.measureName = name;
        }

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }
    }
}

