/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider.GrandTotalProvider;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CrosstabGrandTotalDialog
extends BaseDialog {
    public static final String TITLE = Messages.getString("CrosstabGrandTotalDialog.Title");
    protected String[] FUNCTION_LIST_ARRAY;
    protected Combo dataFieldCombo;
    protected Combo functionCombo;
    protected GrandTotalProvider.GrandTotalInfo input;
    protected CrosstabReportItemHandle reportItemHandle;
    private List measures;
    private int axis;

    protected CrosstabGrandTotalDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    protected CrosstabGrandTotalDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public CrosstabGrandTotalDialog(CrosstabReportItemHandle reportItem, int axis) {
        this(TITLE);
        this.reportItemHandle = reportItem;
        this.axis = axis;
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected void okPressed() {
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString("FormPage.Menu.ModifyProperty"));
        String function = this.getFunctionNames()[this.functionCombo.getSelectionIndex()];
        if (this.input == null) {
            ArrayList<MeasureViewHandle> measureList = new ArrayList<MeasureViewHandle>();
            ArrayList<String> functionList = new ArrayList<String>();
            measureList.add(this.getMeasureViewHandle(this.dataFieldCombo.getText()));
            functionList.add(function);
            try {
                CrosstabCellHandle cellHandle = this.reportItemHandle.addGrandTotal(this.axis, measureList, functionList);
                if (cellHandle != null) {
                    CrosstabUIHelper.createGrandTotalLabel(cellHandle);
                }
                stack.commit();
            }
            catch (SemanticException semanticException) {
                stack.rollback();
            }
        } else {
            try {
                MeasureViewHandle measure = this.reportItemHandle.getMeasure(this.input.getMeasureName());
                this.reportItemHandle.setAggregationFunction(this.axis, measure, function);
                stack.commit();
            }
            catch (SemanticException semanticException) {
                stack.rollback();
                super.okPressed();
                return;
            }
        }
        super.okPressed();
    }

    public void setInput(GrandTotalProvider.GrandTotalInfo grandTotalInfo) {
        this.input = grandTotalInfo;
    }

    protected void iniValue() {
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.reportItemHandle.getModelHandle();
        this.measures = extendedItem.getPropertyHandle("measures").getContents();
        if (this.input == null) {
            ArrayList<String> measureNames = new ArrayList<String>();
            int i = 0;
            while (i < this.measures.size()) {
                ExtendedItemHandle extHandle = (ExtendedItemHandle)this.measures.get(i);
                MeasureViewHandle measureViewHandle = null;
                try {
                    measureViewHandle = (MeasureViewHandle)extHandle.getReportItem();
                    if (!(measureViewHandle instanceof ComputedMeasureViewHandle) && !this.inGrandTotalList(this.reportItemHandle, measureViewHandle)) {
                        measureNames.add(measureViewHandle.getCubeMeasureName());
                    }
                }
                catch (ExtendedElementException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                ++i;
            }
            String[] names = new String[measureNames.size()];
            measureNames.toArray(names);
            this.dataFieldCombo.setItems(names);
            this.dataFieldCombo.select(0);
            this.functionCombo.select(0);
        } else {
            String function = this.input.getFunction();
            int index = -1;
            index = Arrays.asList(this.getFunctionNames()).indexOf(function);
            if (index >= 0) {
                String functionDisplay = this.getFunctionDisplayNames()[index];
                index = this.functionCombo.indexOf(functionDisplay);
            }
            if (index < 0 || index >= this.functionCombo.getItemCount()) {
                index = 0;
            }
            this.functionCombo.select(index);
            this.dataFieldCombo.add(this.input.getMeasureName());
            this.dataFieldCombo.select(0);
        }
        GridData dataFieldGd = (GridData)this.dataFieldCombo.getLayoutData();
        GridData functionGd = (GridData)this.functionCombo.getLayoutData();
        int width = this.dataFieldCombo.computeSize((int)-1, (int)-1).x;
        int n = dataFieldGd.widthHint = width > dataFieldGd.widthHint ? width : dataFieldGd.widthHint;
        if (dataFieldGd.widthHint > functionGd.widthHint) {
            functionGd.widthHint = dataFieldGd.widthHint;
        } else {
            dataFieldGd.widthHint = functionGd.widthHint;
        }
        this.dataFieldCombo.setLayoutData((Object)dataFieldGd);
        this.functionCombo.setLayoutData((Object)functionGd);
        this.dataFieldCombo.getParent().layout();
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        CrosstabGrandTotalDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        this.createGrandTotalContent(innerParent);
        Composite space = new Composite(innerParent, 0);
        GridData gdata = new GridData(768);
        gdata.minimumWidth = 200;
        gdata.heightHint = 10;
        space.setLayoutData((Object)gdata);
        Label lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        this.iniValue();
        this.updateButtons();
        return composite;
    }

    protected void createGrandTotalContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(2, false);
        container.setLayout((Layout)glayout);
        Label lb = new Label(container, 0);
        lb.setText(Messages.getString("CrosstabGrandTotalDialog.Text.DataField"));
        this.dataFieldCombo = new Combo(container, 2056);
        GridData gdata = new GridData(768);
        gdata.minimumWidth = 140;
        this.dataFieldCombo.setLayoutData((Object)gdata);
        lb = new Label(container, 0);
        lb.setText(Messages.getString("CrosstabGrandTotalDialog.Text.Function"));
        this.dataFieldCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabGrandTotalDialog.this.updateButtons();
            }
        });
        this.functionCombo = new Combo(container, 2056);
        this.FUNCTION_LIST_ARRAY = this.getFunctionDisplayNames();
        this.functionCombo.setItems(this.FUNCTION_LIST_ARRAY);
        this.functionCombo.select(0);
        this.functionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabGrandTotalDialog.this.updateButtons();
            }
        });
        gdata = new GridData(768);
        gdata.minimumWidth = 140;
        this.functionCombo.setLayoutData((Object)gdata);
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(this.getTitle());
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddEditGrandTotal_ID");
        return titleArea;
    }

    protected void updateButtons() {
        this.getOkButton().setEnabled(this.isConditionOK());
    }

    private boolean isConditionOK() {
        if (this.dataFieldCombo.getSelectionIndex() == -1) {
            return false;
        }
        return this.functionCombo.getSelectionIndex() != -1;
    }

    private MeasureViewHandle getMeasureViewHandle(String measureName) {
        MeasureViewHandle retValue = null;
        int i = 0;
        while (i < this.measures.size()) {
            ExtendedItemHandle extHandle = (ExtendedItemHandle)this.measures.get(i);
            MeasureViewHandle measureViewHandle = null;
            try {
                measureViewHandle = (MeasureViewHandle)extHandle.getReportItem();
            }
            catch (ExtendedElementException e1) {
                this.logger.log(Level.SEVERE, e1.getMessage(), e1);
            }
            if (measureViewHandle.getCubeMeasureName().equals(measureName)) {
                retValue = measureViewHandle;
                break;
            }
            ++i;
        }
        return retValue;
    }

    private String[] getFunctionDisplayNames() {
        IChoice[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private String[] getFunctionNames() {
        IChoice[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getName();
            ++i;
        }
        return displayNames;
    }

    private String getFunctionDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices());
    }

    private IChoice[] getFunctions() {
        return DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices().getChoices();
    }

    private boolean inGrandTotalList(CrosstabReportItemHandle reportHandle, MeasureViewHandle speHandle) {
        List measures = reportHandle.getAggregationMeasures(this.axis);
        int i = 0;
        while (i < measures.size()) {
            MeasureViewHandle measureViewHandle = (MeasureViewHandle)measures.get(i);
            if (measureViewHandle.getCubeMeasure() == speHandle.getCubeMeasure()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

