/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider.SubTotalProvider;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CrosstabSubTotalDialog
extends BaseDialog {
    protected Combo dataFieldCombo;
    protected Combo functionCombo;
    protected Combo levelCombo;
    protected CrosstabReportItemHandle reportItemHandle;
    private List measures = new ArrayList();
    protected int axis;
    protected String[] FUNCTION_LIST_ARRAY;
    protected String[] measureNames;
    protected LevelViewHandle lastLevelView;
    protected SubTotalProvider.SubTotalInfo input;
    public static final String TITLE = Messages.getString("SubTotalDialog.Title");
    protected SelectionListener updateButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == CrosstabSubTotalDialog.this.levelCombo) {
                CrosstabSubTotalDialog.this.updateMeasures();
            }
            CrosstabSubTotalDialog.this.updateButtons();
        }
    };

    public void setInput(SubTotalProvider.SubTotalInfo subTotalInfo) {
        this.input = subTotalInfo;
    }

    protected String[] getAllLevelNames(CrosstabReportItemHandle crosstab) {
        ArrayList<String> list = new ArrayList<String>();
        CrosstabViewHandle crosstabView = crosstab.getCrosstabView(this.axis);
        if (crosstabView == null) {
            return new String[0];
        }
        int dimCount = crosstabView.getDimensionCount();
        int i = 0;
        while (i < dimCount) {
            DimensionViewHandle dimensionView = crosstabView.getDimension(i);
            int levelCount = dimensionView.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                list.add(dimensionView.getLevel(j).getCubeLevelName());
                ++j;
            }
            ++i;
        }
        if (this.lastLevelView == null) {
            DimensionViewHandle lastDimensionView = crosstabView.getDimension(dimCount - 1);
            this.lastLevelView = lastDimensionView.getLevel(lastDimensionView.getLevelCount() - 1);
        }
        list.remove(this.lastLevelView.getCubeLevelName());
        return list.toArray(new String[list.size()]);
    }

    protected LevelViewHandle getLevelFromName(String crosstabName) {
        if (crosstabName == null || crosstabName.length() <= 0) {
            return null;
        }
        CrosstabViewHandle crosstabView = this.reportItemHandle.getCrosstabView(this.axis);
        int dimCount = crosstabView.getDimensionCount();
        int i = 0;
        while (i < dimCount) {
            DimensionViewHandle dimensionView = crosstabView.getDimension(i);
            int levelCount = dimensionView.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                if (dimensionView.getLevel(j).getCubeLevelName().equals(crosstabName)) {
                    return dimensionView.getLevel(j);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected boolean isConditionOK() {
        LevelViewHandle level = this.getLevelFromName(this.levelCombo.getText());
        if (level == null || level == this.lastLevelView) {
            return false;
        }
        if (this.dataFieldCombo.getText().length() <= 0) {
            return false;
        }
        return this.functionCombo.getText().length() > 0 && this.functionCombo.getSelectionIndex() != -1;
    }

    public LevelViewHandle getLevel() {
        return this.getLevelFromName(this.levelCombo.getText());
    }

    public MeasureViewHandle getMeasure() {
        if (this.dataFieldCombo.getText().length() <= 0) {
            return null;
        }
        return (MeasureViewHandle)this.measures.get(this.dataFieldCombo.getSelectionIndex());
    }

    public String getFunction() {
        if (this.functionCombo.getText().length() <= 0 || this.functionCombo.getSelectionIndex() == -1) {
            return null;
        }
        return this.getFunctionNames()[this.functionCombo.getSelectionIndex()];
    }

    public boolean inSubtotalList(CrosstabReportItemHandle reportItem, SubTotalProvider.SubTotalInfo subTotal) {
        CrosstabReportItemHandle crossTab = reportItem;
        CrosstabViewHandle crosstabView = crossTab.getCrosstabView(this.axis);
        int dimensionCount = crosstabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crosstabView.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                if (subTotal.getLevel() == levelHandle) {
                    List aggMeasures = levelHandle.getAggregationMeasures();
                    int k = 0;
                    while (k < aggMeasures.size()) {
                        MeasureViewHandle measure = (MeasureViewHandle)aggMeasures.get(k);
                        if (measure.getCubeMeasureName().equals(subTotal.getMeasureName())) {
                            return true;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected void updateButtons() {
        this.getOkButton().setEnabled(this.isConditionOK());
    }

    protected CrosstabSubTotalDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    protected void updateMeasures() {
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.reportItemHandle.getModelHandle();
        List tmpMeasures = extendedItem.getPropertyHandle("measures").getContents();
        this.measures = new ArrayList();
        ArrayList<String> measureNames = new ArrayList<String>();
        int i = 0;
        while (i < tmpMeasures.size()) {
            ExtendedItemHandle extHandle = (ExtendedItemHandle)tmpMeasures.get(i);
            MeasureViewHandle measureViewHandle = null;
            try {
                measureViewHandle = (MeasureViewHandle)extHandle.getReportItem();
            }
            catch (ExtendedElementException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            if (!(measureViewHandle instanceof ComputedMeasureViewHandle)) {
                MeasureViewHandle measure;
                int k;
                List aggMeasures;
                boolean flag = true;
                if (this.input != null) {
                    if (!measureViewHandle.getCubeMeasureName().equals(this.input.getMeasureName())) {
                        aggMeasures = this.getLevel().getAggregationMeasures();
                        k = 0;
                        while (k < aggMeasures.size()) {
                            measure = (MeasureViewHandle)aggMeasures.get(k);
                            if (measureViewHandle == measure) {
                                flag = false;
                                break;
                            }
                            ++k;
                        }
                    }
                } else if (this.getLevel() != null) {
                    aggMeasures = this.getLevel().getAggregationMeasures();
                    k = 0;
                    while (k < aggMeasures.size()) {
                        measure = (MeasureViewHandle)aggMeasures.get(k);
                        if (measureViewHandle == measure) {
                            flag = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (flag) {
                    this.measures.add(measureViewHandle);
                    measureNames.add(measureViewHandle.getCubeMeasureName());
                }
            }
            ++i;
        }
        String[] items = new String[this.measures.size()];
        measureNames.toArray(items);
        String measure = this.dataFieldCombo.getText();
        this.dataFieldCombo.setItems(items);
        if (measure != null && measureNames.contains(measure)) {
            this.dataFieldCombo.setText(measure);
        } else if (items.length > 0) {
            this.dataFieldCombo.select(0);
        }
    }

    protected CrosstabSubTotalDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public CrosstabSubTotalDialog(CrosstabReportItemHandle reportItem, int axis) {
        this(TITLE);
        this.reportItemHandle = reportItem;
        this.axis = axis;
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        CrosstabSubTotalDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        this.createSubTotalContent(innerParent);
        Composite space = new Composite(innerParent, 0);
        GridData gdata = new GridData(768);
        gdata.widthHint = 200;
        gdata.heightHint = 10;
        space.setLayoutData((Object)gdata);
        Label lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        this.iniValue();
        this.updateButtons();
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddEditSubTotal_ID");
        return composite;
    }

    protected String[] filterLevels(String[] levels) {
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.reportItemHandle.getModelHandle();
        List tmpMeasures = extendedItem.getPropertyHandle("measures").getContents();
        int measureCount = tmpMeasures.size();
        int i = 0;
        while (i < tmpMeasures.size()) {
            ExtendedItemHandle extHandle = (ExtendedItemHandle)tmpMeasures.get(i);
            MeasureViewHandle measureViewHandle = null;
            try {
                measureViewHandle = (MeasureViewHandle)extHandle.getReportItem();
            }
            catch (ExtendedElementException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            if (measureViewHandle instanceof ComputedMeasureViewHandle) {
                --measureCount;
            }
            ++i;
        }
        ArrayList<String> levelList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < levels.length) {
            LevelViewHandle level = this.getLevelFromName(levels[i2]);
            if (level != null) {
                int count = level.getAggregationMeasures().size();
                if (count < measureCount) {
                    levelList.add(levels[i2]);
                } else if (this.input != null && this.input.getLevel() == level) {
                    levelList.add(levels[i2]);
                }
            }
            ++i2;
        }
        return levelList.toArray(new String[0]);
    }

    protected void iniValue() {
        if (this.input == null) {
            String[] levels = this.getAllLevelNames(this.reportItemHandle);
            levels = this.filterLevels(levels);
            this.levelCombo.setItems(levels);
            this.levelCombo.select(0);
            this.updateMeasures();
            this.functionCombo.select(0);
        } else {
            this.levelCombo.add(this.input.getLevel().getCubeLevelName());
            this.levelCombo.select(0);
            this.dataFieldCombo.add(this.input.getMeasureName());
            this.dataFieldCombo.select(0);
            if (this.input.getFunction() == null) {
                this.functionCombo.select(0);
            } else {
                this.functionCombo.select(this.functionCombo.indexOf(this.getFunctionDisplayName(this.input.getFunction())));
            }
        }
        GridData dataFieldGd = (GridData)this.dataFieldCombo.getLayoutData();
        GridData functionGd = (GridData)this.functionCombo.getLayoutData();
        GridData levelGd = (GridData)this.levelCombo.getLayoutData();
        int width = this.dataFieldCombo.computeSize((int)-1, (int)-1).x;
        dataFieldGd.widthHint = width > dataFieldGd.widthHint ? width : dataFieldGd.widthHint;
        width = this.levelCombo.computeSize((int)-1, (int)-1).x;
        int n = levelGd.widthHint = width > dataFieldGd.widthHint ? width : dataFieldGd.widthHint;
        if (dataFieldGd.widthHint > functionGd.widthHint && dataFieldGd.widthHint > levelGd.widthHint) {
            levelGd.widthHint = functionGd.widthHint = dataFieldGd.widthHint;
        } else if (functionGd.widthHint > dataFieldGd.widthHint && functionGd.widthHint > levelGd.widthHint) {
            levelGd.widthHint = dataFieldGd.widthHint = functionGd.widthHint;
        } else {
            dataFieldGd.widthHint = functionGd.widthHint = levelGd.widthHint;
        }
        this.dataFieldCombo.setLayoutData((Object)dataFieldGd);
        this.functionCombo.setLayoutData((Object)functionGd);
        this.levelCombo.setLayoutData((Object)functionGd);
        this.dataFieldCombo.getParent().layout();
        this.updateButtons();
    }

    protected void createSubTotalContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(2, false);
        container.setLayout((Layout)glayout);
        Label lb = new Label(container, 0);
        lb.setText(Messages.getString("SubTotalDialog.Text.AggregateOn"));
        this.levelCombo = new Combo(container, 2056);
        GridData gdata = new GridData();
        gdata.widthHint = 120;
        this.levelCombo.setLayoutData((Object)gdata);
        this.levelCombo.addSelectionListener(this.updateButtonListener);
        lb = new Label(container, 0);
        lb.setText(Messages.getString("SubTotalDialog.Text.DataField"));
        this.dataFieldCombo = new Combo(container, 2056);
        gdata = new GridData(768);
        gdata.minimumWidth = 140;
        this.dataFieldCombo.setLayoutData((Object)gdata);
        lb = new Label(container, 0);
        lb.setText(Messages.getString("SubTotalDialog.Text.Function"));
        this.dataFieldCombo.addSelectionListener(this.updateButtonListener);
        this.functionCombo = new Combo(container, 2056);
        this.FUNCTION_LIST_ARRAY = this.getFunctionDisplayNames();
        this.functionCombo.setItems(this.FUNCTION_LIST_ARRAY);
        this.functionCombo.select(0);
        this.functionCombo.addSelectionListener(this.updateButtonListener);
        gdata = new GridData(768);
        gdata.minimumWidth = 140;
        this.functionCombo.setLayoutData((Object)gdata);
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(this.getTitle());
        return titleArea;
    }

    private String[] getFunctionDisplayNames() {
        IChoice[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private String[] getFunctionNames() {
        IChoice[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getName();
            ++i;
        }
        return displayNames;
    }

    private String getFunctionDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices());
    }

    private IChoice[] getFunctions() {
        return DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices().getChoices();
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected void okPressed() {
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString("FormPage.Menu.ModifyProperty"));
        if (this.input == null) {
            ArrayList<MeasureViewHandle> measureList = new ArrayList<MeasureViewHandle>();
            ArrayList<String> functionList = new ArrayList<String>();
            measureList.addAll(this.getLevel().getAggregationMeasures());
            int i = 0;
            while (i < measureList.size()) {
                functionList.add(this.getLevel().getAggregationFunction((MeasureViewHandle)measureList.get(i)));
                ++i;
            }
            measureList.add(this.getMeasure());
            functionList.add(this.getFunction());
            try {
                this.getLevel().removeSubTotal();
                CrosstabCellHandle cellHandle = this.getLevel().addSubTotal(measureList, functionList);
                if (cellHandle != null) {
                    CrosstabUIHelper.createSubTotalLabel(this.getLevel(), cellHandle);
                }
                stack.commit();
            }
            catch (SemanticException semanticException) {
                stack.rollback();
            }
        } else {
            try {
                MeasureViewHandle measure = this.reportItemHandle.getMeasure(this.input.getMeasureName());
                this.input.getLevel().setAggregationFunction(measure, this.getFunction());
                stack.commit();
            }
            catch (SemanticException semanticException) {
                stack.rollback();
            }
        }
        super.okPressed();
    }
}

