/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboBoxFieldEditor
extends AbstractFieldEditor {
    private Combo fCombo;
    private String[][] fEntryNamesAndValues;

    public ComboBoxFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        assert (this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = 1;
            --numColumns;
        }
        ((GridData)this.fCombo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()), true);
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()), false);
        if (this.getPreferenceStore() instanceof StylePreferenceStore) {
            StylePreferenceStore store = (StylePreferenceStore)this.getPreferenceStore();
            if (store.hasLocalValue(this.getPreferenceName())) {
                this.markDirty(true);
            } else {
                this.markDirty(false);
            }
        } else {
            this.markDirty(true);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                ++i;
            }
            this.fCombo.setFont(parent.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ComboBoxFieldEditor.this.valueChanged("field_editor_value");
                }
            });
        }
        return this.fCombo;
    }

    protected String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return name;
    }

    protected void updateComboForValue(String value, boolean setOldValue) {
        if (setOldValue) {
            this.setOldValue(value);
        } else {
            this.setDefaultValue(value);
        }
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            if (value == null && (this.fEntryNamesAndValues[i][1] == null || this.fEntryNamesAndValues[i][1].length() == 0) || this.fEntryNamesAndValues[i][1].equals(value)) {
                this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
                return;
            }
            ++i;
        }
        if (value == null) {
            this.fCombo.setText("");
        } else {
            this.fCombo.setText(value);
        }
        if (setOldValue) {
            this.setOldValue(this.getStringValue());
        } else {
            this.setDefaultValue(this.getStringValue());
        }
    }

    protected String getStringValue() {
        if (this.fCombo != null) {
            return this.getValueForName(this.fCombo.getText());
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }
}

