/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComboBoxSelectionDialog
extends Dialog {
    private String fSelection = null;
    private final String fShellTitle;
    private final String fLabelText;
    private final String[] fAllowedStrings;
    private final int fInitialSelectionIndex;

    public ComboBoxSelectionDialog(Shell parentShell, String shellTitle, String labelText, String[] comboStrings, int initialSelectionIndex) {
        super(parentShell);
        this.fShellTitle = shellTitle;
        this.fLabelText = labelText;
        this.fAllowedStrings = comboStrings;
        this.fInitialSelectionIndex = initialSelectionIndex;
    }

    public String getSelectedString() {
        return this.fSelection;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.fShellTitle);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayoutData((Object)new GridData());
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        innerComposite.setLayout((Layout)gl);
        Label label = new Label(innerComposite, 0);
        label.setText(this.fLabelText);
        label.setLayoutData((Object)new GridData());
        final Combo combo = new Combo(innerComposite, 8);
        int i = 0;
        while (i < this.fAllowedStrings.length) {
            combo.add(this.fAllowedStrings[i]);
            ++i;
        }
        if (this.fInitialSelectionIndex != -1) {
            combo.select(this.fInitialSelectionIndex);
            this.fSelection = combo.getItem(combo.getSelectionIndex());
        }
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(this.getMaxStringLength());
        combo.setLayoutData((Object)gd);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComboBoxSelectionDialog.this.fSelection = combo.getItem(combo.getSelectionIndex());
            }
        });
        ComboBoxSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private int getMaxStringLength() {
        int max = 0;
        int i = 0;
        while (i < this.fAllowedStrings.length) {
            max = Math.max(max, this.fAllowedStrings[i].length());
            ++i;
        }
        if (max < 20) {
            max = 20;
        }
        return max;
    }
}

