/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.HighlightRuleBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.HighlightHandleProvider;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class HighlightsPreferencePage
extends BaseStylePreferencePage {
    private TableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fDeleteButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private HighlightHandleProvider provider = new HighlightHandleProvider();
    private Object model;

    public HighlightsPreferencePage(Object model) {
        super(model);
        this.setTitle(Messages.getString((String)"HighlightsPreferencePage.displayname.Title"));
        this.setDescription(Messages.getString((String)"HighlightsPreferencePage.text.Description"));
        this.model = model;
    }

    protected Control createContents(Composite parent) {
        super.createFieldEditors();
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.StyleBuilderHighlights_ID");
        final Composite innerParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        innerParent.setLayout((Layout)layout);
        innerParent.setLayoutData((Object)new GridData(1808));
        final Table table = new Table(innerParent, 67584);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        final TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.getString((String)"HighlightsPreferencePage.displayname.Preview"));
        final TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.getString((String)"HighlightsPreferencePage.displayname.Condition"));
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new HighlightLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new HighlightContentProvider());
        this.fTableViewer.setSorter(null);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HighlightsPreferencePage.this.updateButtons();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HighlightsPreferencePage.this.edit();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                HighlightsPreferencePage.this.handleTableKeyPressEvent(e);
            }
        });
        innerParent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = innerParent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(2 * width / 5);
                    column2.setWidth(width - column1.getWidth());
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(2 * width / 5);
                    column2.setWidth(width - column1.getWidth());
                }
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(128));
        layout = new GridLayout();
        layout.numColumns = 6;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(Messages.getString((String)"HighlightsPreferencePage.text.Add"));
        data = new GridData(128);
        data.widthHint = Math.max(this.fAddButton.computeSize((int)-1, (int)-1).x, 60);
        this.fAddButton.setLayoutData((Object)data);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightsPreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(Messages.getString((String)"HighlightsPreferencePage.text.Edit"));
        data = new GridData(128);
        data.widthHint = Math.max(this.fEditButton.computeSize((int)-1, (int)-1).x, 60);
        this.fEditButton.setLayoutData((Object)data);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightsPreferencePage.this.edit();
            }
        });
        this.fDeleteButton = new Button(buttons, 8);
        this.fDeleteButton.setText(Messages.getString((String)"HighlightsPreferencePage.text.Delete"));
        data = new GridData(128);
        data.widthHint = Math.max(this.fDeleteButton.computeSize((int)-1, (int)-1).x, 60);
        this.fDeleteButton.setLayoutData((Object)data);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightsPreferencePage.this.delete();
            }
        });
        this.fMoveUpButton = new Button(buttons, 8);
        this.fMoveUpButton.setText(Messages.getString((String)"FormPage.Button.Up"));
        this.fMoveUpButton.setToolTipText(Messages.getString((String)"HighlightsPreferencePage.toolTipText.Up"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fMoveUpButton.computeSize((int)-1, (int)-1).x, 60);
        this.fMoveUpButton.setLayoutData((Object)data);
        this.fMoveUpButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HighlightsPreferencePage.this.moveUp();
            }
        });
        this.fMoveDownButton = new Button(buttons, 8);
        this.fMoveDownButton.setText(Messages.getString((String)"FormPage.Button.Down"));
        this.fMoveDownButton.setToolTipText(Messages.getString((String)"HighlightsPreferencePage.toolTipText.Down"));
        data = new GridData(768);
        data.widthHint = Math.max(this.fMoveDownButton.computeSize((int)-1, (int)-1).x, 60);
        this.fMoveDownButton.setLayoutData((Object)data);
        this.fMoveDownButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HighlightsPreferencePage.this.moveDown();
            }
        });
        this.fTableViewer.setInput(this.model);
        this.refreshTableItemView();
        this.updateButtons();
        Dialog.applyDialogFont((Control)parent);
        return innerParent;
    }

    private void refreshTableItemView() {
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            TableItem ti = this.fTableViewer.getTable().getItem(i);
            HighlightRuleHandle handle = (HighlightRuleHandle)ti.getData();
            if (handle.getColor().isSet()) {
                ti.setForeground(0, ColorManager.getColor((int)handle.getColor().getRGB()));
            }
            ti.setText(0, this.provider.getColumnText(handle, 0));
            ti.setText(1, this.provider.getColumnText(handle, 1));
            ++i;
        }
        this.fTableViewer.getTable().setFocus();
    }

    private void updateButtons() {
        this.fEditButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fDeleteButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveUpButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() > 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveDownButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount() - 1);
    }

    private void add() {
        HighlightRuleBuilder builder = new HighlightRuleBuilder(this.getShell(), Messages.getString((String)"HighlightsPage.Dialog.NewHighlight"), this.provider);
        builder.updateHandle(null, this.fTableViewer.getTable().getItemCount());
        builder.setDesignHandle((DesignElementHandle)this.model);
        if (this.model instanceof ReportItemHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)this.model));
        } else if (this.model instanceof GroupHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)this.model).getContainer()));
        }
        if (builder.open() == 0) {
            this.fTableViewer.add((Object)builder.getHandle());
            int itemCount = this.fTableViewer.getTable().getItemCount();
            this.fTableViewer.getTable().deselectAll();
            this.fTableViewer.getTable().select(itemCount - 1);
            this.fTableViewer.getTable().setFocus();
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    private void edit() {
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
            HighlightRuleBuilder builder = new HighlightRuleBuilder(this.getShell(), Messages.getString((String)"HighlightsPage.Dialog.EditHighlight"), this.provider);
            HighlightRuleHandle handle = (HighlightRuleHandle)this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData();
            builder.updateHandle(handle, this.fTableViewer.getTable().getItemCount());
            builder.setDesignHandle((DesignElementHandle)this.model);
            if (this.model instanceof ReportItemHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)this.model));
            } else if (this.model instanceof GroupHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)this.model).getContainer()));
            }
            if (builder.open() == 0) {
                this.updateButtons();
                this.refreshTableItemView();
            }
        }
    }

    private void delete() {
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
            int idx = this.fTableViewer.getTable().getSelectionIndex();
            try {
                this.provider.doDeleteItem(idx);
                this.fTableViewer.getTable().remove(idx);
                this.fTableViewer.refresh();
                if (idx >= this.fTableViewer.getTable().getItemCount()) {
                    --idx;
                }
                this.fTableViewer.getTable().select(idx);
                this.refreshTableItemView();
            }
            catch (Exception e) {
                WidgetUtil.processError(this.getShell(), e);
            }
            this.updateButtons();
        }
    }

    private void moveUp() {
        int index = this.fTableViewer.getTable().getSelectionIndex();
        try {
            this.provider.doSwapItem(index, -1);
            Object handle = this.fTableViewer.getTable().getItem(index).getData();
            this.fTableViewer.remove(handle);
            this.fTableViewer.insert(handle, index - 1);
            this.fTableViewer.refresh();
            this.fTableViewer.getTable().select(index - 1);
            this.refreshTableItemView();
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        this.updateButtons();
    }

    private void moveDown() {
        int index = this.fTableViewer.getTable().getSelectionIndex();
        try {
            this.provider.doSwapItem(index, 1);
            Object handle = this.fTableViewer.getTable().getItem(index).getData();
            this.fTableViewer.remove(handle);
            this.fTableViewer.insert(handle, index + 1);
            this.fTableViewer.refresh();
            this.fTableViewer.getTable().select(index + 1);
            this.refreshTableItemView();
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        this.updateButtons();
    }

    protected void handleTableKeyPressEvent(KeyEvent e) {
        if (e.keyCode == 127) {
            this.delete();
        }
    }

    protected String[] getPreferenceNames() {
        return new String[0];
    }

    class HighlightContentProvider
    implements IStructuredContentProvider {
        HighlightContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return HighlightsPreferencePage.this.provider.getElements(inputElement);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class HighlightLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        HighlightLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return HighlightsPreferencePage.this.provider.getColumnText(element, columnIndex);
        }
    }
}

