/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.expression;

import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionButtonProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionHelper;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MenuButton;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ExpressionButton {
    private MenuButton button;
    private SelectionAdapter listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget instanceof MenuItem) {
                String exprType = (String)widget.getData();
                ExpressionButton.this.setExpressionType(exprType);
                ExpressionButton.this.provider.handleSelectionEvent(exprType);
                ExpressionButton.this.refresh();
            } else if (widget instanceof MenuButton) {
                ExpressionButton.this.provider.handleSelectionEvent(ExpressionButton.this.getExpressionType());
            }
        }
    };
    private IExpressionHelper helper;
    private IExpressionButtonProvider provider;
    private Menu menu;

    public ExpressionButton(Composite parent, int style) {
        this.button = new MenuButton(parent, style);
        this.button.addSelectionListener((SelectionListener)this.listener);
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        this.button.setDropDownMenu(this.menu);
        this.setExpressionButtonProvider(new ExpressionButtonProvider());
        this.refresh();
    }

    public void setEnabled(boolean enable) {
        this.button.setEnabled(enable);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public MenuButton getControl() {
        return this.button;
    }

    protected void setExpressionType(String exprType) {
        if (this.helper != null && !exprType.equals(this.helper.getExpressionType())) {
            this.helper.setExpressionType(exprType);
        }
    }

    protected String getExpressionType() {
        String type = null;
        if (this.helper != null) {
            type = this.helper.getExpressionType();
        }
        return type != null ? type : "javascript";
    }

    public String getExpression() {
        if (this.helper != null) {
            return this.helper.getExpression();
        }
        return "";
    }

    public void setExpression(String expression) {
        if (expression != null && this.helper != null) {
            this.helper.setExpression(expression);
        }
    }

    protected void openExpressionBuilder() {
        ExpressionBuilder builder = new ExpressionBuilder(this.getExpression());
        if (this.helper != null) {
            builder.setExpressionProvier(this.helper.getExpressionProvider());
        }
        if (builder.open() == 0 && this.helper != null) {
            String oldExpression = this.getExpression();
            String newExpression = builder.getResult();
            this.helper.setExpression(newExpression);
            this.notifyExpressionChangeEvent(oldExpression, newExpression);
        }
    }

    public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
        if (this.helper != null) {
            this.helper.notifyExpressionChangeEvent(oldExpression, newExpression);
        }
    }

    public void setExpressionHelper(IExpressionHelper helper) {
        this.helper = helper;
    }

    public void refresh() {
        this.button.setImage(this.provider.getImage(this.getExpressionType()));
        this.button.setToolTipText(this.provider.getTooltipText(this.getExpressionType()));
    }

    public void setExpressionButtonProvider(IExpressionButtonProvider provider) {
        if (provider != null && provider != this.provider) {
            this.provider = provider;
            provider.setInput(this);
            int i = 0;
            while (i < this.menu.getItemCount()) {
                this.menu.getItem(i).dispose();
                --i;
                ++i;
            }
            String[] types = this.provider.getExpressionTypes();
            int i2 = 0;
            while (i2 < types.length) {
                MenuItem item = new MenuItem(this.menu, 8);
                item.setText(this.provider.getText(types[i2]));
                item.setData((Object)types[i2]);
                item.setImage(this.provider.getImage(types[i2]));
                item.addSelectionListener((SelectionListener)this.listener);
                ++i2;
            }
            this.refresh();
        }
    }
}

