/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.expression;

import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionButtonProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.swt.graphics.Image;

public class ExpressionButtonProvider
implements IExpressionButtonProvider {
    private static final String CONSTANT = Messages.getString((String)"ExpressionButtonProvider.Constant");
    private static final String JAVA_SCRIPT = Messages.getString((String)"ExpressionButtonProvider.Javascript");
    private ExpressionButton input;

    public void setInput(ExpressionButton input) {
        this.input = input;
    }

    public String[] getExpressionTypes() {
        return new String[]{"constant", "javascript"};
    }

    public Image getImage(String exprType) {
        String imageName = null;
        imageName = "constant".equals(exprType) ? (this.input.isEnabled() ? "Enable Expression Constant" : "Disable Expression Constant") : (this.input.isEnabled() ? "Enable Expression Javascript" : "Disable Expression Javasciprt");
        return ReportPlatformUIImages.getImage(imageName);
    }

    public String getText(String exprType) {
        if ("constant".equals(exprType)) {
            return CONSTANT;
        }
        if ("javascript".equals(exprType)) {
            return JAVA_SCRIPT;
        }
        return "";
    }

    public String getTooltipText(String exprType) {
        if ("constant".equals(exprType)) {
            return CONSTANT;
        }
        if ("javascript".equals(exprType)) {
            return JAVA_SCRIPT;
        }
        return "";
    }

    public void handleSelectionEvent(String exprType) {
        if ("javascript".equals(exprType)) {
            this.input.openExpressionBuilder();
        }
    }
}

