/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExportStyleDialog
extends BaseDialog {
    private StyleHandle style;
    private HashMap themeMap;
    private Combo themeCombo;

    public ExportStyleDialog(StyleHandle style, LibraryHandle library) {
        super(Messages.getString((String)"ExportStyleDialog.Title"));
        this.style = style;
        this.themeMap = new HashMap();
        List themes = library.getVisibleThemes(1);
        int i = 0;
        while (i < themes.size()) {
            ThemeHandle theme = (ThemeHandle)themes.get(i);
            this.themeMap.put(theme.getName(), theme);
            ++i;
        }
    }

    protected boolean initDialog() {
        if (this.themeCombo.getItemCount() == 0) {
            this.getOkButton().setEnabled(false);
        } else {
            this.themeCombo.select(0);
        }
        return super.initDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        Label messageLine = new Label(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        messageLine.setLayoutData((Object)gd);
        messageLine.setText(Messages.getString((String)"ExportStyleDialog.Message"));
        new Label(composite, 0).setText(Messages.getString((String)"ExportStyleDialog.Label.Text"));
        this.themeCombo = new Combo(composite, 2060);
        this.themeCombo.setItems(this.themeMap.keySet().toArray(new String[0]));
        gd = new GridData(768);
        this.themeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExportStyleDialog.this.themeCombo.getSelectionIndex() == -1) {
                    ExportStyleDialog.this.getOkButton().setEnabled(false);
                }
            }
        });
        gd.widthHint = 200;
        this.themeCombo.setLayoutData((Object)gd);
        return composite;
    }

    protected void okPressed() {
        ThemeHandle theme = (ThemeHandle)this.themeMap.get(this.themeCombo.getText());
        boolean notExist = ElementExportUtil.canExport((StyleHandle)this.style, (ThemeHandle)theme, (boolean)false);
        this.setResult(new Object[]{theme, notExist});
        super.okPressed();
    }
}

