/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportDesignHandleAdapter;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MultipleEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportElementDragTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class ReportElementEditPart
extends AbstractGraphicalEditPart
implements IModelAdapterHelper {
    private static final int DELAY_TIME = 1600;
    protected DesignElementHandleAdapter peer;
    private AbstractGuideHandle guideHandle = null;
    private boolean isEdited = false;
    protected Logger logger = Logger.getLogger(ReportElementEditPart.class.getName());
    private boolean isDirty = true;

    public ReportElementEditPart(Object model) {
        if (Policy.TRACING_EDITPART_CREATE) {
            String[] result = ((Object)((Object)this)).getClass().getName().split("\\.");
            System.out.println(String.valueOf(result[result.length - 1]) + " >> Created for " + model);
        }
        this.setModel(model);
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.peer = this.creatDesignElementHandleAdapter();
    }

    public DesignElementHandleAdapter creatDesignElementHandleAdapter() {
        HandleAdapterFactory.getInstance().remove(this.getModel());
        return HandleAdapterFactory.getInstance().getDesignElementHandleAdapter(this.getModel(), (IModelAdapterHelper)this);
    }

    public void performRequest(Request request) {
        if (request.getExtendedData().get("newObject from library") != null) {
            return;
        }
        if ("open".equals(request.getType()) || "create element".equals(request.getType())) {
            if (this.isEdited()) {
                return;
            }
            this.setEdited(true);
            try {
                this.performDirectEdit();
            }
            catch (RuntimeException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.setEdited(false);
        }
    }

    public void performDirectEdit() {
    }

    protected boolean isEdited() {
        return this.isEdited;
    }

    protected void setEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    protected AbstractGuideHandle createGuideHandle() {
        EditPart part = this.getParent();
        if (part instanceof ReportElementEditPart) {
            return ((ReportElementEditPart)part).getGuideHandle();
        }
        return null;
    }

    protected AbstractGuideHandle getGuideHandle() {
        if (this.guideHandle == null) {
            this.guideHandle = this.interCreateGuideHandle();
        }
        return this.guideHandle;
    }

    private AbstractGuideHandle interCreateGuideHandle() {
        if (this.getParent() instanceof MultipleEditPart) {
            return ((MultipleEditPart)this.getParent()).createGuideHandle();
        }
        return this.createGuideHandle();
    }

    public void addGuideFeedBack() {
        if (this.guideHandle == null) {
            this.guideHandle = this.interCreateGuideHandle();
        }
        if (this.guideHandle != null && this.guideHandle != this.findHandle()) {
            this.clearGuideHandle();
            this.getHandleLayer().add((IFigure)this.guideHandle);
            this.guideHandle.invalidate();
            this.guideHandle.setCanDeleteGuide(true);
        } else if (this.guideHandle != null && this.guideHandle == this.findHandle()) {
            this.guideHandle.setCanDeleteGuide(false);
        } else if (this.guideHandle != null) {
            this.guideHandle.setCanDeleteGuide(true);
        }
    }

    private AbstractGuideHandle findHandle() {
        IFigure layer = this.getHandleLayer();
        List list = layer.getChildren();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof AbstractGuideHandle) {
                return (AbstractGuideHandle)((Object)obj);
            }
            ++i;
        }
        return null;
    }

    protected void clearGuideHandle() {
        IFigure layer = this.getHandleLayer();
        List list = layer.getChildren();
        ArrayList temp = new ArrayList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof AbstractGuideHandle) {
                temp.add(obj);
            }
            ++i;
        }
        size = temp.size();
        i = 0;
        while (i < size) {
            IFigure figure = (IFigure)temp.get(i);
            layer.remove(figure);
            ++i;
        }
    }

    protected void removeGuideFeedBack() {
        if (this.guideHandle != null && this.guideHandle.getParent() == this.getHandleLayer()) {
            this.getHandleLayer().remove((IFigure)this.guideHandle);
        } else if (this.getParent() instanceof ReportElementEditPart) {
            ((ReportElementEditPart)this.getParent()).removeGuideFeedBack();
        }
        this.guideHandle = null;
    }

    public void delayRemoveGuideFeedBack() {
        if (this.guideHandle != null) {
            this.guideHandle.setCanDeleteGuide(true);
        }
        Display.getCurrent().timerExec(1600, new Runnable(){

            public void run() {
                if (ReportElementEditPart.this.guideHandle != null && ReportElementEditPart.this.guideHandle.isCanDeleteGuide()) {
                    ReportElementEditPart.this.removeGuideFeedBack();
                }
            }
        });
    }

    private IFigure getHandleLayer() {
        super.getLayer((Object)"Handle Layer");
        LayerManager manager = (LayerManager)this.getViewer().getEditPartRegistry().get(LayerManager.ID);
        return manager.getLayer((Object)"Handle Layer");
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.refreshPageClip();
        this.getFigure().addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }

            public void mouseExited(MouseEvent me) {
                ReportElementEditPart.this.delayRemoveGuideFeedBack();
            }

            public void mouseHover(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }

            public void mouseMoved(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }
        });
        this.getFigure().setFocusTraversable(true);
        this.updateLayoutPreference();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.removeGuideFeedBack();
        super.deactivate();
        HandleAdapterFactory.getInstance().remove(this.getModel(), (IModelAdapterHelper)this);
    }

    protected abstract void createEditPolicies();

    public DragTracker getDragTracker(Request req) {
        ReportElementDragTracker track = new ReportElementDragTracker((EditPart)this);
        return track;
    }

    public Rectangle getBounds() {
        return this.getReportElementHandleAdapt().getbounds();
    }

    public void setBounds(Rectangle r) {
        try {
            this.getReportElementHandleAdapt().setBounds(r);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public Point getLocation() {
        return this.getReportElementHandleAdapt().getLocation();
    }

    public void setLocation(Point p) {
        try {
            this.getReportElementHandleAdapt().setLocation(p);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public Dimension getSize() {
        return this.getReportElementHandleAdapt().getSize();
    }

    public void setSize(Dimension d) {
        try {
            this.getReportElementHandleAdapt().setSize(d);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    protected Font getFont(ReportItemHandle handle) {
        return UIUtil.getFont(handle);
    }

    protected Font getFont() {
        return this.getFont((ReportItemHandle)this.getModel());
    }

    public String getDisplayLabel() {
        return null;
    }

    public final void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFigure();
        this.refreshReportChildren(this);
        this.getFigure().repaint();
    }

    public void refreshChildren() {
        super.refreshChildren();
    }

    public void refreshReportChildren(ReportElementEditPart parent) {
        List list = parent.getChildren();
        int i = 0;
        while (i < list.size()) {
            Object part = list.get(i);
            if (part instanceof ReportElementEditPart && !((ReportElementEditPart)((Object)part)).isDelete()) {
                ((ReportElementEditPart)((Object)part)).refreshFigure();
                this.refreshReportChildren((ReportElementEditPart)((Object)part));
            }
            ++i;
        }
    }

    public abstract void refreshFigure();

    protected void refreshMargin() {
        if (this.getFigure() instanceof IReportElementFigure) {
            ((IReportElementFigure)this.getFigure()).setMargin(this.getModelAdapter().getMargin(null));
        }
    }

    protected void refreshBackground(DesignElementHandle handle) {
        this.refreshBackgroundColor(handle);
        this.refreshBackgroundImage(handle);
    }

    protected void refreshBackgroundColor(DesignElementHandle handle) {
        Object obj = handle.getProperty("backgroundColor");
        if (handle instanceof MasterPageHandle) {
            this.getFigure().setOpaque(true);
        } else {
            this.getFigure().setOpaque(false);
        }
        if (obj != null) {
            int color = 0xFFFFFF;
            color = obj instanceof String ? ColorUtil.parseColor((String)((String)obj)) : (Integer)obj;
            this.getFigure().setBackgroundColor(ColorManager.getColor((int)color));
            this.getFigure().setOpaque(true);
        }
    }

    protected void refreshBackgroundImage(DesignElementHandle handle) {
        IReportElementFigure figure = (IReportElementFigure)this.getFigure();
        String backGroundImage = this.getBackgroundImage(handle);
        if (backGroundImage == null) {
            figure.setImage(null);
        } else {
            Image image = null;
            try {
                image = ImageManager.getInstance().getImage(this.getModelAdapter().getModuleHandle(), backGroundImage);
            }
            catch (SWTException sWTException) {
                image = null;
            }
            if (image == null) {
                figure.setImage(null);
                return;
            }
            figure.setImage(image);
            Object[] backGroundPosition = this.getBackgroundPosition(handle);
            int backGroundRepeat = this.getBackgroundRepeat(handle);
            figure.setRepeat(backGroundRepeat);
            Object xPosition = backGroundPosition[0];
            Object yPosition = backGroundPosition[1];
            Rectangle area = this.getFigure().getClientArea();
            org.eclipse.swt.graphics.Rectangle imageArea = image.getBounds();
            Point position = new Point(-1, -1);
            int alignment = 0;
            if (xPosition instanceof Integer) {
                position.x = (Integer)xPosition;
            } else if (xPosition instanceof DimensionValue) {
                int percentX = (int)((DimensionValue)xPosition).getMeasure();
                position.x = (area.width - imageArea.width) * percentX / 100;
            } else if (xPosition instanceof String) {
                alignment |= DesignElementHandleAdapter.getPosition((String)((String)xPosition));
            }
            if (yPosition instanceof Integer) {
                position.y = (Integer)yPosition;
            } else if (yPosition instanceof DimensionValue) {
                int percentY = (int)((DimensionValue)yPosition).getMeasure();
                position.y = (area.width - imageArea.width) * percentY / 100;
            } else if (yPosition instanceof String) {
                alignment |= DesignElementHandleAdapter.getPosition((String)((String)yPosition));
            }
            figure.setAlignment(alignment);
            figure.setPosition(position);
        }
    }

    public void markDirty(boolean bool) {
        this.isDirty = bool;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected DesignElementHandleAdapter getModelAdapter() {
        if (this.peer == null) {
            this.peer = HandleAdapterFactory.getInstance().getDesignElementHandleAdapter(this.getModel(), (IModelAdapterHelper)this);
        }
        return this.peer;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.getFigure().getSize().getCopy();
        return size;
    }

    public Insets getInsets() {
        return new Insets(this.getFigure().getInsets());
    }

    protected ReportItemtHandleAdapter getReportElementHandleAdapt() {
        return (ReportItemtHandleAdapter)this.getModelAdapter();
    }

    protected void refreshPageClip() {
        Object obj;
        if (this.getFigure() instanceof ReportElementFigure && (obj = this.getViewer().getProperty("Layout Size")) instanceof Rectangle) {
            ((ReportElementFigure)this.getFigure()).setPageClip((Rectangle)obj);
        }
    }

    protected void updateBaseBorder(DesignElementHandle handle, BaseBorder border) {
        this.updateBottomBorder(handle, border);
        this.updateTopBorder(handle, border);
        this.updateLeftBorder(handle, border);
        this.updateRightBorder(handle, border);
    }

    protected void updateBottomBorder(DesignElementHandle handle, BaseBorder border) {
        border.bottomColor = handle.getPropertyHandle("borderBottomColor").getIntValue();
        border.bottomStyle = handle.getPropertyHandle("borderBottomStyle").getStringValue();
        border.bottomWidth = handle.getPropertyHandle("borderBottomWidth").getStringValue();
    }

    protected void updateTopBorder(DesignElementHandle handle, BaseBorder border) {
        border.topColor = handle.getPropertyHandle("borderTopColor").getIntValue();
        border.topStyle = handle.getPropertyHandle("borderTopStyle").getStringValue();
        border.topWidth = handle.getPropertyHandle("borderTopWidth").getStringValue();
    }

    protected void updateLeftBorder(DesignElementHandle handle, BaseBorder border) {
        border.leftColor = handle.getPropertyHandle("borderLeftColor").getIntValue();
        border.leftStyle = handle.getPropertyHandle("borderLeftStyle").getStringValue();
        border.leftWidth = handle.getPropertyHandle("borderLeftWidth").getStringValue();
    }

    protected void updateRightBorder(DesignElementHandle handle, BaseBorder border) {
        border.rightColor = handle.getPropertyHandle("borderRightColor").getIntValue();
        border.rightStyle = handle.getPropertyHandle("borderRightStyle").getStringValue();
        border.rightWidth = handle.getPropertyHandle("borderRightWidth").getStringValue();
    }

    protected void refreshBorder(DesignElementHandle handle, BaseBorder border) {
        this.updateBaseBorder(handle, border);
        this.getFigure().setBorder((Border)border);
        this.refreshPageClip();
    }

    protected Insets getMasterPageInsets(DesignElementHandle handle) {
        return ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPageInsets(handle);
    }

    protected Dimension getMasterPageSize(DesignElementHandle handle) {
        return ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPageSize(handle);
    }

    protected int getForegroundColor(DesignElementHandle handle) {
        return this.getModelAdapter().getForegroundColor(handle);
    }

    protected int getBackgroundColor(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundColor(handle);
    }

    protected String getBackgroundImage(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundImage(handle);
    }

    protected Object[] getBackgroundPosition(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundPosition(handle);
    }

    protected int getBackgroundRepeat(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundRepeat(handle);
    }

    protected boolean isFigureLeft(Request request) {
        if (!(request instanceof SelectionRequest)) {
            return true;
        }
        SelectionRequest selctionRequest = (SelectionRequest)request;
        Point p = selctionRequest.getLocation();
        this.getFigure().translateToRelative((Translatable)p);
        Point center = this.getFigure().getBounds().getCenter();
        return center.x >= p.x;
    }

    public boolean isDelete() {
        boolean bool = false;
        if (this.getModel() instanceof DesignElementHandle && !(this.getModel() instanceof ModuleHandle)) {
            bool = ((DesignElementHandle)this.getModel()).getContainer() == null || ((DesignElementHandle)this.getModel()).getRoot() == null;
        }
        return bool;
    }

    public void notifyModelChange() {
        if (this.getParent() != null && this.getParent() instanceof ReportElementEditPart) {
            ((ReportElementEditPart)this.getParent()).notifyModelChange();
        }
    }

    protected void contentChange(Map info) {
        this.markDirty(true);
        this.refresh();
    }

    protected void propertyChange(Map info) {
        this.refreshVisuals();
    }

    public boolean isinterest(Object model) {
        return this.getModel().equals(model);
    }

    public boolean isinterestSelection(Object object) {
        return false;
    }

    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        ReportElementResizablePolicy policy = new ReportElementResizablePolicy();
        policy.setResizeDirections(20);
        return policy;
    }

    public void removeChild(EditPart child) {
        super.removeChild(child);
    }

    public String getGuideLabel() {
        return "";
    }

    protected String getTextDirection() {
        DesignElementHandle handle = (DesignElementHandle)this.getModel();
        return this.getTextDirection(handle);
    }

    protected String getTextDirection(DesignElementHandle handle) {
        return handle.isDirectionRTL() ? "rtl" : "ltr";
    }

    protected void updateLayoutPreference() {
        if (!(this.getModel() instanceof DesignElementHandle)) {
            return;
        }
        ModuleHandle handle = ((DesignElementHandle)this.getModel()).getModuleHandle();
        if (!(handle instanceof ReportDesignHandle)) {
            return;
        }
        if (this.getContentPane().getLayoutManager() instanceof ReportFlowLayout) {
            ((ReportFlowLayout)this.getContentPane().getLayoutManager()).setLayoutPreference(((ReportDesignHandle)handle).getLayoutPreference());
        }
    }

    public boolean isFixLayout() {
        return DEUtil.isFixLayout((Object)this.getModel());
    }
}

