/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies;

import java.util.List;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.designer.core.commands.FlowMoveChildCommand;
import org.eclipse.birt.report.designer.core.commands.PasteCommand;
import org.eclipse.birt.report.designer.core.commands.SetConstraintCommand;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementNonResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IOutsideBorder;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;

public class ReportFlowLayoutEditPolicy
extends FlowLayoutEditPolicy {
    protected Command getAddCommand(Request req) {
        EditPart parent = this.getHost();
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createAddCommand(parent, child, this.getInsertionReference((Request)request)));
            ++i;
        }
        return command.unwrap();
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        return this.getAddCommand((Request)request);
    }

    protected Command createAddCommand(EditPart parent, EditPart child, EditPart insertionReference) {
        Object parentModel = null;
        parentModel = parent.getModel() instanceof ListBandProxy ? ((ListBandProxy)parent.getModel()).getSlotHandle() : parent.getModel();
        if (!(child.getModel() instanceof DesignElementHandle)) {
            return UnexecutableCommand.INSTANCE;
        }
        return new PasteCommand((DesignElementHandle)child.getModel(), parentModel, insertionReference == null ? null : (DesignElementHandle)insertionReference.getModel(), false);
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        return null;
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        EditPart after = this.getInsertionReference((Request)request);
        CreateCommand command = new CreateCommand(request.getExtendedData());
        Object model = this.getHost().getModel();
        if (model instanceof SlotHandle) {
            command.setParent((Object)((SlotHandle)model));
        } else if (model instanceof ListBandProxy) {
            command.setParent((Object)((ListBandProxy)model).getSlotHandle());
        } else {
            command.setParent(model);
        }
        if (after != null) {
            command.setAfter(after.getModel());
        }
        return command;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        Object afterModel = null;
        if (after != null) {
            afterModel = after.getModel();
        }
        FlowMoveChildCommand command = new FlowMoveChildCommand(child.getModel(), afterModel, child.getParent().getModel());
        return command;
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeChildrenCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand resize = new CompoundCommand();
        List children = request.getEditParts();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Command c = this.createChangeConstraintCommand(request, child, this.getConstraintFor(request, child));
            resize.add(c);
            ++i;
        }
        return resize.unwrap();
    }

    protected Point getLayoutOrigin() {
        return this.getLayoutContainer().getClientArea().getLocation();
    }

    protected Object getConstraintFor(Rectangle rect) {
        return new Rectangle(rect);
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, GraphicalEditPart child, Object constraintFor) {
        ReportItemHandle handle = (ReportItemHandle)child.getModel();
        SetConstraintCommand command = new SetConstraintCommand();
        command.setModel(handle);
        int direction = request.getResizeDirection();
        Dimension size = new Dimension(((Rectangle)constraintFor).getSize());
        if (direction == 16 || direction == 8) {
            size.height = -1;
        } else if (direction == 4 || direction == 1) {
            size.width = -1;
        }
        command.setSize(size);
        return command;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Border border;
        IFigure figure = child.getFigure();
        PrecisionRectangle rect = new PrecisionRectangle(figure.getBounds());
        figure.translateToAbsolute((Translatable)rect);
        rect = request.getTransformedRectangle((Rectangle)rect);
        figure.translateToRelative((Translatable)rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        if (figure instanceof IOutsideBorder && (border = ((IOutsideBorder)figure).getOutsideBorder()) != null) {
            Insets insets = border.getInsets(figure);
            rect.shrink(insets.right, insets.bottom);
        }
        return this.getConstraintFor((Rectangle)rect);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        Object retValue = null;
        if (child instanceof ReportElementEditPart) {
            retValue = ((ReportElementEditPart)child).getResizePolice((EditPolicy)this);
        }
        if (retValue == null) {
            retValue = new ReportElementNonResizablePolicy();
        }
        return retValue;
    }

    protected boolean isHorizontal() {
        return true;
    }

    protected void showLayoutTargetFeedback(Request request) {
        GraphicalEditPart ep = (GraphicalEditPart)this.getHost();
        if (this.getHost().getChildren().size() == 0) {
            Rectangle bounds = this.getAbsoluteClientBounds(ep);
            Point p1 = new Point(bounds.x + 5, bounds.y + 2);
            Point p2 = new Point(bounds.x + 5, bounds.y + Math.min(bounds.height - 2, 18));
            this.setTargetFeedbackPoints(p1, p2);
            ep.getViewer().reveal((EditPart)ep);
        } else {
            this.showLayoutTargetPosition(request);
        }
    }

    protected void setTargetFeedbackPoints(Point p1, Point p2) {
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isHorizontal());
        Rectangle parentBox = transposer.t(this.getAbsoluteClientBounds((GraphicalEditPart)this.getHost()));
        Polyline fb = this.getLineFeedback();
        if (p2.y >= parentBox.bottom() && parentBox.bottom() - p1.y < 10) {
            p2.y = p1.y;
            List list = ((GraphicalEditPart)this.getHost()).getChildren();
            int size = list.size();
            if (size == 0) {
                p2.x = p1.x + Math.min(30, parentBox.width);
            } else {
                GraphicalEditPart last = (GraphicalEditPart)list.get(size - 1);
                Rectangle rect = this.getAbsoluteBounds(last);
                p2.x = p1.x + Math.min(rect.width - 8, parentBox.width);
            }
        } else if (p2.y >= parentBox.bottom()) {
            p2.y = parentBox.bottom();
        }
        fb.translateToRelative((Translatable)p1);
        fb.translateToRelative((Translatable)p2);
        fb.setPoint(p1, 0);
        fb.setPoint(p2, 1);
    }

    private boolean isEditPartFigureBlock(EditPart editPart) {
        if (editPart == null || !(editPart.getModel() instanceof ReportItemHandle)) {
            return true;
        }
        ReportItemHandle handle = (ReportItemHandle)editPart.getModel();
        ReportItemConstraint constraint = new ReportItemConstraint();
        constraint.setDisplay(handle.getPrivateStyle().getDisplay());
        return constraint.isBlock();
    }

    protected int getFeedbackIndexFor(Request request) {
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isHorizontal());
        List list = this.getHost().getChildren();
        int size = list.size() - 1;
        int index = this.getFeedbackPosition(request);
        if (size < 0 || index < 0 || index > size) {
            return index;
        }
        Rectangle rect = this.getAbsoluteBounds((GraphicalEditPart)list.get(size));
        Point p = transposer.t(this.getLocationFromRequest(request));
        if (p.y > rect.bottom()) {
            index = -1;
        }
        return index;
    }

    protected int getFeedbackPosition(Request request) {
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isHorizontal());
        Point p = transposer.t(this.getLocationFromRequest(request));
        int rowBottom = Integer.MIN_VALUE;
        int candidate = -1;
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            Rectangle rect = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)child));
            if (rect.y > rowBottom) {
                if (p.y <= rowBottom) {
                    if (candidate != -1) break;
                    candidate = i;
                    break;
                }
                candidate = -1;
            }
            rowBottom = Math.max(rowBottom, rect.bottom());
            if (candidate == -1 && (p.x <= rect.x + rect.width / 2 || p.y < rect.y)) {
                candidate = i;
            }
            if (candidate != -1 && p.y <= rowBottom) break;
            ++i;
        }
        return candidate;
    }

    protected void showLayoutTargetPosition(Request request) {
        EditPart editPart;
        if (this.getHost().getChildren().size() == 0) {
            return;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isHorizontal());
        boolean before = true;
        int epIndex = this.getFeedbackIndexFor(request);
        Rectangle r = null;
        if (epIndex == -1) {
            before = false;
            epIndex = this.getHost().getChildren().size() - 1;
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
        } else {
            editPart = (EditPart)this.getHost().getChildren().get(epIndex);
            boolean isBlock = false;
            if (epIndex == 0) {
                isBlock = true;
            } else {
                EditPart preEditPart = (EditPart)this.getHost().getChildren().get(epIndex - 1);
                isBlock = this.isEditPartFigureBlock(preEditPart);
            }
            r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
            Point p = transposer.t(this.getLocationFromRequest(request));
            if (p.x <= r.x + r.width / 2 && isBlock) {
                before = true;
            } else {
                before = false;
                if (--epIndex >= 0 && epIndex < this.getHost().getChildren().size()) {
                    editPart = (EditPart)this.getHost().getChildren().get(epIndex);
                    r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart));
                }
            }
        }
        int x = Integer.MIN_VALUE;
        if (before) {
            if (epIndex > 0) {
                Rectangle boxPrev = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost().getChildren().get(epIndex - 1)));
                int prevRight = boxPrev.right();
                if (prevRight < r.x) {
                    x = prevRight + (r.x - prevRight) / 2;
                } else if (prevRight == r.x) {
                    x = prevRight + 1;
                }
            }
            if (x == Integer.MIN_VALUE) {
                Rectangle parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
                x = r.x - 5;
                if (x < parentBox.x) {
                    x = parentBox.x + (r.x - parentBox.x) / 2;
                }
            }
        } else {
            EditPart part;
            Rectangle parentBox = transposer.t(this.getAbsoluteClientBounds((GraphicalEditPart)this.getHost()));
            int rRight = r.x + r.width;
            int pRight = parentBox.x + parentBox.width;
            x = rRight + 5;
            int index = epIndex >= 0 ? epIndex : this.getHost().getChildren().size() - 1;
            EditPart editPart2 = part = epIndex < 0 ? null : (EditPart)this.getHost().getChildren().get(epIndex);
            if (x - 4 > pRight || this.isEditPartFigureBlock(part)) {
                if (index >= 0 && index < this.getHost().getChildren().size() - 1) {
                    EditPart editPart3 = (EditPart)this.getHost().getChildren().get(epIndex + 1);
                    r = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)editPart3));
                    parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
                    x = r.x - 5;
                    if (x < parentBox.x) {
                        x = parentBox.x + (r.x - parentBox.x) / 2;
                    }
                } else if (this.getFeedbackIndexFor(request) == 0) {
                    parentBox = transposer.t(this.getAbsoluteBounds((GraphicalEditPart)this.getHost()));
                    x = r.x - 5;
                    if (x < parentBox.x) {
                        x = parentBox.x + (r.x - parentBox.x) / 2;
                    }
                } else {
                    Point p1 = new Point(parentBox.x + 5, r.y + r.height + 2);
                    Point p2 = new Point(parentBox.x + 5, r.y + r.height + 2 + Math.min(parentBox.y + parentBox.height - (r.y + r.height + 2), 18));
                    this.setTargetFeedbackPoints(p1, p2);
                    return;
                }
            }
        }
        Point p1 = new Point(x, r.y - 4);
        p1 = transposer.t(p1);
        Point p2 = new Point(x, r.y + r.height + 4);
        p2 = transposer.t(p2);
        this.setTargetFeedbackPoints(p1, p2);
    }

    private Rectangle getAbsoluteBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getFigure().getBounds().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected Rectangle getAbsoluteClientBounds(GraphicalEditPart ep) {
        Rectangle bounds = ep.getContentPane().getClientArea().getCopy();
        ep.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    protected Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }
}

