/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TableOptionDialog;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.ExtendedElementToolExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.SelectVariableDialog;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreateRequest;

public class BasePaletteFactory {
    private static final String POINTER_SELECT_LABEL = Messages.getString((String)"BasePaletteFactory.categoryName.PointerSelect");
    private static final String RECTANGEL_SELECT_LABEL = Messages.getString((String)"BasePaletteFactory.categoryName.RectangleSelect");
    private static final String TOOL_TIP_POINTER_SELECT = Messages.getString((String)"BasePaletteFactory.toolTip.PointerSelect");
    private static final String TOOL_TIP_RECTANGLE_SELECT = Messages.getString((String)"BasePaletteFactory.toolTip.RectangleSelect");
    private static final String PALETTE_GROUP_TEXT = Messages.getString((String)"BasePaletteFactory.Group.Items");
    private static final String AUTOTEXT_LABEL_PAGE_X_OF_Y = Messages.getString((String)"BasePaletteFactory.AutoTextLabel.PageXofY");
    private static final String AUTOTEXT_LABEL_PAGE_COUNT = Messages.getString((String)"BasePaletteFactory.AutoTextLabel.PageCount");
    private static final String AUTOTEXT_LABEL_LAST_PRINTED = Messages.getString((String)"BasePaletteFactory.AutoTextLabel.LastPrinted");
    private static final String AUTOTEXT_LABEL_FILENAME = Messages.getString((String)"BasePaletteFactory.AutoTextLabel.Filename");
    private static final String AUTOTEXT_LABEL_CREATE_BY = Messages.getString((String)"BasePaletteFactory.AutoTextLabel.CreatedBy");
    private static final String AUTOTEXT_LABEL_CREATE_ON = Messages.getString((String)"BasePaletteFactory.AutoTextLabel.CreatedOn");
    private static final String AUTOTEXT_LABEL_PAGE = Messages.getString((String)"BasePaletteFactory.AutoTextLabel.Page");
    private static final String AUTOTEXT_TEXT_CONFIDENTIAL = Messages.getString((String)"BasePaletteFactory.AutoText.Confidential");

    protected static PaletteRoot createPalette() {
        PaletteRoot root = new PaletteRoot();
        root.add((PaletteEntry)BasePaletteFactory.createControlGroup(root));
        return root;
    }

    protected static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup(PALETTE_GROUP_TEXT);
        ArrayList<PanningSelectionToolEntry> entries = new ArrayList<PanningSelectionToolEntry>();
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry(POINTER_SELECT_LABEL, TOOL_TIP_POINTER_SELECT);
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry(RECTANGEL_SELECT_LABEL, TOOL_TIP_RECTANGLE_SELECT);
        entries.add(tool);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    public static AbstractToolHandleExtends getAbstractToolHandleExtendsFromPaletteName(Object str) {
        if (!(str instanceof String)) {
            throw new Error("Don't support the other type expect String");
        }
        String template = (String)str;
        AbstractToolHandleExtends preHandle = null;
        if ("Image".equalsIgnoreCase(template)) {
            preHandle = new ImageToolExtends();
        } else if ("Table".equalsIgnoreCase(template)) {
            preHandle = new TableToolExtends();
        } else if ("Text".equalsIgnoreCase(template) || "Date".equalsIgnoreCase(template) || "Created on".equalsIgnoreCase(template) || "Created by".equalsIgnoreCase(template) || "Filename".equalsIgnoreCase(template) || "Last printed".equalsIgnoreCase(template)) {
            preHandle = new TextToolExtends();
        } else if ("Page".equalsIgnoreCase(template) || "TotalPageCount".equalsIgnoreCase(template)) {
            preHandle = new AutoTextToolExtends();
        } else if ("TextData".equalsIgnoreCase(template)) {
            preHandle = new TextDataToolExtends();
        } else if ("AuthorPageDate".equalsIgnoreCase(template) || "ConfidentalPage".equalsIgnoreCase(template) || "Grid".equalsIgnoreCase(template) || "Page X of Y".equalsIgnoreCase(template)) {
            preHandle = new GridToolExtends();
        } else if ("Label".equalsIgnoreCase(template)) {
            preHandle = new LabelToolExtends();
        } else if ("Data".equalsIgnoreCase(template)) {
            preHandle = new DataToolExtends();
        } else if ("List".equalsIgnoreCase(template)) {
            preHandle = new ListToolExtends();
        } else if (template.startsWith("Extended")) {
            String extensionName = template.substring("Extended".length());
            preHandle = new ExtendedElementToolExtends(extensionName);
        } else if ("variable".equalsIgnoreCase(template)) {
            preHandle = new VariableToolExtends();
        }
        if (preHandle == null) {
            throw new Error("Don't find the AbstractToolHandleExtends");
        }
        return preHandle;
    }

    public static class AutoTextToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            CreateRequest request = this.getRequest();
            AutoTextHandle autoTextItemHandle = DesignElementFactory.getInstance().newAutoText(null);
            try {
                if ("Page".equalsIgnoreCase((String)request.getNewObjectType())) {
                    autoTextItemHandle.setAutoTextType("page-number");
                } else if ("TotalPageCount".equalsIgnoreCase((String)request.getNewObjectType())) {
                    autoTextItemHandle.setAutoTextType("total-page");
                }
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
            this.setModel(autoTextItemHandle);
            return super.preHandleMouseUp();
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class DataSetColumnToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            if (this.getRequest().getNewObjectType() instanceof DataSetItemModel || this.getRequest().getNewObjectType() instanceof ResultSetColumnHandle) {
                DesignElementHandle newHandle;
                block4: {
                    newHandle = InsertInLayoutUtil.performInsert(this.getRequest().getNewObject(), this.getTargetEditPart());
                    if (newHandle != null) break block4;
                    return false;
                }
                try {
                    this.setModel(newHandle);
                    return super.preHandleMouseUp();
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class DataSetToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            if (this.getRequest().getNewObjectType() instanceof DataSetHandle) {
                DesignElementHandle newHandle;
                block9: {
                    Object newObj = this.getRequest().getNewObject();
                    if (newObj instanceof Object[] && ((Object[])newObj).length > 0) {
                        newObj = ((Object[])newObj)[0];
                    }
                    DesignElementHandle elementHandle = (DesignElementHandle)newObj;
                    ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    if (elementHandle.getRoot() instanceof LibraryHandle && elementHandle.getRoot() != moduleHandle) {
                        LibraryHandle library = (LibraryHandle)elementHandle.getRoot();
                        try {
                            if (UIUtil.includeLibrary(moduleHandle, library)) {
                                elementHandle = moduleHandle.getElementFactory().newElementFrom(elementHandle, elementHandle.getName());
                                moduleHandle.addElement(elementHandle, moduleHandle.getDataSets().getSlotID());
                            }
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(e);
                        }
                    }
                    if ((newHandle = InsertInLayoutUtil.performInsert(elementHandle, this.getTargetEditPart())) != null) break block9;
                    return false;
                }
                try {
                    this.setModel(newHandle);
                    return super.preHandleMouseUp();
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class DataToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            CreateRequest request = this.getRequest();
            if ("Data".equalsIgnoreCase((String)request.getNewObjectType())) {
                DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
                this.setModel(dataHandle);
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class DimensionHandleToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            if (this.getRequest().getNewObjectType() instanceof DimensionHandle) {
                DesignElementHandle elementHandle;
                Object newObj = this.getRequest().getNewObject();
                if (newObj instanceof Object[] && ((Object[])newObj).length > 0) {
                    newObj = ((Object[])newObj)[0];
                }
                if ((elementHandle = (DesignElementHandle)newObj) == null) {
                    return false;
                }
                this.setModel(elementHandle);
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class GridToolExtends
    extends AbstractToolHandleExtends {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean preHandleMouseUp() {
            ModuleHandle reportDesignHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
            DesignElementFactory factory = DesignElementFactory.getInstance(reportDesignHandle);
            String type = (String)this.getRequest().getNewObjectType();
            GridHandle grid = null;
            if ("Page X of Y".equals(type)) {
                grid = factory.newGridItem(null, 3, 1);
                try {
                    List cellList = ((RowHandle)grid.getRows().get(0)).getCells().getContents();
                    AutoTextHandle autoTextHandle = factory.newAutoText(null);
                    autoTextHandle.setAutoTextType("page-number");
                    ((CellHandle)cellList.get(0)).getContent().add((DesignElementHandle)autoTextHandle);
                    TextItemHandle textHandle = factory.newTextItem(null);
                    textHandle.setContent("/");
                    textHandle.setContentType("plain");
                    ((CellHandle)cellList.get(1)).getContent().add((DesignElementHandle)textHandle);
                    autoTextHandle = factory.newAutoText(null);
                    autoTextHandle.setAutoTextType("total-page");
                    ((CellHandle)cellList.get(2)).getContent().add((DesignElementHandle)autoTextHandle);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            } else if ("AuthorPageDate".equals(type)) {
                grid = factory.newGridItem(null, 3, 1);
                try {
                    List cellList = ((RowHandle)grid.getRows().get(0)).getCells().getContents();
                    TextItemHandle textHandle = factory.newTextItem(null);
                    String text = AUTOTEXT_LABEL_CREATE_BY;
                    if (reportDesignHandle.getAuthor() != null) {
                        text = String.valueOf(text) + reportDesignHandle.getAuthor();
                    }
                    textHandle.setContent(text);
                    ((CellHandle)cellList.get(0)).getContent().add((DesignElementHandle)textHandle);
                    AutoTextHandle autoTextHandle = factory.newAutoText(null);
                    autoTextHandle.setAutoTextType("page-number");
                    ((CellHandle)cellList.get(1)).getContent().add((DesignElementHandle)autoTextHandle);
                    textHandle = factory.newTextItem(null);
                    textHandle.setContent("<value-of>new Date()</value-of>");
                    textHandle.setContentType("html");
                    ((CellHandle)cellList.get(2)).getContent().add((DesignElementHandle)textHandle);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            } else if ("ConfidentalPage".equals(type)) {
                grid = factory.newGridItem(null, 2, 1);
                try {
                    List cellList = ((RowHandle)grid.getRows().get(0)).getCells().getContents();
                    TextItemHandle textHandle = factory.newTextItem(null);
                    textHandle.setContent(AUTOTEXT_TEXT_CONFIDENTIAL);
                    textHandle.setContentType("html");
                    ((CellHandle)cellList.get(0)).getContent().add((DesignElementHandle)textHandle);
                    AutoTextHandle autoTextHandle = factory.newAutoText(null);
                    autoTextHandle.setAutoTextType("page-number");
                    ((CellHandle)cellList.get(1)).getContent().add((DesignElementHandle)autoTextHandle);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            } else {
                if (!"Grid".equals(type)) return false;
                TableOptionDialog dlg = new TableOptionDialog(UIUtil.getDefaultShell(), false);
                if (dlg.open() != 0 || !(dlg.getResult() instanceof Object[])) return false;
                Object[] data = (Object[])dlg.getResult();
                grid = factory.newGridItem(null, (Integer)data[1], (Integer)data[0]);
            }
            InsertInLayoutUtil.setInitWidth(grid);
            this.setModel(grid);
            return super.preHandleMouseUp();
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class ImageToolExtends
    extends AbstractToolHandleExtends {
        private List dataSetList = new ArrayList();

        private DesignElementHandle getDesignElementHandle() {
            Object model = this.getTargetEditPart().getModel();
            DesignElementHandle desginElementHandle = null;
            if (model instanceof DesignElementHandle) {
                desginElementHandle = (DesignElementHandle)model;
            } else if (model instanceof ListBandProxy) {
                desginElementHandle = ((ListBandProxy)model).getSlotHandle().getElementHandle();
            }
            return desginElementHandle;
        }

        public boolean preHandleMouseUp() {
            ImageHandle dataHandle = DesignElementFactory.getInstance().newImage(null);
            this.setModel(dataHandle);
            return super.preHandleMouseUp();
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class LabelToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            CreateRequest request = this.getRequest();
            if ("Label".equalsIgnoreCase((String)request.getNewObjectType())) {
                LabelHandle labelItemHandle = DesignElementFactory.getInstance().newLabel(null);
                this.setModel(labelItemHandle);
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class ListToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            CreateRequest request = this.getRequest();
            if ("List".equalsIgnoreCase((String)request.getNewObjectType())) {
                ListHandle list = DesignElementFactory.getInstance().newList(null);
                this.setModel(list);
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class MeasureHandleToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            if (this.getRequest().getNewObjectType() instanceof MeasureHandle) {
                DesignElementHandle elementHandle;
                Object newObj = this.getRequest().getNewObject();
                if (newObj instanceof Object[] && ((Object[])newObj).length > 0) {
                    newObj = ((Object[])newObj)[0];
                }
                if ((elementHandle = (DesignElementHandle)newObj) == null) {
                    return false;
                }
                this.setModel(elementHandle);
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class ParameterToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            if (this.getRequest().getNewObjectType() instanceof ScalarParameterHandle) {
                DesignElementHandle newHandle;
                block11: {
                    Object[] newObj = this.getRequest().getNewObject();
                    if (newObj instanceof Object[]) {
                        Object[] newObjs = newObj;
                        Object[] insertedObjs = new Object[newObjs.length];
                        int i = 0;
                        while (i < newObjs.length) {
                            block10: {
                                block9: {
                                    LibraryHandle library;
                                    ModuleHandle moduleHandle;
                                    DesignElementHandle elementHandle = (DesignElementHandle)newObjs[i];
                                    if (elementHandle.getRoot() instanceof LibraryHandle && (moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle()) != (library = (LibraryHandle)elementHandle.getRoot())) {
                                        try {
                                            if (!UIUtil.includeLibrary(moduleHandle, library)) break block9;
                                            elementHandle = moduleHandle.getElementFactory().newElementFrom(elementHandle, elementHandle.getName());
                                            moduleHandle.addElement(elementHandle, 1);
                                            insertedObjs[i] = elementHandle;
                                            break block10;
                                        }
                                        catch (Exception e) {
                                            ExceptionHandler.handle(e);
                                        }
                                    }
                                }
                                insertedObjs[i] = newObjs[i];
                            }
                            ++i;
                        }
                        newObj = insertedObjs;
                    }
                    if ((newHandle = InsertInLayoutUtil.performInsert(newObj, this.getTargetEditPart())) != null) break block11;
                    return false;
                }
                try {
                    this.setModel(newHandle);
                    return super.preHandleMouseUp();
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class TableToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            TableOptionDialog dlg;
            CreateRequest request = this.getRequest();
            if ("Table".equalsIgnoreCase((String)request.getNewObjectType()) && (dlg = new TableOptionDialog(UIUtil.getDefaultShell(), true)).open() == 0 && dlg.getResult() instanceof Object[]) {
                Object[] data = (Object[])dlg.getResult();
                TableHandle table = DesignElementFactory.getInstance().newTableItem(null, (Integer)data[1], 1, (Integer)data[0], 1);
                InsertInLayoutUtil.setInitWidth(table);
                if (data[2] != null) {
                    try {
                        DataSetHandle dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(data[2].toString());
                        table.setDataSet(dataSet);
                        DataSetColumnBindingsFormHandleProvider provider = new DataSetColumnBindingsFormHandleProvider();
                        provider.setBindingObject((ReportElementHandle)table);
                        provider.generateAllBindingColumns();
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                }
                this.setModel(table);
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class TextDataToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            CreateRequest request = this.getRequest();
            if ("TextData".equalsIgnoreCase((String)request.getNewObjectType())) {
                TextDataHandle textItemHandle = DesignElementFactory.getInstance().newTextData(null);
                try {
                    textItemHandle.setContentType("html");
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                    return false;
                }
                this.setModel(textItemHandle);
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class TextToolExtends
    extends AbstractToolHandleExtends {
        private static final String DEFAULT_AUTHOR = Messages.getString((String)"TextExtendsTools.Message.DefaultAuthor");

        public boolean preHandleMouseUp() {
            TextItemHandle textItemHandle;
            String text;
            block11: {
                String type = (String)this.getRequest().getNewObjectType();
                text = null;
                ModuleHandle reportHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                textItemHandle = DesignElementFactory.getInstance().newTextItem(null);
                if ("Date".equalsIgnoreCase(type)) {
                    text = "<value-of>new Date()</value-of>";
                    textItemHandle.setContentType("html");
                    break block11;
                }
                if ("Created on".equalsIgnoreCase(type)) {
                    text = String.valueOf(AUTOTEXT_LABEL_CREATE_ON) + "<value-of>new Date()</value-of>";
                    textItemHandle.setContentType("html");
                    break block11;
                }
                if ("Created by".equalsIgnoreCase(type)) {
                    text = AUTOTEXT_LABEL_CREATE_BY;
                    String author = reportHandle.getAuthor();
                    if (author != null) {
                        text = String.valueOf(text) + author;
                    } else {
                        String pluginVersion = (String)ReportPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
                        text = String.valueOf(text) + DEFAULT_AUTHOR + " " + pluginVersion;
                    }
                    break block11;
                }
                if ("Filename".equalsIgnoreCase(type)) {
                    text = String.valueOf(AUTOTEXT_LABEL_FILENAME) + reportHandle.getFileName();
                    break block11;
                }
                if ("Last printed".equalsIgnoreCase(type)) {
                    text = String.valueOf(AUTOTEXT_LABEL_LAST_PRINTED) + "<value-of>new Date()</value-of>";
                    textItemHandle.setContentType("html");
                    break block11;
                }
                if ("Text".equalsIgnoreCase(type)) break block11;
                return false;
            }
            try {
                if (text != null) {
                    textItemHandle.setContent(text);
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
            this.setModel(textItemHandle);
            return super.preHandleMouseUp();
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }

    public static class VariableToolExtends
    extends AbstractToolHandleExtends {
        public boolean preHandleMouseUp() {
            CreateRequest request = this.getRequest();
            if ("variable".equalsIgnoreCase((String)request.getNewObjectType())) {
                SelectVariableDialog dialog;
                ModuleHandle reportHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                if (reportHandle instanceof ReportDesignHandle && (dialog = new SelectVariableDialog((ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle())).open() == 0) {
                    AutoTextHandle autoTextItemHandle = DesignElementFactory.getInstance().newAutoText(null);
                    try {
                        autoTextItemHandle.setPageVariable((String)dialog.getResult());
                        autoTextItemHandle.setAutoTextType("page-variable");
                        this.setModel(autoTextItemHandle);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                return super.preHandleMouseUp();
            }
            return false;
        }

        public boolean preHandleMouseDown() {
            return false;
        }
    }
}

