/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IDimensionValueChangedListener;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ComplexUnit
extends Canvas {
    private NumberFormatter formatter = new NumberFormatter(SessionHandleAdapter.getInstance().getSessionHandle().getULocale());
    private Text text;
    private CCombo combo;
    private double minimum = 0.0;
    private double maximum = Double.MAX_VALUE;
    private double step = 1.0;
    private boolean dirty = false;
    private List valueChangedlisteners = new ArrayList();
    private List modifyListeners = new ArrayList();
    private double validValue;
    private static final String DLG_TITLE_INVALID_NUMBER = Messages.getString((String)"Spinner.DialogTitle.InvalidNumber");
    boolean hasFocus;
    private GridLayout layout = new GridLayout();
    private int digit = 3;
    private Listener filter;

    public ComplexUnit(Composite parent, int style) {
        super(parent, 0);
        this.layout.numColumns = 2;
        this.layout.horizontalSpacing = 2;
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        this.setLayout((Layout)this.layout);
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        if ((style & 0x800) != 0) {
            textStyle |= 0x800;
        }
        this.text = new Text((Composite)this, textStyle);
        this.combo = new CCombo((Composite)this, textStyle | 8);
        GridData gd = new GridData(1808);
        this.text.setLayoutData((Object)gd);
        gd = new GridData(1040);
        this.combo.setLayoutData((Object)gd);
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 4) {
                    ComplexUnit.this.fireValueChanged();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    ComplexUnit.this.up();
                    e.doit = false;
                }
                if (e.keyCode == 0x1000002) {
                    ComplexUnit.this.down();
                    e.doit = false;
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComplexUnit.this.dirty = true;
                ComplexUnit.this.fireTextModified(e);
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComplexUnit.this.dirty = true;
            }
        });
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 4) {
                    ComplexUnit.this.fireValueChanged();
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    ComplexUnit.this.fireValueChanged();
                }
                if (e.detail == 2 || e.detail == 32 || e.detail == 64) {
                    e.doit = false;
                }
            }
        });
        this.combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    ComplexUnit.this.fireValueChanged();
                }
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        FocusListener focusListner = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ComplexUnit.this.handleFocus(15);
            }

            public void focusLost(FocusEvent e) {
                ComplexUnit.this.handleFocus(16);
            }
        };
        this.text.addFocusListener(focusListner);
        this.combo.addFocusListener(focusListner);
        this.text.setFont(this.getFont());
        this.combo.setFont(this.getFont());
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                if (ComplexUnit.this.isDisposed()) {
                    return;
                }
                Shell shell = ((Control)event.widget).getShell();
                if (shell == ComplexUnit.this.getShell()) {
                    ComplexUnit.this.handleFocus(16);
                }
            }
        };
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display display = ComplexUnit.this.getDisplay();
                display.removeFilter(15, ComplexUnit.this.filter);
            }
        });
    }

    public void addValueChangeListener(IDimensionValueChangedListener listener) {
        this.valueChangedlisteners.add(listener);
    }

    public void removeValueChangedListener(IDimensionValueChangedListener listener) {
        this.valueChangedlisteners.remove(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    protected void fireValueChanged() {
        if (!this.verify(this.text.getText())) {
            return;
        }
        int i = 0;
        while (i < this.valueChangedlisteners.size()) {
            String value = this.text.getText().trim();
            value = value.length() == 0 ? null : value;
            ((IDimensionValueChangedListener)this.valueChangedlisteners.get(i)).valueChanged(value, this.getUnit());
            ++i;
        }
    }

    protected void fireTextModified(ModifyEvent e) {
        int i = 0;
        while (i < this.modifyListeners.size()) {
            ((ModifyListener)this.modifyListeners.get(i)).modifyText(e);
            ++i;
        }
    }

    protected void up() {
        this.setValue(this.getValue() + this.step);
    }

    protected void down() {
        this.setValue(this.getValue() - this.step);
    }

    public double getValue() {
        try {
            return this.parse(this.text.getText());
        }
        catch (ParseException e) {
            ExceptionHandler.handle(e);
            return this.minimum;
        }
    }

    private double parse(String value) throws ParseException {
        if (StringUtil.isBlank((String)value)) {
            return 0.0;
        }
        return this.formatter.parse(value).doubleValue();
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public String getUnit() {
        if (!this.combo.isDisposed()) {
            return this.combo.getText().trim().length() == 0 ? null : this.combo.getText();
        }
        return null;
    }

    public String[] getUnits() {
        if (!this.combo.isDisposed()) {
            return this.combo.getItems();
        }
        return null;
    }

    public int getUnitSelectionIndex() {
        if (!this.combo.isDisposed()) {
            return this.combo.getSelectionIndex();
        }
        return -1;
    }

    public void selectUnit(int index) {
        if (!this.combo.isDisposed()) {
            this.combo.select(index);
        }
    }

    public void setUnit(String unit) {
        if (!this.combo.isDisposed()) {
            this.combo.setText(unit);
        }
    }

    public void setUnits(String[] units) {
        if (!this.combo.isDisposed()) {
            this.combo.removeAll();
            this.combo.setItems(units);
            this.layout();
        }
    }

    public void setValue(double selection) {
        if (selection < this.minimum) {
            selection = this.minimum;
        } else if (selection > this.maximum) {
            selection = this.maximum;
        }
        this.text.setText(StringUtil.doubleToString((double)selection, (int)this.digit, (ULocale)SessionHandleAdapter.getInstance().getSessionHandle().getULocale()));
        this.validValue = selection;
    }

    private boolean verify(String value) {
        block6: {
            try {
                if (value.trim().length() != 0) break block6;
                return true;
            }
            catch (ParseException ex) {
                ExceptionHandler.openErrorMessageBox(DLG_TITLE_INVALID_NUMBER, ex.getLocalizedMessage());
                this.text.setText(StringUtil.doubleToString((double)this.validValue, (int)this.digit, (ULocale)SessionHandleAdapter.getInstance().getSessionHandle().getULocale()));
                if (!this.text.isDisposed()) {
                    this.handleFocus(15);
                }
                return false;
            }
        }
        this.validValue = this.parse(value);
        if (this.validValue < this.minimum) {
            this.validValue = this.minimum;
        }
        if (this.validValue > this.maximum) {
            this.validValue = this.maximum;
        }
        this.text.setText(StringUtil.doubleToString((double)this.validValue, (int)this.digit, (ULocale)SessionHandleAdapter.getInstance().getSessionHandle().getULocale()));
        return true;
    }

    void handleFocus(int type) {
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.dirty = false;
                this.hasFocus = true;
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.text || focusControl == this.combo) {
                    return;
                }
                if (focusControl != null) {
                    Composite parent = focusControl.getParent();
                    while (parent != null) {
                        if (parent == this) {
                            return;
                        }
                        parent = parent.getParent();
                    }
                }
                this.hasFocus = false;
                if (this.dirty) {
                    this.fireValueChanged();
                }
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
            }
        }
    }

    public void deselectUnit() {
        if (!this.combo.isDisposed()) {
            this.combo.deselectAll();
        }
    }

    public void setReadOnly(boolean b) {
        this.combo.setEnabled(!b);
        this.text.setEditable(!b);
    }

    public boolean isReadOnly() {
        return this.text.getEditable();
    }

    public int getDigit() {
        return this.digit;
    }

    public void setDigit(int digit) {
        this.digit = digit;
    }

    public String getText() {
        if (!this.text.isDisposed()) {
            return this.text.getText();
        }
        return null;
    }

    public void setValue(String value) {
        if (this.verify(value)) {
            this.text.setText(value);
        }
    }
}

