/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IComboProvider;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ImageLabel;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public final class StyleCombo
extends Composite {
    int visibleItemCount;
    Shell popup;
    Button arrow;
    boolean hasFocus;
    Listener listener;
    Color foreground;
    Color background;
    Font font;
    Table table;
    ImageLabel label;
    int imageHeight;
    int imageWidth;
    IComboProvider provider;
    private int computeSizeWidth;

    public StyleCombo(Composite parent, int style, IComboProvider provider) {
        style = StyleCombo.checkStyle(style);
        super(parent, style);
        this.visibleItemCount = 4;
        this.computeSizeWidth = -1;
        assert (provider != null);
        this.provider = provider;
        this.label = new ImageLabel(this, 0);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button((Composite)this, arrowStyle);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (StyleCombo.this.popup == event.widget) {
                    StyleCombo.this.popupEvent(event);
                    return;
                }
                if (StyleCombo.this.label == event.widget) {
                    StyleCombo.this.labelEvent(event);
                    return;
                }
                if (StyleCombo.this.table == event.widget) {
                    StyleCombo.this.tableEvent(event);
                    return;
                }
                if (StyleCombo.this.arrow == event.widget) {
                    StyleCombo.this.arrowEvent(event);
                    return;
                }
                if (StyleCombo.this == event.widget) {
                    StyleCombo.this.comboEvent(event);
                    return;
                }
            }
        };
        int[] comboEvents = new int[]{12, 10, 11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], this.listener);
            ++i;
        }
        int[] arrowEvents = new int[]{13, 15, 16};
        int i2 = 0;
        while (i2 < arrowEvents.length) {
            this.arrow.addListener(arrowEvents[i2], this.listener);
            ++i2;
        }
        int[] textEvents = new int[]{1, 2, 24, 3, 4, 31, 15, 16};
        int i3 = 0;
        while (i3 < textEvents.length) {
            this.label.addListener(textEvents[i3], this.listener);
            ++i3;
        }
        this.createPopup(null, -1);
        this.initAccessible();
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = StyleCombo.this.getAssociatedLabel();
                if (label != null) {
                    name = StyleCombo.this.stripMnemonic(label.getText());
                }
                e.result = name;
                if (e.result == null) {
                    this.getHelp(e);
                }
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = StyleCombo.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = StyleCombo.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = StyleCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.label.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = StyleCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = StyleCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = StyleCombo.this.toControl(new Point(e.x, e.y));
                e.childID = StyleCombo.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = StyleCombo.this.getBounds();
                Point pt = StyleCombo.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = StyleCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this && i > 0 && siblings[i - 1] instanceof Label) {
                return (Label)siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    static int checkStyle(int style) {
        int mask = 0x6800808;
        return style & mask;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (StyleCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = StyleCombo.this.getDisplay().getFocusControl();
                        if (focusControl == StyleCombo.this.arrow || focusControl == StyleCombo.this.label || focusControl == StyleCombo.this.table) {
                            return;
                        }
                        StyleCombo.this.hasFocus = false;
                        Event e = new Event();
                        StyleCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.table.deselectAll();
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.table.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                this.disposeImages();
                this.popup = null;
                this.label = null;
                this.table = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint > -1) {
            this.computeSizeWidth = wHint;
        }
        int width = 0;
        int height = 0;
        GC gc = new GC((Drawable)this.label);
        Point labelExtent = gc.textExtent("AAAAAAAAAAAAA");
        gc.dispose();
        Point labelSize = this.label.computeSize(labelExtent.x, labelExtent.y, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(labelSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(this.computeSizeWidth, labelSize.x + arrowSize.x + 2 * borderWidth);
        return new Point(width, height);
    }

    void createPopup(Object[] items, int selectionIndex) {
        this.popup = new Shell(this.getShell(), 16392);
        this.table = new Table((Composite)this.popup, 66052);
        new TableColumn(this.table, 16384);
        if (this.font != null) {
            this.table.setFont(this.font);
        }
        if (this.foreground != null) {
            this.table.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.table.setBackground(this.background);
        }
        this.label.setBackground(this.table.getBackground());
        this.label.setForeground(this.table.getForeground());
        this.label.setFont(this.table.getFont());
        int[] popupEvents = new int[]{21, 9, 27};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        int[] tableEvents = new int[]{4, 13, 31, 1, 2, 15, 16, 12};
        int i2 = 0;
        while (i2 < tableEvents.length) {
            this.table.addListener(tableEvents[i2], this.listener);
            ++i2;
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        this.label.setImage(null);
        this.table.deselect(index);
    }

    public void deselectAll() {
        this.checkWidget();
        this.label.setImage(null);
        this.table.deselectAll();
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            this.label.forceFocus();
            this.label.setFocus();
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            Object[] items = this.provider.getItems();
            int selectionIndex = this.table.getSelectionIndex();
            this.table.removeListener(12, this.listener);
            this.popup.dispose();
            this.disposeImages();
            this.popup = null;
            this.table = null;
            this.createPopup(items, selectionIndex);
        }
        Point size = this.computeSize(-1, -1);
        int itemCount = this.table.getItemCount();
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount);
        int itemHeight = this.table.getItemHeight() * itemCount;
        this.table.getColumn(0).setWidth(0);
        Point tableSize = this.table.computeSize(-1, itemHeight);
        this.table.setBounds(1, 1, Math.max(size.x - 2, tableSize.x), tableSize.y);
        this.table.getColumn(0).setWidth(this.table.getClientArea().width);
        int index = this.table.getSelectionIndex();
        if (index != -1) {
            this.table.setTopIndex(index);
        }
        Display display = this.getDisplay();
        Rectangle listRect = this.table.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(comboSize.x, listRect.width + 2);
        int height = listRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        this.popup.setBounds(x, y, width, height);
        this.popup.setVisible(true);
        this.table.setFocus();
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public Object getItem(int index) {
        this.checkWidget();
        return this.provider.getDisplayItems()[index];
    }

    public Object getSelectedItem() {
        this.checkWidget();
        int index = this.table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getItem(index);
    }

    public void setSelectedItem(int index) {
        this.checkWidget();
        if (index < 0 || index > this.provider.getDisplayItems().length - 1) {
            return;
        }
        this.table.setSelection(index);
        this.label.setImage(this.table.getSelection()[0].getImage());
    }

    public void setSelectedItem(Object obj) {
        this.checkWidget();
        int index = Arrays.asList(this.provider.getDisplayItems()).indexOf(obj);
        if (index == -1) {
            return;
        }
        this.setSelectedItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.table.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public Object[] getItems() {
        this.checkWidget();
        return this.provider.getItems();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.table.getSelectionIndex();
    }

    public int getStyle() {
        int style = super.getStyle();
        return style &= 0xFFFFFFF7;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    public int indexOf(Object item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        return Arrays.asList(this.provider.getItems()).indexOf(item);
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.label.isFocusControl() || this.arrow.isFocusControl() || this.table.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height, changed);
        this.label.setBounds(0, 0, width - arrowSize.x, height);
        this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
        this.initImages();
    }

    private void initImages() {
        Point arrowSize = this.arrow.getSize();
        this.imageHeight = this.label.getBounds().height;
        Point size = this.getSize();
        this.imageWidth = size.x - 10 - UIUtil.getMaxStringWidth((String[])this.provider.getDisplayItems(), (Control)this);
        if (this.provider.getItems().length > this.visibleItemCount) {
            this.imageWidth -= arrowSize.x;
        }
        this.disposeImages();
        int i = 0;
        while (i < this.provider.getItems().length) {
            TableItem item = this.table.getItem(i);
            item.setImage(0, this.provider.getImage(this.provider.getItems()[i], this.imageWidth, this.imageHeight, (Control)this.table, (Control)this));
            ++i;
        }
        if (this.table.getSelectionCount() > 0) {
            this.label.setImage(this.table.getSelection()[0].getImage());
        }
    }

    void tableEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                Object[] items = this.provider.getItems();
                int selectionIndex = this.table.getSelectionIndex();
                this.disposeImages();
                this.popup = null;
                this.table = null;
                this.createPopup(items, selectionIndex);
                break;
            }
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (StyleCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = StyleCombo.this.getDisplay().getFocusControl();
                        if (focusControl == StyleCombo.this.arrow || focusControl == StyleCombo.this.table || focusControl == StyleCombo.this.label) {
                            return;
                        }
                        StyleCombo.this.hasFocus = false;
                        Event e = new Event();
                        StyleCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int index = this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.label.setImage(this.table.getSelection()[0].getImage());
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    private void disposeImages() {
        if (this.table.isDisposed()) {
            return;
        }
        TableItem[] treeItems = this.table.getItems();
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i].getImage() != null && !treeItems[i].getImage().isDisposed()) {
                treeItems[i].getImage().dispose();
            }
            ++i;
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle tableRect = this.table.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, tableRect.width + 1, tableRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.label.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.table.deselectAll();
            this.label.setImage(null);
            return;
        }
        this.setSelectedItem(index);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        if (this.label != null) {
            this.label.setBackground(color);
        }
        if (this.table != null) {
            this.table.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        this.label.forceFocus();
        return this.label.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.label.setFont(font);
        this.table.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        if (this.label != null) {
            this.label.setForeground(color);
        }
        if (this.table != null) {
            this.table.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setItems(Object[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        this.provider.setItems(items);
        int i = 0;
        while (i < items.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, this.provider.getDisplayItems()[i].toString());
            ++i;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.label.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleItemCount = count;
    }

    void labelEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (StyleCombo.this.isDisposed()) {
                            return;
                        }
                        Control focusControl = StyleCombo.this.getDisplay().getFocusControl();
                        if (focusControl == StyleCombo.this.arrow || focusControl == StyleCombo.this.table || focusControl == StyleCombo.this.label) {
                            return;
                        }
                        StyleCombo.this.hasFocus = false;
                        Event e = new Event();
                        StyleCombo.this.notifyListeners(16, e);
                    }
                });
                break;
            }
            case 1: {
                if (event.character == '\r') {
                    this.dropDown(false);
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    if ((event.stateMask & 0x10000) != 0) {
                        boolean dropped = this.isDropped();
                        if (!dropped) {
                            this.setFocus();
                        }
                        this.dropDown(!dropped);
                        break;
                    }
                    int oldIndex = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(oldIndex - 1, 0));
                    } else {
                        this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                    }
                    if (oldIndex != this.getSelectionIndex()) {
                        Event e = new Event();
                        e.time = event.time;
                        e.stateMask = event.stateMask;
                        this.notifyListeners(13, e);
                    }
                    if (this.isDisposed()) break;
                }
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                this.table.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                boolean dropped = this.isDropped();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                if (event.button == 1) break;
                return;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
            }
        }
    }
}

