/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class ExpressionUtility {
    private static final String STRING_ROW = "row";
    private static final int EXPR_CACHE_SIZE = 50;
    private static Map compiledExprCache = Collections.synchronizedMap(new LinkedHashMap(50, 0.75f, true){
        private static final long serialVersionUID = 54331232145454L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 50;
        }
    });

    public static boolean isColumnExpression(String expression) {
        ScriptOrFnNode tree;
        boolean isColumn = false;
        if (expression == null || expression.trim().length() == 0) {
            return isColumn;
        }
        if (compiledExprCache.containsKey(expression)) {
            return (Boolean)compiledExprCache.get(expression);
        }
        Context context = Context.enter();
        try {
            try {
                CompilerEnvirons m_compilerEnv = new CompilerEnvirons();
                m_compilerEnv.initFromContext(context);
                Parser p = new Parser(m_compilerEnv, context.getErrorReporter());
                tree = p.parse(expression, null, 0);
            }
            catch (Exception exception) {
                compiledExprCache.put(expression, false);
                Context.exit();
                return false;
            }
        }
        finally {
            Context.exit();
        }
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() != 133 && tree.getFirstChild().getType() != 132 && tree.getFirstChild().getType() != 128) {
                isColumn = false;
            }
            Node exprNode = tree.getFirstChild();
            Node child = exprNode.getFirstChild();
            assert (child != null);
            isColumn = child.getType() == 36 || child.getType() == 33 ? ExpressionUtility.getDirectColRefExpr(child) : false;
        } else {
            isColumn = false;
        }
        compiledExprCache.put(expression, isColumn);
        return isColumn;
    }

    public static String getReplacedColRefExpr(String columnStr) {
        if (ExpressionUtility.isColumnExpression(columnStr)) {
            return columnStr.replaceFirst("\\Qrow\\E", "dataSetRow");
        }
        return columnStr;
    }

    private static boolean getDirectColRefExpr(Node refNode) {
        assert (refNode.getType() == 33 || refNode.getType() == 36);
        Node rowName = refNode.getFirstChild();
        assert (rowName != null);
        if (rowName.getType() != 39) {
            return false;
        }
        String str = rowName.getString();
        assert (str != null);
        if (!str.equals(STRING_ROW)) {
            return false;
        }
        Node rowColumn = rowName.getNext();
        assert (rowColumn != null);
        if (refNode.getType() == 33 && rowColumn.getType() == 41) {
            return true;
        }
        return refNode.getType() == 36 && (rowColumn.getType() == 40 || rowColumn.getType() == 41);
    }
}

