/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntryFilter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceFilter;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.FilePathEntry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FileContentProvider
implements ITreeContentProvider {
    private boolean showFiles;
    private ResourceEntry.Filter filter = new ResourceEntry.Filter(){

        public boolean accept(ResourceEntry entity) {
            return false;
        }
    };
    private String[] fileExtension;

    public FileContentProvider(final boolean showFiles) {
        this.showFiles = showFiles;
        this.filter = new ResourceEntry.Filter(){

            public boolean accept(ResourceEntry entity) {
                ResourceEntryFilter filter = new ResourceEntryFilter(ReportPlugin.getFilterMap().values().toArray(new ResourceFilter[0]));
                if (entity.hasChildren() && filter.accept(entity)) {
                    return true;
                }
                if (showFiles) {
                    return filter.accept(entity);
                }
                if (entity.isFile()) {
                    return false;
                }
                return filter.accept(entity);
            }
        };
    }

    public FileContentProvider(final String[] extension) {
        this.showFiles = true;
        this.fileExtension = extension;
        this.filter = new ResourceEntry.Filter(){

            public boolean accept(ResourceEntry entity) {
                ResourceEntryFilter filter = new ResourceEntryFilter(ReportPlugin.getFilterMap().values().toArray(new ResourceFilter[0]));
                if (entity.hasChildren()) {
                    return filter.accept(entity);
                }
                int i = 0;
                while (i < extension.length) {
                    if (entity.getName().toLowerCase().endsWith(extension[i]) && filter.accept(entity)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
    }

    public void setFileNamePattern(final String[] fileNamePattern) {
        this.filter = new ResourceEntry.Filter(){

            public boolean accept(ResourceEntry entity) {
                ResourceEntryFilter filter = new ResourceEntryFilter(ReportPlugin.getFilterMap().values().toArray(new ResourceFilter[0]));
                if (entity.hasChildren()) {
                    return filter.accept(entity);
                }
                int i = 0;
                while (i < fileNamePattern.length) {
                    if (entity.getName().toLowerCase().endsWith(fileNamePattern[i].substring(1)) && filter.accept(entity)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Object[]) {
            return (Object[])parentElement;
        }
        if (parentElement instanceof FilePathEntry) {
            return ((FilePathEntry)parentElement).getChildren(this.filter);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            return ((File)element).getParentFile();
        }
        if (element instanceof FilePathEntry) {
            return ((FilePathEntry)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof File) {
            return ((File)element).list() != null && ((File)element).list().length > 0;
        }
        if (element instanceof FilePathEntry) {
            return ((FilePathEntry)element).getChildren(this.filter).length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

