/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MultiValueCombo;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ValueCombo;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BindingExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FilterConditionBuilder
extends BaseTitleAreaDialog {
    protected static Logger logger = Logger.getLogger(FilterConditionBuilder.class.getName());
    public static final String DLG_TITLE_NEW = Messages.getString((String)"FilterConditionBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"FilterConditionBuilder.DialogTitle.Edit");
    public static final String DLG_MESSAGE_NEW = Messages.getString((String)"FilterConditionBuilder.DialogMessage.New");
    public static final String DLG_MESSAGE_EDIT = Messages.getString((String)"FilterConditionBuilder.DialogMessage.Edit");
    protected transient String[] popupItems = null;
    private static String[] actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
    protected final String NULL_STRING;
    protected Composite dummy1;
    protected Composite dummy2;
    protected Label label1;
    protected Label label2;
    protected List valueList = new ArrayList();
    protected List selValueList = new ArrayList();
    protected static final String[][] OPERATOR;
    private transient String bindingName;
    private ParamBindingHandle[] bindingParams = null;
    private transient boolean refreshItems = true;
    protected transient ReportElementHandle currentItem = null;
    protected static final String[] EMPTY_ARRAY;
    protected List columnList;
    protected int valueVisible;
    protected Table table;
    protected TableViewer tableViewer;
    protected static final String[] EMPTY;
    protected String title;
    protected String message;
    protected IChoiceSet choiceSet;
    protected FilterConditionHandle filterCondition;
    protected Combo expression;
    protected Combo operator;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected ValueCombo expressionValue1;
    protected ValueCombo expressionValue2;
    protected MultiValueCombo addExpressionValue;
    protected Composite valueListComposite;
    protected Label andLable;
    protected DesignElementHandle designHandle;
    protected static final String VALUE_OF_THIS_DATA_ITEM;
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Expression) {
                    return ((Expression)element).getStringExpression();
                }
                return element.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    };
    protected SelectionListener operatorSelection = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            FilterConditionBuilder.this.operatorChange();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    protected Listener comboModify = new Listener(){

        public void handleEvent(Event e) {
            Assert.isLegal((boolean)(e.widget instanceof Combo));
            Combo combo = (Combo)e.widget;
            String newValue = combo.getText();
            String value = DEUtil.getExpression((Object)FilterConditionBuilder.this.getResultSetColumn(newValue));
            if (value != null) {
                newValue = value;
            }
            combo.setText(newValue);
            FilterConditionBuilder.this.updateButtons();
        }
    };
    protected IExpressionProvider expressionProvider;
    protected ValueCombo.ISelection selectValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String retValue = null;
            Iterator iter = FilterConditionBuilder.this.columnList.iterator();
            while (iter.hasNext()) {
                String columnName = FilterConditionBuilder.this.getColumnName(iter.next());
                if (!DEUtil.getColumnExpression((String)columnName).equals(FilterConditionBuilder.this.expression.getText())) continue;
                FilterConditionBuilder.this.bindingName = columnName;
                break;
            }
            if (FilterConditionBuilder.this.bindingName != null) {
                try {
                    List selectValueList = FilterConditionBuilder.this.getSelectValueList();
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (FilterConditionBuilder.this.bindingParams != null) {
                        dialog.setBindingParams(FilterConditionBuilder.this.bindingParams);
                    }
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
                }
            } else if (FilterConditionBuilder.this.designHandle instanceof TabularCubeHandle || FilterConditionBuilder.this.designHandle instanceof TabularHierarchyHandle) {
                DataSetHandle dataSet = null;
                dataSet = FilterConditionBuilder.this.designHandle instanceof TabularCubeHandle ? ((TabularCubeHandle)FilterConditionBuilder.this.designHandle).getDataSet() : ((TabularHierarchyHandle)FilterConditionBuilder.this.designHandle).getDataSet();
                String expressionString = FilterConditionBuilder.this.expression.getText();
                try {
                    List selectValueList = SelectValueFetcher.getSelectValueList(expressionString, dataSet);
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                catch (BirtException e1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + e1.getMessage()));
                }
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
            }
            return retValue;
        }
    };
    protected ValueCombo.ISelection expValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String retValue = null;
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            if (FilterConditionBuilder.this.expressionProvider == null) {
                dialog.setExpressionProvier(new ExpressionProvider(FilterConditionBuilder.this.designHandle));
            } else {
                dialog.setExpressionProvier(FilterConditionBuilder.this.expressionProvider);
            }
            if (dialog.open() == 0) {
                retValue = dialog.getResult();
            }
            return retValue;
        }
    };
    protected MultiValueCombo.ISelection mAddExpValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            if (FilterConditionBuilder.this.expressionProvider == null) {
                dialog.setExpressionProvier(new ExpressionProvider(FilterConditionBuilder.this.designHandle));
            } else {
                dialog.setExpressionProvier(FilterConditionBuilder.this.expressionProvider);
            }
            if (dialog.open() == 0 && dialog.getResult().length() != 0) {
                retValue = new String[]{dialog.getResult()};
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            FilterConditionBuilder.this.mAddSelValueAction.doAfterSelection(combo);
        }
    };
    protected MultiValueCombo.ISelection mAddSelValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            for (Object obj : FilterConditionBuilder.this.columnList) {
                String columnName = "";
                if (obj instanceof ComputedColumnHandle) {
                    columnName = ((ComputedColumnHandle)obj).getName();
                } else if (obj instanceof ResultSetColumnHandle) {
                    columnName = ((ResultSetColumnHandle)obj).getColumnName();
                }
                if (!DEUtil.getColumnExpression((String)columnName).equals(FilterConditionBuilder.this.expression.getText())) continue;
                FilterConditionBuilder.this.bindingName = columnName;
                break;
            }
            if (FilterConditionBuilder.this.bindingName != null) {
                try {
                    List selectValueList = FilterConditionBuilder.this.getSelectValueList();
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setMultipleSelection(true);
                    dialog.setSelectedValueList(selectValueList);
                    if (FilterConditionBuilder.this.bindingParams != null) {
                        dialog.setBindingParams(FilterConditionBuilder.this.bindingParams);
                    }
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
                }
            } else if (FilterConditionBuilder.this.designHandle instanceof TabularCubeHandle || FilterConditionBuilder.this.designHandle instanceof TabularHierarchyHandle) {
                DataSetHandle dataSet;
                if (FilterConditionBuilder.this.designHandle instanceof TabularCubeHandle) {
                    dataSet = ((TabularCubeHandle)FilterConditionBuilder.this.designHandle).getDataSet();
                } else {
                    dataSet = ((TabularHierarchyHandle)FilterConditionBuilder.this.designHandle).getDataSet();
                    if (dataSet == null && ((TabularHierarchyHandle)FilterConditionBuilder.this.designHandle).getLevelCount() > 0) {
                        dataSet = ((TabularCubeHandle)((TabularHierarchyHandle)FilterConditionBuilder.this.designHandle).getContainer().getContainer()).getDataSet();
                    }
                }
                String expressionString = FilterConditionBuilder.this.expression.getText();
                try {
                    List selectValueList = SelectValueFetcher.getSelectValueList(expressionString, dataSet);
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    dialog.setMultipleSelection(true);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                catch (BirtException e1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + e1.getMessage()));
                }
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            FilterConditionBuilder.this.addBtn.setEnabled(false);
            if (FilterConditionBuilder.this.addExpressionValue.getSelStrings().length == 1) {
                FilterConditionBuilder.this.addExpressionValue.setText(DEUtil.resolveNull((String)FilterConditionBuilder.this.addExpressionValue.getSelStrings()[0]));
            } else if (FilterConditionBuilder.this.addExpressionValue.getSelStrings().length > 1) {
                FilterConditionBuilder.this.addExpressionValue.setText("");
            }
            boolean change = false;
            int i = 0;
            while (i < FilterConditionBuilder.this.addExpressionValue.getSelStrings().length) {
                if (FilterConditionBuilder.this.valueList.indexOf(DEUtil.resolveNull((String)FilterConditionBuilder.this.addExpressionValue.getSelStrings()[i])) < 0) {
                    FilterConditionBuilder.this.valueList.add(DEUtil.resolveNull((String)FilterConditionBuilder.this.addExpressionValue.getSelStrings()[i]));
                    change = true;
                }
                ++i;
            }
            if (change) {
                FilterConditionBuilder.this.tableViewer.refresh();
                FilterConditionBuilder.this.updateButtons();
                FilterConditionBuilder.this.addExpressionValue.setFocus();
            }
        }
    };

    static {
        EMPTY_ARRAY = new String[0];
        EMPTY = new String[0];
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("FilterCondition", "operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            FilterConditionBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            FilterConditionBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"FilterConditionBuilder.choice.ValueOfThisDataItem");
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public void setBindingParams(ParamBindingHandle[] params) {
        this.bindingParams = params;
    }

    public FilterConditionBuilder(String title, String message) {
        this(UIUtil.getDefaultShell(), title, message);
    }

    public FilterConditionBuilder(Shell parentShell, String title, String message) {
        super(parentShell);
        this.NULL_STRING = null;
        this.title = title;
        this.message = message;
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    protected static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        int i = 0;
        while (i < this.columnList.size()) {
            values[i] = this.getColumnName(this.columnList.get(i));
            ++i;
        }
        return values;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditFilterCondition_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.getShell().setText(this.title);
        FilterConditionBuilder.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        this.createFilterConditionContent(contents);
        return area;
    }

    protected void createFilterConditionContent(Composite innerParent) {
        Composite anotherParent = new Composite(innerParent, 0);
        GridData gd = new GridData(768);
        anotherParent.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout(4, false);
        anotherParent.setLayout((Layout)glayout);
        Label lb = new Label(anotherParent, 0);
        lb.setText(Messages.getString((String)"FilterConditionBuilder.text.Condition"));
        Label lb2 = new Label(anotherParent, 0);
        lb2.setLayoutData((Object)new GridData(768));
        new Label(anotherParent, 0);
        Composite condition = new Composite(innerParent, 0);
        gd = new GridData(1808);
        gd.heightHint = 220;
        condition.setLayoutData((Object)gd);
        glayout = new GridLayout(4, false);
        condition.setLayout((Layout)glayout);
        this.expression = new Combo(condition, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 100;
        this.expression.setLayoutData((Object)gdata);
        this.expression.addListener(13, this.comboModify);
        this.expression.setItems(this.getDataSetColumns());
        if (this.expression.getItemCount() == 0) {
            this.expression.add(DEUtil.resolveNull(null));
        }
        this.expression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilterConditionBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && FilterConditionBuilder.this.designHandle instanceof DataItemHandle) {
                    FilterConditionBuilder.this.expression.setText(DEUtil.getColumnExpression((String)((DataItemHandle)FilterConditionBuilder.this.designHandle).getResultSetColumn()));
                }
                FilterConditionBuilder.this.updateButtons();
            }
        });
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.updateButtons();
            }
        });
        Button expBuilder = new Button(condition, 8);
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        expBuilder.setLayoutData((Object)gdata);
        UIUtil.setExpressionButtonImage(expBuilder);
        expBuilder.setToolTipText(Messages.getString((String)"FilterConditionBuilder.tooltip.ExpBuilder"));
        expBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConditionBuilder.this.editValue((Control)FilterConditionBuilder.this.expression);
            }
        });
        this.operator = new Combo(condition, 8);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        this.operator.addSelectionListener(this.operatorSelection);
        this.create2ValueComposite(condition);
        if (this.filterCondition != null) {
            this.syncViewProperties();
        }
        lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
    }

    protected String getColumnName(Object obj) {
        if (obj instanceof ComputedColumnHandle) {
            return ((ComputedColumnHandle)obj).getName();
        }
        if (obj instanceof ResultSetColumnHandle) {
            return ((ResultSetColumnHandle)obj).getColumnName();
        }
        return "";
    }

    private int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            this.valueListComposite.dispose();
            this.valueListComposite = null;
        }
        GridData expgd = new GridData(768);
        expgd.minimumWidth = 100;
        this.expressionValue1 = new ValueCombo(condition, 0);
        this.expressionValue1.setLayoutData(expgd);
        this.expressionValue1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.updateButtons();
            }
        });
        this.refreshList();
        this.expressionValue1.setItems(this.popupItems);
        this.expressionValue1.addSelectionListener(0, this.selectValueAction);
        this.expressionValue1.addSelectionListener(1, this.expValueAction);
        this.dummy1 = this.createDummy(condition, 3);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"FilterConditionBuilder.text.AND"));
        this.andLable.setEnabled(false);
        this.dummy2 = this.createDummy(condition, 3);
        this.expressionValue2 = new ValueCombo(condition, 0);
        this.expressionValue2.setLayoutData(expgd);
        this.expressionValue2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.updateButtons();
            }
        });
        this.expressionValue2.setItems(this.popupItems);
        this.expressionValue2.addSelectionListener(0, this.selectValueAction);
        this.expressionValue2.addSelectionListener(1, this.expValueAction);
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.select(0);
            this.operatorChange();
        }
        condition.getParent().layout(true, true);
        if (this.getButtonBar() != null) {
            condition.getShell().pack();
        }
        return 1;
    }

    private int createValueListComposite(Composite parent) {
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            return 0;
        }
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            this.expressionValue1.dispose();
            this.expressionValue1 = null;
            this.dummy1.dispose();
            this.dummy1 = null;
            this.expressionValue2.dispose();
            this.expressionValue2 = null;
            this.dummy2.dispose();
            this.dummy2 = null;
            this.andLable.dispose();
            this.andLable = null;
        }
        this.valueListComposite = new Composite(parent, 0);
        GridData gdata = new GridData(1808);
        gdata.horizontalSpan = 4;
        this.valueListComposite.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.valueListComposite.setLayout((Layout)layout);
        Group group = new Group(this.valueListComposite, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"FilterConditionBuilder.label.value"));
        GridData expgd = new GridData();
        expgd.widthHint = 100;
        this.addExpressionValue = new MultiValueCombo((Composite)group, 0);
        this.addExpressionValue.setLayoutData(expgd);
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.add"));
        this.addBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.add.tooltip"));
        this.setButtonLayoutData(this.addBtn);
        this.addBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = FilterConditionBuilder.this.addExpressionValue.getText().trim();
                if (FilterConditionBuilder.this.valueList.indexOf(value) < 0) {
                    FilterConditionBuilder.this.valueList.add(value);
                    FilterConditionBuilder.this.tableViewer.refresh();
                    FilterConditionBuilder.this.updateButtons();
                    FilterConditionBuilder.this.addExpressionValue.setFocus();
                    FilterConditionBuilder.this.addExpressionValue.setText("");
                } else {
                    FilterConditionBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        new Label((Composite)group, 0);
        int tableStyle = 68356;
        this.table = new Table((Composite)group, tableStyle);
        data = new GridData(1808);
        data.horizontalSpan = 4;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{288};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterConditionBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    FilterConditionBuilder.this.delTableValue();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FilterConditionBuilder.this.editTableValue();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(this.valueListComposite, 0);
        data = new GridData(128);
        rightPart.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        GridData gd = (GridData)this.editBtn.getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 0x1000008;
        this.editBtn.setLayoutData((Object)gd);
        this.editBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterConditionBuilder.this.editTableValue();
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterConditionBuilder.this.delTableValue();
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        gd = (GridData)this.delAllBtn.getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 1;
        this.delAllBtn.setLayoutData((Object)gd);
        this.delAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int count = FilterConditionBuilder.this.valueList.size();
                if (count > 0) {
                    FilterConditionBuilder.this.valueList.clear();
                    FilterConditionBuilder.this.tableViewer.refresh();
                    FilterConditionBuilder.this.updateButtons();
                } else {
                    FilterConditionBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.addExpressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.checkAddButtonStatus();
                FilterConditionBuilder.this.updateButtons();
            }
        });
        this.refreshList();
        this.addExpressionValue.setItems(this.popupItems);
        this.addExpressionValue.addSelectionListener(0, this.mAddSelValueAction);
        this.addExpressionValue.addSelectionListener(1, this.mAddExpValueAction);
        parent.getParent().layout(true, true);
        if (this.getButtonBar() != null) {
            parent.getShell().pack();
        }
        return 1;
    }

    protected void operatorChange() {
        String value = FilterConditionBuilder.getValueForOperator(this.operator.getText());
        this.valueVisible = FilterConditionBuilder.determineValueVisible(value);
        if (this.valueVisible == 3) {
            int ret = this.createValueListComposite(this.operator.getParent());
            if (ret != 0) {
                if (this.filterCondition != null) {
                    this.valueList = new ArrayList(this.filterCondition.getValue1List());
                }
                this.tableViewer.setInput((Object)this.valueList);
            }
        } else {
            int ret = this.create2ValueComposite(this.operator.getParent());
            if (ret != 0 && this.filterCondition != null) {
                this.expressionValue1.setText(DEUtil.resolveNull((String)this.filterCondition.getValue1()));
                this.expressionValue2.setText(DEUtil.resolveNull((String)this.filterCondition.getValue2()));
            }
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(true);
            this.andLable.setVisible(true);
            this.andLable.setEnabled(true);
        }
        this.updateButtons();
    }

    protected Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            if (this.getColumnName(this.columnList.get(i)).equals(name)) {
                return this.columnList.get(i);
            }
            ++i;
        }
        return null;
    }

    protected Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    private Text createText(Composite parent) {
        Text txt = new Text(parent, 2048);
        GridData gdata = new GridData(768);
        gdata.widthHint = 100;
        txt.setLayoutData((Object)gdata);
        return txt;
    }

    public void updateHandle(FilterConditionHandle handle, int handleCount) {
        this.filterCondition = handle;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        this.setColumnList(this.designHandle);
    }

    public void setDesignHandle(DesignElementHandle handle, IExpressionProvider provider) {
        this.setDesignHandle(handle);
        this.expressionProvider = provider;
        this.setColumnList(this.designHandle);
    }

    protected void setColumnList(DesignElementHandle handle) {
        block8: {
            DataSetHandle dataset = null;
            if (handle instanceof TabularCubeHandle || handle instanceof TabularHierarchyHandle) {
                try {
                    if (handle instanceof TabularCubeHandle) {
                        dataset = ((TabularCubeHandle)handle).getDataSet();
                    } else {
                        dataset = ((TabularHierarchyHandle)handle).getDataSet();
                        if (dataset == null && ((TabularHierarchyHandle)handle).getLevelCount() > 0) {
                            dataset = ((TabularCubeHandle)((TabularHierarchyHandle)handle).getContainer().getContainer()).getDataSet();
                        }
                    }
                    if (dataset != null) {
                        this.columnList = DataUtil.getColumnList(dataset);
                        break block8;
                    }
                    this.columnList = Collections.EMPTY_LIST;
                }
                catch (SemanticException e) {
                    e.printStackTrace();
                }
            } else {
                this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
            }
        }
    }

    public FilterConditionHandle getInputHandle() {
        return this.filterCondition;
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isConditionOK());
        }
    }

    protected void enableInput(boolean val) {
        this.operator.setEnabled(val);
        if (this.valueVisible != 3) {
            if (this.expressionValue1 != null) {
                this.expressionValue1.setEnabled(val);
            }
            if (this.expressionValue2 != null) {
                this.expressionValue2.setEnabled(val);
            }
            if (this.andLable != null) {
                this.andLable.setEnabled(val);
            }
        } else {
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    protected boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    protected boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    protected boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        assert (!this.expressionValue1.isDisposed());
        assert (!this.expressionValue2.isDisposed());
        if (this.expressionValue1.getVisible() && (this.expressionValue1.getText() == null || this.expressionValue1.getText().trim().length() == 0)) {
            return false;
        }
        return !this.expressionValue2.getVisible() || this.expressionValue2.getText() != null && this.expressionValue2.getText().trim().length() != 0;
    }

    protected void checkAddButtonStatus() {
        if (this.addExpressionValue != null) {
            String value = this.addExpressionValue.getText();
            if (value == null || value.length() == 0 || value.trim().length() == 0) {
                this.addBtn.setEnabled(false);
                return;
            }
            if (value != null) {
                value = value.trim();
            }
            if (this.valueList.indexOf(value) < 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected void syncViewProperties() {
        this.expression.setText(DEUtil.resolveNull((String)this.filterCondition.getExpr()));
        this.operator.select(FilterConditionBuilder.getIndexForOperatorValue(this.filterCondition.getOperator()));
        this.valueVisible = FilterConditionBuilder.determineValueVisible(this.filterCondition.getOperator());
        if (this.valueVisible == 3) {
            this.createValueListComposite(this.operator.getParent());
            this.valueList = new ArrayList(this.filterCondition.getValue1List());
            this.tableViewer.setInput((Object)this.valueList);
        } else {
            this.create2ValueComposite(this.operator.getParent());
            this.expressionValue1.setText(DEUtil.resolveNull((String)this.filterCondition.getValue1()));
            this.expressionValue2.setText(DEUtil.resolveNull((String)this.filterCondition.getValue2()));
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(true);
            this.andLable.setVisible(true);
            this.andLable.setEnabled(true);
        } else if (this.valueVisible == 3) {
            if (this.expression.getText().length() == 0) {
                this.valueListComposite.setEnabled(false);
            } else {
                this.valueListComposite.setEnabled(true);
            }
        }
    }

    protected void okPressed() {
        try {
            if (this.filterCondition == null) {
                FilterCondition filter = StructureFactory.createFilterCond();
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)FilterConditionBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    filter.setValue1(this.valueList);
                    filter.setValue2("");
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        filter.setValue1(DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    } else {
                        filter.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        filter.setValue2(DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    }
                }
                filter.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
                PropertyHandle propertyHandle = this.designHandle.getPropertyHandle("filter");
                propertyHandle.addItem((IStructure)filter);
            } else {
                this.filterCondition.setOperator(DEUtil.resolveNull((String)FilterConditionBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    this.filterCondition.setValue1(this.valueList);
                    this.filterCondition.setValue2(this.NULL_STRING);
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        this.filterCondition.setValue1(DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    } else {
                        this.filterCondition.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        this.filterCondition.setValue2(DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    } else {
                        this.filterCondition.setValue2(this.NULL_STRING);
                    }
                }
                this.filterCondition.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
            }
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        super.okPressed();
    }

    protected void editValue(Control control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        if (this.designHandle != null) {
            if (this.expressionProvider == null) {
                if (this.designHandle instanceof TabularCubeHandle || this.designHandle instanceof TabularHierarchyHandle) {
                    expressionBuilder.setExpressionProvier(new BindingExpressionProvider(this.designHandle, null));
                } else {
                    expressionBuilder.setExpressionProvier(new ExpressionProvider(this.designHandle));
                }
            } else {
                expressionBuilder.setExpressionProvier(this.expressionProvider);
            }
        }
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    public void setInput(Object inputHandle) {
        this.filterCondition = inputHandle instanceof FilterConditionHandle ? (FilterConditionHandle)inputHandle : null;
    }

    private void refreshList() {
        if (this.refreshItems) {
            ArrayList<String> finalItems = new ArrayList<String>(10);
            int n = 0;
            while (n < actions.length) {
                finalItems.add(actions[n]);
                ++n;
            }
            this.popupItems = finalItems.toArray(EMPTY_ARRAY);
        }
        this.refreshItems = false;
    }

    private List getSelectValueList() throws BirtException {
        List selectValueList = new ArrayList();
        ReportItemHandle reportItem = DEUtil.getBindingHolder((DesignElementHandle)this.currentItem);
        if (this.bindingName != null && reportItem != null) {
            selectValueList = SelectValueFetcher.getSelectValueList(this.expression.getText(), reportItem.getDataSet(), false);
        } else {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.updateButtons();
        return super.open();
    }

    protected void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
            String initValue = (String)selection.getFirstElement();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
            if (this.designHandle != null) {
                if (this.expressionProvider == null) {
                    if (this.designHandle instanceof TabularCubeHandle || this.designHandle instanceof TabularHierarchyHandle) {
                        expressionBuilder.setExpressionProvier(new BindingExpressionProvider(this.designHandle, null));
                    } else {
                        expressionBuilder.setExpressionProvier(new ExpressionProvider(this.designHandle));
                    }
                } else {
                    expressionBuilder.setExpressionProvier(this.expressionProvider);
                }
            }
            if (expressionBuilder.open() == 0) {
                String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                if (result.length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Title"), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Msg"));
                    return;
                }
                int index = this.table.getSelectionIndex();
                this.valueList.remove(index);
                this.valueList.add(index, result);
                this.tableViewer.refresh();
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    protected void delTableValue() {
        int index = this.table.getSelectionIndex();
        if (index > -1) {
            this.valueList.remove(index);
            this.tableViewer.refresh();
            if (this.valueList.size() > 0) {
                if (this.valueList.size() <= index) {
                    --index;
                }
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.delBtn.setEnabled(false);
        }
    }
}

