/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.actions;

import org.eclipse.birt.report.designer.data.ui.datasource.ExportDataSourceDialog;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSourceDesignSession;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExportElementToSourceCPStoreAction
extends AbstractViewAction {
    private static final String DISPLAY_TEXT = Messages.getString((String)"ExportToCPSouceAction.action.text");

    public ExportElementToSourceCPStoreAction(Object selectedObject) {
        super(selectedObject, DISPLAY_TEXT);
    }

    public boolean isEnabled() {
        Object selection = this.getSelection();
        if (selection instanceof StructuredSelection) {
            if (((StructuredSelection)selection).size() > 1) {
                return false;
            }
            selection = ((StructuredSelection)selection).getFirstElement();
        }
        if (selection instanceof OdaDataSourceHandle) {
            return !this.isSampleDB((OdaDataSourceHandle)selection);
        }
        return false;
    }

    private boolean isSampleDB(OdaDataSourceHandle handle) {
        Object driverClass;
        return "org.eclipse.birt.report.data.oda.jdbc".equals(handle.getExtensionID()) && (driverClass = handle.getProperty("odaDriverClass")) != null && "org.eclipse.birt.report.data.oda.sampledb.Driver".equals(driverClass.toString());
    }

    public void run() {
        ExportDataSourceDialog dialog;
        Object selection = this.getSelection();
        if (selection instanceof StructuredSelection) {
            selection = ((StructuredSelection)selection).getFirstElement();
        }
        if (selection instanceof OdaDataSourceHandle && (dialog = new ExportDataSourceDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"datasource.exprotToCP.title"), (DataSourceHandle)selection)).open() == 0) {
            try {
                DesignSessionRequest designSessionRequest = DTPUtil.getInstance().createDesignSessionRequest((OdaDataSourceHandle)selection);
                OdaDesignSession session = DataSourceDesignSession.convertDesignToLinkedProfile((DesignSessionRequest)designSessionRequest, (String)dialog.getProfileName(), (boolean)dialog.isExternalToCP(), (boolean)dialog.doesCreateProfileStore(), (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell());
                DTPUtil.getInstance().updateDataSourceHandle(session.getResponse(), session.getRequestDataSourceDesign(), (OdaDataSourceHandle)selection);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }
}

