/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

abstract class PropertyHandleInputDialog
extends StatusDialog {
    private Object structureOrHandle = null;
    private static final String NEW_ACTION = Messages.getString((String)"PropertyHandleInputDialog.Action.New");
    private static final String EDIT_ACTION = Messages.getString((String)"PropertyHandleInputDialog.Action.Edit");

    protected PropertyHandleInputDialog(Object structureOrHandle) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        this.structureOrHandle = structureOrHandle;
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.x = Math.max(pt.x, 400);
        pt.y = Math.max(pt.y, 200);
        this.getShell().setSize(pt);
        this.getShell().setText(this.getTitle());
    }

    protected String getTitle() {
        return this.structureOrHandle instanceof Structure ? NEW_ACTION : EDIT_ACTION;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        this.createCustomControls(composite);
        this.validateSyntax();
        this.addListeners();
        Utility.setSystemHelp((Control)composite, (String)"org.eclipse.birt.cshelp.Dialog_PropertyHandle_ID");
        return composite;
    }

    protected abstract void createCustomControls(Composite var1);

    protected void validateSyntax() {
        IStatus status = this.validateSyntax(this.structureOrHandle);
        if (status != null) {
            this.updateStatus(status);
        }
    }

    protected abstract IStatus validateSyntax(Object var1);

    private void addListeners() {
        this.getShell().addListener(21, new Listener(){

            public void handleEvent(Event event) {
                PropertyHandleInputDialog.this.rollback();
            }
        });
    }

    protected void okPressed() {
        if (this.validateSemantics()) {
            super.okPressed();
        }
    }

    protected boolean validateSemantics() {
        IStatus status = this.validateSemantics(this.structureOrHandle);
        if (status == null) {
            return true;
        }
        this.updateStatus(status);
        return status.getSeverity() == 0;
    }

    protected abstract IStatus validateSemantics(Object var1);

    protected void cancelPressed() {
        this.rollback();
        super.cancelPressed();
    }

    protected abstract void rollback();

    protected Object getStructureOrHandle() {
        return this.structureOrHandle;
    }

    protected boolean isBlankProperty(String value) {
        return Utility.getNonNullString((String)value).trim().length() == 0;
    }

    protected Status getBlankPropertyStatus(String cellLabel) {
        return this.getMiscStatus(4, Messages.getFormattedString((String)"PropertyHandleInputDialog.messages.error.blankProperty", (Object[])new String[]{cellLabel}));
    }

    protected Status getOKStatus() {
        return this.getMiscStatus(0, "");
    }

    protected Status getMiscStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.ui", 0, message, null);
    }

    protected Status setProperty(Object obj, String propertyName, Object value) {
        try {
            Utility.setProperty((Object)obj, (String)propertyName, (Object)value);
        }
        catch (Exception e) {
            return this.getMiscStatus(4, Utility.getNonNullString((String)e.getMessage()));
        }
        return this.getOKStatus();
    }

    protected Object getProperty(Object obj, String propertyName) {
        try {
            return Utility.getProperty((Object)obj, (String)propertyName);
        }
        catch (Exception e) {
            this.updateStatus((IStatus)this.getMiscStatus(4, Utility.getNonNullString((String)e.getMessage())));
            return null;
        }
    }
}

