/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.odadatasource.wizards.AbstractDataSourceConnectionWizard;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSourceDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataSourceSelectionPage
extends WizardPage {
    private transient ListViewer dataSourceList = null;
    private transient Hashtable htDataSourceWizards = new Hashtable(10);
    private transient Label dataSourceNameLabel = null;
    private transient Text dataSourceName = null;
    private transient Button dsChoiceListRadio = null;
    private transient Button connectionProfileRadio = null;
    private transient DataSourceDesignSession m_designSession = null;
    private transient DesignElementHandle parentHandle = null;
    private transient SlotHandle slotHandle = null;
    private static final String ODA_EXTENSION_ID = "id";
    private static final String EMPTY_NAME = Messages.getString((String)"error.DataSource.emptyName");
    private static final String DUPLICATE_NAME = Messages.getString((String)"error.duplicateName");
    private static final String CREATE_DATA_SOURCE_TRANS_NAME = Messages.getString((String)"wizard.transaction.createDataSource");
    private static final String SCRIPT_DATA_SOURCE_DISPLAY_NAME = Messages.getString((String)"DataSourceSelectionPage.ScriptDataSource.DisplayName");
    private static final String DTP_ODA_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dataSource";
    private Object prevSelectedDataSourceType = null;
    private boolean dataSourceIsCreated = false;
    private boolean useODAV3 = false;
    private static Logger logger = Logger.getLogger(DataSourceSelectionPage.class.getName());

    public DataSourceSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString((String)"datasource.wizard.title.select"));
        this.setMessage(Messages.getString((String)"datasource.wizard.message.selectType"));
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"DataSourceBasePage"));
    }

    public DataSourceSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setupDSChoiceListRadio(composite);
        this.setupConnectionProfileRadio(composite);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        this.dataSourceList = new ListViewer(composite, 2052);
        this.dataSourceList.getControl().setLayoutData((Object)layoutData);
        this.dataSourceList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return this.appendScriptDS((Object[])inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            private Object[] appendScriptDS(Object[] array) {
                if (array == null) {
                    array = new Object[]{};
                }
                Object[] newArray = new Object[array.length + 1];
                int i = 0;
                while (i < array.length) {
                    newArray[i] = array[i];
                    ++i;
                }
                newArray[array.length] = SCRIPT_DATA_SOURCE_DISPLAY_NAME;
                return newArray;
            }
        });
        this.dataSourceList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String displayName = null;
                if (element instanceof ExtensionManifest) {
                    ExtensionManifest config = (ExtensionManifest)element;
                    DataSetProvider.findDataSourceElement((String)config.getExtensionID());
                    displayName = config.getDataSourceDisplayName();
                } else {
                    displayName = element.toString();
                }
                return displayName;
            }
        });
        ManifestExplorer.Filter aFilter = ManifestExplorer.createFilter();
        aFilter.setMissingDataSetTypesFilter(true);
        aFilter.setDeprecatedFilter(true);
        ExtensionManifest[] dataSources = ManifestExplorer.getInstance().getExtensionManifests(DTP_ODA_EXT_POINT, aFilter);
        this.dataSourceList.setInput((Object)this.getFilteredDataSourceArray(dataSources));
        this.dataSourceList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSourceSelectionPage.this.setPageComplete(!DataSourceSelectionPage.this.hasWizard() && DataSourceSelectionPage.this.getMessageType() != 3);
            }
        });
        this.dataSourceList.setSorter(new ViewerSorter());
        this.dataSourceNameLabel = new Label(composite, 0);
        this.dataSourceNameLabel.setText(Messages.getString((String)"datasource.wizard.label.dataSourceName"));
        this.dataSourceName = new Text(composite, 2048);
        String name = ReportPlugin.getDefault().getCustomName("DataSource");
        if (name != null) {
            this.dataSourceName.setText(Utility.getUniqueDataSourceName((String)name));
        } else {
            this.dataSourceName.setText(Utility.getUniqueDataSourceName((String)Messages.getString((String)"datasource.new.defaultName")));
        }
        layoutData = new GridData(768);
        this.dataSourceName.setLayoutData((Object)layoutData);
        this.dataSourceName.setToolTipText(EMPTY_NAME);
        this.dataSourceName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtil.isBlank((String)DataSourceSelectionPage.this.dataSourceName.getText().trim())) {
                    DataSourceSelectionPage.this.setMessage(EMPTY_NAME, 3);
                } else if (DataSourceSelectionPage.this.isDuplicateName()) {
                    DataSourceSelectionPage.this.setMessage(DUPLICATE_NAME, 3);
                } else if (DataSourceSelectionPage.this.containInvalidCharactor(DataSourceSelectionPage.this.dataSourceName.getText())) {
                    String msg = Messages.getFormattedString((String)"error.invalidName", (Object[])new Object[]{DataSourceSelectionPage.this.dataSourceName.getText()});
                    DataSourceSelectionPage.this.setMessage(msg, 3);
                } else {
                    DataSourceSelectionPage.this.setMessage(Messages.getString((String)"datasource.wizard.message.selectType"));
                }
                DataSourceSelectionPage.this.setPageComplete(!DataSourceSelectionPage.this.hasWizard() && DataSourceSelectionPage.this.getMessageType() != 3);
            }
        });
        this.setControl((Control)composite);
        Utility.setSystemHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.Wizard_NewDataSource_ID");
    }

    private Object[] getFilteredDataSourceArray(ExtensionManifest[] extensionManifest) {
        HashMap<String, ExtensionManifest> extensionPointMap = new HashMap<String, ExtensionManifest>();
        int i = 0;
        while (i < extensionManifest.length) {
            extensionPointMap.put(extensionManifest[i].getDataSourceElementID(), extensionManifest[i]);
            ++i;
        }
        return extensionManifest;
    }

    private void setupDSChoiceListRadio(Composite composite) {
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 3;
        this.dsChoiceListRadio = new Button(composite, 16);
        this.dsChoiceListRadio.setLayoutData((Object)layoutData);
        this.dsChoiceListRadio.setSelection(true);
        this.dsChoiceListRadio.setText(Messages.getString((String)"datasource.wizard.label.datasources"));
        this.dsChoiceListRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourceSelectionPage.this.enableNonCP(DataSourceSelectionPage.this.dsChoiceListRadio.getSelection());
                if (DataSourceSelectionPage.this.dsChoiceListRadio.getSelection()) {
                    DataSourceSelectionPage.this.setPageComplete(!DataSourceSelectionPage.this.hasWizard() && DataSourceSelectionPage.this.getMessageType() != 3);
                }
            }
        });
    }

    private void setupConnectionProfileRadio(Composite composite) {
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.connectionProfileRadio = new Button(composite, 16);
        this.connectionProfileRadio.setSelection(false);
        this.connectionProfileRadio.setText(Messages.getString((String)"datasource.wizard.label.connectionfile"));
        this.connectionProfileRadio.setLayoutData((Object)layoutData);
        this.connectionProfileRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourceSelectionPage.this.enableNonCP(!DataSourceSelectionPage.this.connectionProfileRadio.getSelection());
                if (DataSourceSelectionPage.this.connectionProfileRadio.getSelection()) {
                    DataSourceSelectionPage.this.setPageComplete(false);
                }
            }
        });
    }

    private void enableNonCP(boolean bool) {
        this.dataSourceList.getList().setEnabled(bool);
        this.dataSourceNameLabel.setEnabled(bool);
        this.dataSourceName.setEnabled(bool);
    }

    public IWizardPage getNextPage() {
        if (this.isCPSelected()) {
            return this.getNextPageCP();
        }
        this.prevSelectedDataSourceType = this.getSelectedDataSource();
        String dataSourceElementID = ((ExtensionManifest)this.prevSelectedDataSourceType).getDataSourceElementID();
        String dataSourceDisplayName = ((ExtensionManifest)this.prevSelectedDataSourceType).getDataSourceDisplayName();
        String dataSourceExtensionID = ((ExtensionManifest)this.prevSelectedDataSourceType).getExtensionID();
        DesignSessionRequest request = null;
        try {
            URI applURI = DTPUtil.getInstance().getBIRTResourcePath();
            URI designURI = DTPUtil.getInstance().getReportDesignPath();
            request = DesignSessionUtil.createNewDataSourceRequest((String)dataSourceExtensionID, (String)dataSourceElementID, (String)dataSourceDisplayName, (URI)applURI, (URI)designURI);
        }
        catch (URISyntaxException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (OdaException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (DesignSessionUtil.hasValidOdaDesignUIExtension((String)dataSourceElementID)) {
            return this.getNextPageODAV3(dataSourceElementID, request);
        }
        IConfigurationElement dataSourceElement = DataSetProvider.findDataSourceElement((String)dataSourceElementID);
        if (dataSourceElement != null) {
            return this.getNextPageODAV2(dataSourceElement);
        }
        return super.getNextPage();
    }

    private IWizardPage getNextPageCP() {
        try {
            if (this.m_designSession == null) {
                this.m_designSession = DataSourceDesignSession.startNewDesignFromProfile();
            }
            this.m_designSession.setDesignNameValidator((DataSourceDesignSession.IDesignNameValidator)new DataSourceDesignNameValidator());
            this.m_designSession.setUseProfileSelectionPage(true);
            return this.m_designSession.getWizardStartingPage();
        }
        catch (OdaException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return super.getNextPage();
        }
    }

    private IWizardPage getNextPageODAV3(String dataSourceElementID, DesignSessionRequest request) {
        this.useODAV3 = true;
        try {
            if (this.m_designSession == null) {
                this.m_designSession = DataSourceDesignSession.startNewDesign((String)dataSourceElementID, (String)this.dataSourceName.getText(), null, (DesignSessionRequest)request);
            } else {
                this.m_designSession.restartNewDesign(dataSourceElementID, this.dataSourceName.getText(), null, request);
            }
            this.m_designSession.setUseProfileSelectionPage(false);
            return this.m_designSession.getWizardStartingPage();
        }
        catch (OdaException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return super.getNextPage();
        }
    }

    private IWizardPage getNextPageODAV2(IConfigurationElement dataSourceElement) {
        this.useODAV3 = false;
        AbstractDataSourceConnectionWizard connectionWizard = null;
        IConfigurationElement[] elements = dataSourceElement.getChildren("newDataSourceWizard");
        if (elements != null && elements.length > 0) {
            Object wizard = null;
            try {
                wizard = elements[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            if (wizard instanceof AbstractDataSourceConnectionWizard) {
                String wizardTitle = Messages.getString((String)"datasource.new");
                connectionWizard = (AbstractDataSourceConnectionWizard)wizard;
                connectionWizard.setWindowTitle(wizardTitle);
                connectionWizard.setConfigurationElement(dataSourceElement);
                connectionWizard.addPages();
            }
        }
        this.dataSourceIsCreated = true;
        if (connectionWizard != null) {
            try {
                connectionWizard.getDataSource().setName(this.dataSourceName.getText());
                return connectionWizard.getStartingPage();
            }
            catch (NameException e) {
                this.dataSourceIsCreated = false;
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.getMessageType() != 3 && !this.isPageComplete();
    }

    private boolean hasWizard() {
        Object dataSourceObj = this.getSelectedDataSource();
        if (dataSourceObj instanceof ExtensionManifest) {
            if (DesignSessionUtil.hasValidOdaDesignUIExtension((String)((ExtensionManifest)dataSourceObj).getDataSourceElementID())) {
                return true;
            }
            IConfigurationElement dataSourceElement = DataSetProvider.findDataSourceElement((String)((ExtensionManifest)dataSourceObj).getExtensionID());
            if (dataSourceElement != null) {
                AbstractDataSourceConnectionWizard connectionWizard = (AbstractDataSourceConnectionWizard)this.htDataSourceWizards.get(dataSourceElement.getAttribute(ODA_EXTENSION_ID));
                if (connectionWizard != null) {
                    return true;
                }
                IConfigurationElement[] elements = dataSourceElement.getChildren("newDataSourceWizard");
                if (elements != null && elements.length > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDuplicateName() {
        String name = this.dataSourceName.getText().trim();
        return Utility.checkDataSourceName((String)name);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
        if (this.isCPSelected()) {
            return;
        }
        if (visible && ((ExtensionManifest[])this.dataSourceList.getInput()).length > 0) {
            if (this.prevSelectedDataSourceType == null) {
                this.dataSourceList.setSelection((ISelection)new StructuredSelection(this.dataSourceList.getElementAt(0)));
            } else {
                this.dataSourceList.setSelection((ISelection)new StructuredSelection(this.prevSelectedDataSourceType));
            }
        }
        if (visible && this.dataSourceIsCreated) {
            this.getActivityStack().rollback();
            this.dataSourceIsCreated = false;
        }
    }

    public boolean createSelectedDataSource() {
        this.createSelectedDataSourceInit();
        if (this.isCPSelected()) {
            return this.createSelectedDataSourceODAV3();
        }
        if (!(this.getSelectedDataSource() instanceof ExtensionManifest)) {
            return this.createSelectedDataSourceScipt();
        }
        if (this.useODAV3) {
            return this.createSelectedDataSourceODAV3();
        }
        return this.createSelectedDataSourceODAV2();
    }

    private void createSelectedDataSourceInit() {
        this.getActivityStack().startTrans(CREATE_DATA_SOURCE_TRANS_NAME);
        this.parentHandle = Utility.getReportModuleHandle();
        this.slotHandle = ((ModuleHandle)this.parentHandle).getDataSources();
    }

    private boolean containInvalidCharactor(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(".") > -1 || name.indexOf("\\") > -1 || name.indexOf("/") > -1 || name.indexOf("!") > -1 || name.indexOf(";") > -1 || name.indexOf(",") > -1;
    }

    private boolean createSelectedDataSourceScipt() {
        String driverName = "script";
        Class<ScriptDataSourceHandle> classType = ScriptDataSourceHandle.class;
        DataSourceHandle dsHandle = this.createDataSource(classType, driverName);
        try {
            this.slotHandle.add((DesignElementHandle)dsHandle);
        }
        catch (ContentException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (NameException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (dsHandle instanceof ScriptDataSourceHandle) {
            Utility.setScriptActivityEditor();
        }
        this.createSelectedDataSourceTearDown();
        return true;
    }

    private boolean createSelectedDataSourceODAV3() {
        try {
            OdaDataSourceHandle dataSourceHandle = DTPUtil.getInstance().createOdaDataSourceHandle(this.m_designSession.finish().getResponse(), (ModuleHandle)this.parentHandle);
            if (dataSourceHandle != null) {
                this.slotHandle.add((DesignElementHandle)dataSourceHandle);
                this.m_designSession = null;
                this.createSelectedDataSourceTearDown();
            }
            return true;
        }
        catch (SemanticException e) {
            this.getActivityStack().rollback();
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (OdaException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private boolean createSelectedDataSourceODAV2() {
        Object dataSourceObj = this.getSelectedDataSource();
        String driverName = null;
        Class<OdaDataSourceHandle> classType = null;
        if (dataSourceObj instanceof ExtensionManifest) {
            driverName = ((ExtensionManifest)dataSourceObj).getExtensionID();
            classType = OdaDataSourceHandle.class;
        }
        try {
            DataSourceHandle dsHandle = this.createDataSource(classType, driverName);
            this.slotHandle.add((DesignElementHandle)dsHandle);
            this.createSelectedDataSourceTearDown();
            return true;
        }
        catch (SemanticException e) {
            this.getActivityStack().rollback();
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private DataSourceHandle createDataSource(Class classType, String dataSourceType) {
        if (classType == OdaDataSourceHandle.class) {
            OdaDataSourceHandle dsHandle = Utility.newOdaDataSource((String)this.dataSourceName.getText(), (String)dataSourceType);
            return dsHandle;
        }
        if (classType == ScriptDataSourceHandle.class) {
            ScriptDataSourceHandle dsHandle = Utility.newScriptDataSource((String)this.dataSourceName.getText());
            return dsHandle;
        }
        return null;
    }

    private void createSelectedDataSourceTearDown() {
        this.dataSourceIsCreated = true;
        this.getActivityStack().commit();
    }

    public CommandStack getActivityStack() {
        return Utility.getCommandStack();
    }

    private Object getSelectedDataSource() {
        return ((IStructuredSelection)this.dataSourceList.getSelection()).getFirstElement();
    }

    private boolean isCPSelected() {
        return this.connectionProfileRadio.getSelection();
    }

    private class DataSourceDesignNameValidator
    implements DataSourceDesignSession.IDesignNameValidator {
        private DataSourceDesignNameValidator() {
        }

        public boolean isValid(String designName) throws OdaException {
            if (Utility.checkDataSourceName((String)designName)) {
                throw new OdaException(Messages.getFormattedString((String)"datasource.editor.duplicatedName", (Object[])new Object[]{designName}));
            }
            if (DataSourceSelectionPage.this.containInvalidCharactor(designName)) {
                throw new OdaException(Messages.getFormattedString((String)"error.invalidName", (Object[])new Object[]{designName}));
            }
            return true;
        }
    }
}

