/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.JointDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.data.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.datatools.connectivity.oda.IBlob;

public class SelectValueFetcher {
    private SelectValueFetcher() {
    }

    public static List getSelectValueList(String expression, DataSetHandle dataSetHandle, boolean inclFilter) throws BirtException {
        boolean startsWithRow = ExpressionUtility.isColumnExpression(expression, true);
        boolean startsWithDataSetRow = ExpressionUtility.isColumnExpression(expression, false);
        if (!startsWithRow && !startsWithDataSetRow) {
            throw new DataException(Messages.getString((String)"SelectValueDialog.messages.info.invalidSelectVauleExpression"));
        }
        String columnName = null;
        columnName = startsWithDataSetRow ? ExpressionUtil.getColumnName((String)expression) : ExpressionUtil.getColumnBindingName((String)expression);
        Collection result = null;
        DataRequestSession session = null;
        if (dataSetHandle.getModuleHandle() instanceof ReportDesignHandle) {
            EngineConfig config = new EngineConfig();
            config.setProperty("PARENT_CLASSLOADER", (Object)DataSetProvider.getCustomScriptClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader(), (ModuleHandle)dataSetHandle.getModuleHandle()));
            ReportEngine engine = (ReportEngine)new ReportEngineFactory().createReportEngine(config);
            DummyEngineTask engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign((ReportDesignHandle)(dataSetHandle == null ? null : dataSetHandle.getModuleHandle())), dataSetHandle.getModuleHandle());
            session = engineTask.getDataSession();
            engineTask.run();
            new ArrayList();
            result = session.getColumnValueSet(dataSetHandle, dataSetHandle.getPropertyHandle("parameters").iterator(), null, columnName);
            engineTask.close();
            engine.destroy();
        } else {
            new ArrayList();
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, dataSetHandle == null ? null : dataSetHandle.getModuleHandle()));
            result = session.getColumnValueSet(dataSetHandle, dataSetHandle.getPropertyHandle("parameters").iterator(), null, columnName);
        }
        assert (result != null);
        if (result.isEmpty()) {
            return new ArrayList();
        }
        Object resultProtoType = result.iterator().next();
        if (resultProtoType instanceof IBlob || resultProtoType instanceof byte[]) {
            return new ArrayList();
        }
        if (session != null) {
            session.shutdown();
        }
        return new ArrayList(result);
    }

    private static void defineSourceAndDataSets(DataRequestSession session, DataSetHandle dataSet, BaseDataSetDesign dataSetDesign, boolean inclFilter) throws BirtException {
        if (dataSet.getDataSource() != null) {
            session.defineDataSource((IBaseDataSourceDesign)session.getModelAdaptor().adaptDataSource(dataSet.getDataSource()));
        }
        if (!inclFilter && dataSetDesign.getFilters() != null) {
            dataSetDesign.getFilters().clear();
        }
        session.defineDataSet((IBaseDataSetDesign)dataSetDesign);
        if (dataSetDesign instanceof JointDataSetDesign) {
            SelectValueFetcher.defineChildDSetAndDSource(session, (JointDataSetDesign)dataSetDesign, dataSet.getModuleHandle(), inclFilter, true);
            SelectValueFetcher.defineChildDSetAndDSource(session, (JointDataSetDesign)dataSetDesign, dataSet.getModuleHandle(), inclFilter, false);
        }
    }

    private static void defineChildDSetAndDSource(DataRequestSession session, JointDataSetDesign dataSetDesign, ModuleHandle modulehandle, boolean inclFilter, boolean isLeft) throws BirtException {
        DataSetHandle dataSetHandle = isLeft ? modulehandle.findDataSet(dataSetDesign.getLeftDataSetDesignName()) : modulehandle.findDataSet(dataSetDesign.getRightDataSetDesignName());
        SelectValueFetcher.defineSourceAndDataSets(session, dataSetHandle, session.getModelAdaptor().adaptDataSet(dataSetHandle), inclFilter);
    }

    private static String getReferenceColumnName(String expression, boolean mode) {
        List columnValue;
        block3: {
            try {
                columnValue = null;
                columnValue = ExpressionUtil.extractColumnExpressions((String)expression, (boolean)mode);
                if (columnValue != null && columnValue.size() != 0 || columnValue != null && columnValue.size() != 0) break block3;
                return null;
            }
            catch (BirtException birtException) {
                return null;
            }
        }
        return ((IColumnBinding)columnValue.get(0)).getResultSetColumnName();
    }

    public static List getSelectValueList(String expression, DataSetHandle dataSetHandle) throws BirtException {
        return SelectValueFetcher.getSelectValueList(expression, dataSetHandle, true);
    }
}

