/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.provider;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverLoader;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;

public class JdbcMetaDataProvider {
    private String userName;
    private String url;
    private String driverClass;
    private String password;
    private Connection connection;
    private static Logger logger = Logger.getLogger(JdbcMetaDataProvider.class.getName());
    private static JdbcMetaDataProvider instance = null;

    private JdbcMetaDataProvider(String driverClass, String url, String userName, String password) {
        this.driverClass = driverClass;
        this.url = url;
        this.userName = userName;
        this.password = password;
    }

    public static void createInstance(DataSetDesign dataSetDesign) {
        JdbcMetaDataProvider.release();
        DataSourceDesign dataSourceDesign = dataSetDesign.getDataSourceDesign();
        Properties props = new Properties();
        try {
            props = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)dataSourceDesign);
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        String userName = props.getProperty("odaUser");
        String password = props.getProperty("odaPassword");
        String url = props.getProperty("odaURL");
        String driverClass = props.getProperty("odaDriverClass");
        instance = new JdbcMetaDataProvider(driverClass, url, userName, password);
    }

    public static void release() {
        if (instance != null) {
            instance.closeConnection();
            instance = null;
        }
    }

    public void reconnect() throws SQLException, OdaException {
        this.closeConnection();
        this.connection = DriverLoader.getConnection(this.driverClass, this.url, this.userName, this.password);
    }

    private void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public static JdbcMetaDataProvider getInstance() {
        return instance;
    }

    public String getIdentifierQuoteString() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return "";
            }
            try {
                return this.connection.getMetaData().getIdentifierQuoteString();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return "";
            }
        }
        try {
            return this.connection.getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getIdentifierQuoteString();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return "";
            }
        }
    }

    public boolean isSupportProcedure() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
            try {
                return this.connection.getMetaData().supportsStoredProcedures();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
        }
        try {
            return this.connection.getMetaData().supportsStoredProcedures();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().supportsStoredProcedures();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
        }
    }

    public boolean isSupportSchema() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
            try {
                return this.connection.getMetaData().supportsSchemasInTableDefinitions();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
        }
        try {
            return this.connection.getMetaData().supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().supportsSchemasInTableDefinitions();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return false;
            }
        }
    }

    public ResultSet getTableColumns(String schemaPattern, String tableNamePattern, String columnNamePattern) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getColumns(this.connection.getCatalog(), schemaPattern, tableNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getColumns(this.connection.getCatalog(), schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getColumns(this.connection.getCatalog(), schemaPattern, tableNamePattern, columnNamePattern);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    public ResultSet getProcedures(String schemaPattern, String procedureNamePattern) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getProcedures(this.connection.getCatalog(), schemaPattern, procedureNamePattern);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getProcedures(this.connection.getCatalog(), schemaPattern, procedureNamePattern);
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getProcedures(this.connection.getCatalog(), schemaPattern, procedureNamePattern);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    public ResultSet getProcedureColumns(String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getProcedureColumns(this.connection.getCatalog(), schemaPattern, procedureNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getProcedureColumns(this.connection.getCatalog(), schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getProcedureColumns(this.connection.getCatalog(), schemaPattern, procedureNamePattern, columnNamePattern);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    public ResultSet getAlltables(String schemaPattern, String namePattern, String[] types) {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getTables(this.connection.getCatalog(), schemaPattern, namePattern, types);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getTables(this.connection.getCatalog(), schemaPattern, namePattern, types);
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getTables(this.connection.getCatalog(), schemaPattern, namePattern, types);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    public ResultSet getAllSchemas() {
        if (this.connection == null) {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
            try {
                return this.connection.getMetaData().getSchemas();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        try {
            return this.connection.getMetaData().getSchemas();
        }
        catch (SQLException e) {
            try {
                this.reconnect();
                return this.connection.getMetaData().getSchemas();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    public String[] getAllSchemaNames() {
        ResultSet rs = this.getAllSchemas();
        ArrayList<String> names = new ArrayList<String>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    names.add(rs.getString("TABLE_SCHEM"));
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return names.toArray(new String[0]);
    }
}

