/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;

public class ImageHandleAdapter
extends ReportItemtHandleAdapter {
    public ImageHandleAdapter(ImageHandle image, IModelAdapterHelper mark) {
        super((ReportItemHandle)image, mark);
    }

    public Image getImage() {
        String imageSource = this.getImageHandle().getSource();
        if ("embed".equalsIgnoreCase(imageSource)) {
            return ImageManager.getInstance().getEmbeddedImage(this.getImageHandle().getModuleHandle(), this.getImageHandle().getImageName());
        }
        if ("file".equalsIgnoreCase(imageSource)) {
            if (URIUtil.isValidResourcePath((String)this.getImageHandle().getURI())) {
                return ImageManager.getInstance().getImage(this.getHandle().getModuleHandle(), URIUtil.getLocalPath((String)this.removeQuoteString(this.getImageHandle().getURI())));
            }
            return ImageManager.getInstance().getImage(this.getHandle().getModuleHandle(), this.removeQuoteString(this.getImageHandle().getURI()));
        }
        if ("url".equalsIgnoreCase(imageSource)) {
            return ImageManager.getInstance().getURIImage(this.getHandle().getModuleHandle(), this.removeQuoteString(this.getImageHandle().getURI()));
        }
        "expr".equalsIgnoreCase(imageSource);
        return null;
    }

    private String removeQuoteString(String value) {
        if (value != null && value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private ImageHandle getImageHandle() {
        return (ImageHandle)this.getHandle();
    }

    public Dimension getSize() {
        DimensionHandle widthHandle = this.getImageHandle().getWidth();
        int px = (int)DEUtil.convertoToPixel(widthHandle);
        DimensionHandle heightHandle = this.getImageHandle().getHeight();
        int py = (int)DEUtil.convertoToPixel(heightHandle);
        if (DEUtil.isFixLayout(this.getHandle())) {
            if (px == 0 && widthHandle.isSet()) {
                px = 1;
            }
            if (py == 0 && heightHandle.isSet()) {
                py = 1;
            }
        }
        if (px != 0 && py != 0) {
            return new Dimension(px, py);
        }
        return null;
    }

    public Dimension getRawSize() {
        DimensionHandle widthHandle = this.getImageHandle().getWidth();
        int px = (int)DEUtil.convertoToPixel(widthHandle);
        DimensionHandle heightHandle = this.getImageHandle().getHeight();
        int py = (int)DEUtil.convertoToPixel(heightHandle);
        if (DEUtil.isFixLayout(this.getHandle())) {
            if (px == 0 && widthHandle.isSet()) {
                px = 1;
            }
            if (py == 0 && heightHandle.isSet()) {
                py = 1;
            }
        }
        return new Dimension(Math.max(px, 0), Math.max(py, 0));
    }

    public void setSize(Dimension size) throws SemanticException {
        if (size.width >= 0) {
            this.getImageHandle().setWidth(String.valueOf(size.width) + "px");
        }
        if (size.height >= 0) {
            this.getImageHandle().setHeight(String.valueOf(size.height) + "px");
        }
    }
}

