/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.dialog;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class WizardResourceSettingPage
extends WizardPage {
    private static String PAGE_DESC = Messages.getString((String)"PublishResourceDialog.Message");
    private static String PAGE_DESC2 = Messages.getString((String)"PublishResourceDialog.AddMessage");
    private static String LABEL_FILE_NAME = Messages.getString((String)"PublishResourceDialog.Label.FileName");
    private static String LABEL_SOURCE_FILE_NAME = Messages.getString((String)"PublishResourceDialog.Label.SourceFileName");
    private static String LABEL_FOLDER = Messages.getString((String)"PublishResourceDialog.Label.Folder");
    private static String BUTTON_BROWSE = Messages.getString((String)"PublishResourceDialog.Label.Browse");
    private static String BUTTON_BROWSE2 = Messages.getString((String)"PublishResourceDialog.Label.Browse2");
    private static final String PLUGIN_ID = "org.eclipse.birt.report.designer.ui.actions.PublishResourceAction";
    private String[] libraryExtensions = new String[]{String.valueOf(Messages.getString((String)"report.designer.ui.preferences.extensions")) + ";*.css;*.CSS", "*.*"};
    private String dialogTitle = Messages.getString((String)"AddResourceAction.Dialog.Tilte");
    private File selectedFolder;
    private Status pageStatus;
    private String fileName;
    private String folder;
    private Text nameText;
    private Text folderText;
    private Text sourceFileText;
    private Status OKStatus = new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);
    private Status ErrorStatus = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"WizardResourceSettingPage.ErrorMessage"), null);
    private int type;

    public void setType(int type) {
        this.type = type;
    }

    public String getSourceFileName() {
        if (this.sourceFileText != null && this.type == 0) {
            return this.sourceFileText.getText();
        }
        return null;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setfolderName(String folder) {
        this.folder = folder;
    }

    public String getFolder() {
        this.folder = this.folderText.getText();
        return this.folder;
    }

    public String getFileName() {
        this.fileName = this.nameText.getText();
        return this.fileName;
    }

    public WizardResourceSettingPage(int type) {
        super("");
        this.pageStatus = type == 0 ? new Status(0, PLUGIN_ID, 0, PAGE_DESC2, null) : new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
    }

    public WizardResourceSettingPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Button chooseBtn;
        int style;
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddResourceDialog_ID");
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        gd.heightHint = 350;
        container.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        if (this.type == 0) {
            new Label(container, 0).setText(LABEL_SOURCE_FILE_NAME);
            style = 2052;
            this.sourceFileText = this.createText(container, 1, style);
            this.sourceFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WizardResourceSettingPage.this.checkStatus(WizardResourceSettingPage.this.type);
                }
            });
            chooseBtn = new Button(container, 0);
            chooseBtn.setText(BUTTON_BROWSE2);
            chooseBtn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String sourceFileName = WizardResourceSettingPage.this.getFilePath();
                    if (sourceFileName != null) {
                        WizardResourceSettingPage.this.sourceFileText.setText(sourceFileName);
                        WizardResourceSettingPage.this.nameText.setText(sourceFileName.substring(sourceFileName.lastIndexOf(File.separator) + 1));
                        WizardResourceSettingPage.this.nameText.setFocus();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        new Label(container, 0).setText(LABEL_FILE_NAME);
        style = 2052;
        this.nameText = this.createText(container, 1, style);
        new Label(container, 0);
        if (this.fileName != null) {
            this.nameText.setText(this.fileName);
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardResourceSettingPage.this.checkStatus(WizardResourceSettingPage.this.type);
            }
        });
        new Label(container, 0).setText(LABEL_FOLDER);
        style = 2060;
        this.folderText = this.createText(container, 1, style);
        if (this.folder != null) {
            this.folderText.setText(this.folder);
        }
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardResourceSettingPage.this.checkStatus(WizardResourceSettingPage.this.type);
            }
        });
        chooseBtn = new Button(container, 0);
        chooseBtn.setText(BUTTON_BROWSE);
        chooseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selected;
                ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(false);
                dialog.setAllowMultiple(false);
                dialog.setTitle(Messages.getString((String)"WizardResourceSettingPage.Resourcefile.Dialog.Title"));
                dialog.setMessage(Messages.getString((String)"WizardResourceSettingPage.Resourcefile.Dialog.Message"));
                dialog.setValidator((ISelectionStatusValidator)new Validator());
                if (dialog.open() == 0 && (selected = dialog.getResult()).length > 0) {
                    ResourceEntry file = (ResourceEntry)selected[0];
                    WizardResourceSettingPage.this.folderText.setText(new File(file.getURL().getPath()).getAbsolutePath());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nameText.forceFocus();
        this.setControl((Control)container);
    }

    public void checkStatus(int type) {
        Status status = null;
        status = type == 0 ? new Status(0, PLUGIN_ID, 0, PAGE_DESC2, null) : new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
        if (type == 0 && WizardResourceSettingPage.isTextEmpty(this.sourceFileText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishResourceDialog.Message.SourceFileEmpty"), null);
        } else if (type == 0 && (new File(this.sourceFileText.getText()).isDirectory() || !new File(this.sourceFileText.getText()).exists())) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getFormattedString((String)"AddResourceAction.Error.FileNotFound", (Object[])new String[]{this.sourceFileText.getText()}), null);
        } else if (WizardResourceSettingPage.isTextEmpty(this.nameText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishResourceDialog.Message.FileNameEmpty"), null);
        } else if (WizardResourceSettingPage.isTextEmpty(this.folderText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishResourceDialog.Message.FolderEmpty"), null);
        }
        this.pageStatus = status;
        this.applyToStatusLine((IStatus)this.pageStatus);
        this.getWizard().getContainer().updateButtons();
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = PAGE_DESC;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 4: {
                this.setErrorMessage(message);
                this.setMessage(message, 3);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    private static boolean isTextEmpty(Text text) {
        String s = text.getText();
        return s == null || s.trim().length() <= 0;
    }

    private Text createText(Composite container, int column, int style) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = column;
        Text text = new Text(container, style);
        text.setLayoutData((Object)gridData);
        return text;
    }

    public boolean canFinish() {
        return !WizardResourceSettingPage.isTextEmpty(this.nameText) && !WizardResourceSettingPage.isTextEmpty(this.folderText) && this.pageStatus.isOK();
    }

    private boolean isFileExists(String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        try {
            return new File(this.selectedFolder, fileName).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getFilePath() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        dialog.setFilterExtensions(this.libraryExtensions);
        dialog.setText(this.dialogTitle);
        String fileName = dialog.open();
        if (fileName != null) {
            if (!new File(fileName).exists()) {
                ExceptionHandler.openErrorMessageBox((String)Messages.getString((String)"AddResourceAction.Error.Title"), (String)Messages.getFormattedString((String)"AddResourceAction.Error.FileNotFound", (Object[])new String[]{fileName}));
                return this.getFilePath();
            }
            if (this.isFileExists(fileName)) {
                ExceptionHandler.openErrorMessageBox((String)Messages.getString((String)"AddResourceAction.Error.Title"), (String)Messages.getString((String)"AddResourceAction.Error.Message"));
                return this.getFilePath();
            }
            return fileName;
        }
        return null;
    }

    private class Validator
    implements ISelectionStatusValidator {
        private Validator() {
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected == 0 || nSelected > 1) {
                return WizardResourceSettingPage.this.ErrorStatus;
            }
            return WizardResourceSettingPage.this.OKStatus;
        }
    }
}

