/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html.util;

import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public class HTMLEmitterUtil {
    public static final int DISPLAY_BLOCK = 1;
    public static final int DISPLAY_FLAG_ALL = 65535;
    public static final int DISPLAY_INLINE = 2;
    public static final int DISPLAY_INLINE_BLOCK = 4;
    public static final int DISPLAY_NONE = 8;
    public static int BROWSER_UNKNOW = -1;
    public static int BROWSER_FIREFOX1 = 11;
    public static int BROWSER_FIREFOX2 = 12;
    public static int BROWSER_FIREFOX3 = 13;
    public static int BROWSER_IE5 = 21;
    public static int BROWSER_IE6 = 22;
    public static int BROWSER_IE7 = 23;
    public static int BROWSER_IE8 = 24;

    public static int getElementType(IContent content) {
        return HTMLEmitterUtil.getElementType(content.getX(), content.getY(), content.getWidth(), content.getHeight(), content.getStyle());
    }

    public static String getTagByType(int display, int mask) {
        int flag = display & mask;
        String tag = null;
        if ((flag & 1) > 0) {
            tag = "div";
        }
        if ((flag & 2) > 0) {
            tag = "span";
        }
        return tag;
    }

    public static void setBookmark(HTMLWriter writer, String tagName, String htmlIDNamespace, String bookmark) {
        String htmlBookmark = htmlIDNamespace != null && bookmark != null && bookmark.length() > 0 ? String.valueOf(htmlIDNamespace) + bookmark : bookmark;
        writer.attribute("id", htmlBookmark);
        if ("a".equalsIgnoreCase(tagName)) {
            writer.attribute("name", htmlBookmark);
        }
    }

    private static int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    public static int getDimensionPixelValue(DimensionType d, int dpi) {
        if (d == null) {
            return 0;
        }
        try {
            String units = d.getUnits();
            if ("px".equals(units)) {
                return (int)d.getMeasure();
            }
            if ("pt".equals(units) || "cm".equals(units) || "mm".equals(units) || "pc".equals(units) || "in".equals(units)) {
                double point = d.convertTo("pt");
                if (dpi > 0) {
                    return (int)(point / 72.0 * (double)dpi);
                }
                return (int)(point / 72.0 * 96.0);
            }
            if ("%".equals(units)) {
                return 0;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return 0;
    }

    public static ReportElementHandle getElementHandle(Object element) {
        Object generateBy = null;
        if (element instanceof IContent) {
            generateBy = ((IContent)element).getGenerateBy();
        } else if (element instanceof IColumn) {
            generateBy = ((IColumn)element).getGenerateBy();
        }
        if (generateBy instanceof ReportItemDesign) {
            DesignElementHandle handle = ((ReportItemDesign)generateBy).getHandle();
            if (handle instanceof ReportElementHandle) {
                return (ReportElementHandle)handle;
            }
        } else if (generateBy instanceof ColumnDesign) {
            DesignElementHandle handle = ((ColumnDesign)generateBy).getHandle();
            if (handle instanceof ReportElementHandle) {
                return (ReportElementHandle)handle;
            }
        } else if (generateBy instanceof ReportElementHandle) {
            return (ReportElementHandle)generateBy;
        }
        return null;
    }

    public static int getBrowserVersion(String userAgent) {
        if (userAgent == null || userAgent.length() <= 0) {
            return BROWSER_UNKNOW;
        }
        if (userAgent.contains("; MSIE 7")) {
            return BROWSER_IE7;
        }
        return BROWSER_UNKNOW;
    }
}

