/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.actions;

import java.io.File;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.rcp.nls.DesignerWorkbenchMessages;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class OpenFileAction
extends Action
implements IWorkbenchWindowActionDelegate,
ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow fWindow;
    private static String[] filterExtensions;

    static {
        List list = ReportPlugin.getDefault().getReportExtensionNameList();
        filterExtensions = new String[list.size() + 3];
        int i = 0;
        while (i < list.size()) {
            OpenFileAction.filterExtensions[i] = "*." + list.get(i);
            ++i;
        }
        OpenFileAction.filterExtensions[OpenFileAction.filterExtensions.length - 3] = "*.rptlibrary";
        OpenFileAction.filterExtensions[OpenFileAction.filterExtensions.length - 2] = "*.rpttemplate";
        OpenFileAction.filterExtensions[OpenFileAction.filterExtensions.length - 1] = "*.rptdocument";
    }

    public OpenFileAction(IWorkbenchWindow window) {
        this.init(window);
        this.setEnabled(true);
        this.setText(DesignerWorkbenchMessages.Workbench_openFile);
        this.setToolTipText(DesignerWorkbenchMessages.Action_openReport);
        this.setId("org.eclipse.birt.report.designer.rcp.internal.ui.actions.OpenFileAction");
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4098);
        dialog.setText(DesignerWorkbenchMessages.Dialog_openFile);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getProjectRelativePath().toOSString());
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null) {
            String fFilterPath = dialog.getFilterPath();
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            int i = 0;
            while (i < names.length) {
                File file = new File(String.valueOf(fFilterPath) + File.separator + names[i]);
                if (file.exists()) {
                    IWorkbenchPage page = this.fWindow.getActivePage();
                    ReportEditorInput input = new ReportEditorInput(file);
                    IEditorDescriptor editorDesc = this.getEditorDescriptor((IEditorInput)input, OpenStrategy.activateOnOpen());
                    try {
                        page.openEditor((IEditorInput)input, editorDesc.getId());
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(file.getName());
                }
                ++i;
            }
        }
    }

    private IEditorDescriptor getEditorDescriptor(IEditorInput input, boolean determineContentType) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(input.getName());
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        return editorReg.getDefaultEditor(input.getName(), contentType);
    }
}

