/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.dialogs;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.NewReportPageSupport;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class SaveAsDialog
extends TitleAreaDialog {
    private static final String DEFAULT_MESSAGE = Messages.getString((String)"SaveAsDialog.message");
    private NewReportPageSupport support;
    private Control okButton;
    private static final String MSG_EMPTY_FILE_LOCATION_DIRECTORY = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.locationDirectory");
    private static final String MSG_EMPTY_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.name");
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            SaveAsDialog.this.setDialogComplete(SaveAsDialog.this.validatePage());
        }
    };
    private IPath result;

    public SaveAsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.support = new NewReportPageSupport();
    }

    public void setOriginalFile(IEditorInput input) {
        String container = ((ReportEditorInput)input).getPath().removeLastSegments(1).toOSString();
        this.support.setInitialFileLocation(container);
        this.support.setInitialFileName(((ReportEditorInput)input).getName());
    }

    public void setOriginalName(String originalName) {
        this.support.setInitialFileName(originalName);
    }

    public IPath getResult() {
        return this.result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString((String)"SaveAsDialog.text"));
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.getString((String)"SaveAsDialog.title"));
        Image dlgTitleImage = ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
        this.setTitleImage(dlgTitleImage);
        this.setMessage(DEFAULT_MESSAGE);
        this.setDialogComplete(this.validatePage());
        return contents;
    }

    public boolean close() {
        this.support = null;
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = this.support.createComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        this.support.getFileNameField().setFocus();
        this.support.getFileNameField().addListener(24, this.locationModifyListener);
        this.support.getLocationPathField().addListener(24, this.locationModifyListener);
        return parentComposite;
    }

    private boolean validatePage() {
        if (this.support.getFileName().equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_NAME);
            return false;
        }
        String location = this.support.getFileLocationFullPath().toOSString();
        if (location.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_LOCATION_DIRECTORY);
            return false;
        }
        this.setMessage(DEFAULT_MESSAGE);
        this.setErrorMessage(null);
        return true;
    }

    protected void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }

    protected void okPressed() {
        File file;
        IPath path = this.support.getFileLocationFullPath().append(this.support.getFileName());
        if (!ReportPlugin.getDefault().isReportDesignFile(path.toOSString())) {
            String[] parts = this.support.getInitialFileName().split("\\.");
            path = path.addFileExtension(parts[parts.length - 1]);
        }
        if ((file = path.toFile()).exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{path.toOSString()});
            MessageDialog d = new MessageDialog(this.getShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    this.cancelPressed();
                    return;
                }
            }
        }
        this.result = path;
        this.close();
    }
}

