/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardTemplateChoicePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.internal.rcp.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;

public class NewReportWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String NEW = Messages.getString((String)"NewReportWizard.title.New");
    private static final String REPORT = Messages.getString((String)"NewReportWizard.title.Report");
    private static final String WIZARDPAGE = Messages.getString((String)"NewReportWizard.title.WizardPage");
    private static final String TEMPLATECHOICEPAGE = Messages.getString((String)"NewReportWizard.title.Template");
    private static final String CREATE_A_NEW_REPORT = Messages.getString((String)"NewReportWizard.text.CreateReport");
    private static final String SELECT_A_REPORT_TEMPLATE = Messages.getString((String)"NewReportWizard.text.SelectTemplate");
    private static final String CREATING = Messages.getString((String)"NewReportWizard.text.Creating");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewReportWizard.text.OpenFileForEditing");
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewReportWizard.displayName.NewReportFileNamePrefix");
    private String fileExtension = ".rptdesign";
    private WizardNewReportCreationPage newReportFileWizardPage;
    private WizardTemplateChoicePage templateChoicePage;

    public NewReportWizard() {
        this.setWindowTitle(NEW);
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
    }

    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE);
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.templateChoicePage = new WizardTemplateChoicePage(TEMPLATECHOICEPAGE);
        this.addPage((IWizardPage)this.templateChoicePage);
        this.newReportFileWizardPage.setTitle(REPORT);
        this.newReportFileWizardPage.setDescription(CREATE_A_NEW_REPORT);
        this.templateChoicePage.setTitle(REPORT);
        this.templateChoicePage.setDescription(SELECT_A_REPORT_TEMPLATE);
        this.newReportFileWizardPage.setInitialFileName(this.getNewFileFullName(NEW_REPORT_FILE_NAME_PREFIX));
        this.newReportFileWizardPage.setInitialFileLocation(this.getDefaultLocation());
    }

    private String getDefaultLocation() {
        IPath defaultPath = Platform.getLocation();
        return defaultPath.toOSString();
    }

    private String getNewFileFullName(String defaultName) {
        String path = this.getDefaultLocation();
        String name = String.valueOf(defaultName) + this.fileExtension;
        int count = 0;
        File file = new File(path, name);
        while (file.exists()) {
            name = String.valueOf(defaultName) + "_" + ++count + this.fileExtension;
            file = null;
            file = new File(path, name);
        }
        file = null;
        return name;
    }

    public boolean performFinish() {
        final IPath locPath = this.newReportFileWizardPage.getFileLocationFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        final String fileName = !Platform.getOS().equals("win32") ? (!fn.endsWith(this.fileExtension) ? String.valueOf(fn) + this.fileExtension : fn) : (!fn.toLowerCase(Locale.getDefault()).endsWith(this.fileExtension) ? String.valueOf(fn) + this.fileExtension : fn);
        String cheatSheetIdFromPage = "";
        boolean showCheatSheetFromPage = false;
        ReportDesignHandle selTemplate = this.templateChoicePage.getTemplate();
        final String templateFileName = selTemplate.getFileName();
        cheatSheetIdFromPage = selTemplate.getCheatSheet();
        if (cheatSheetIdFromPage == null) {
            cheatSheetIdFromPage = "";
        }
        showCheatSheetFromPage = this.templateChoicePage.getShowCheatSheet();
        final String cheatSheetId = cheatSheetIdFromPage;
        final boolean showCheatSheet = showCheatSheetFromPage;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    NewReportWizard.this.doFinish(locPath, fileName, templateFileName, cheatSheetId, showCheatSheet, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionHandler.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath locationPath, String fileName, String sourceFileName, final String cheatSheetId, final boolean showCheatSheet, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(CREATING) + fileName, 2);
        final File file = new File(locationPath.toString(), fileName);
        try {
            File container = new File(locationPath.toString());
            boolean conExists = container.exists();
            if (!conExists) {
                conExists = container.mkdirs();
            }
            if (!conExists) {
                ExceptionHandler.openErrorMessageBox((String)Messages.getString((String)"NewReportWizard.title.Error"), (String)Messages.getString((String)"NewReportWizard.wizard.msgDirErr"));
                return;
            }
            ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().createDesignFromTemplate(sourceFileName);
            if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
            }
            if (ReportPlugin.getDefault().getDefaultUnitPreference() != null) {
                handle.setStringProperty("units", ReportPlugin.getDefault().getDefaultUnitPreference());
            }
            if (this.isPredifinedTemplate(sourceFileName)) {
                handle.setDisplayName(null);
                handle.setDescription(null);
            }
            String bidiOrientation = this.templateChoicePage.isLTRDirection() ? "ltr" : "rtl";
            handle.setBidiOrientation(bidiOrientation);
            handle.saveAs(file.getAbsolutePath());
            handle.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    if (page == null) {
                        throw new IllegalArgumentException();
                    }
                    page.openEditor((IEditorInput)new ReportEditorInput(file), "org.eclipse.birt.report.designer.ui.editors.ReportEditor", true);
                    if (showCheatSheet && !cheatSheetId.equals("")) {
                        Display.getCurrent().getActiveShell().setData((Object)page);
                        new OpenCheatSheetAction(cheatSheetId).run();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    public boolean canFinish() {
        return this.templateChoicePage.isPageComplete() && this.newReportFileWizardPage.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean isPredifinedTemplate(String sourceFileName) {
        String predifinedDir = UIUtil.getFragmentDirectory();
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(sourceFileName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }
}

