/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.widget.ExpressionCellEditor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.Rule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class LevelPropertyDialog
extends TitleAreaDialog {
    private Composite dynamicArea;
    private DataSetHandle dataset;
    private boolean isNew;
    private static final String dummyChoice = "dummy";
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            if (input instanceof List) {
                List list = (List)input;
                if (!list.contains(LevelPropertyDialog.dummyChoice)) {
                    list.add(LevelPropertyDialog.dummyChoice);
                }
                return list.toArray();
            }
            return new Object[0];
        }
    };
    private IStructuredContentProvider defaultValueContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            if (input instanceof TabularLevelHandle) {
                ArrayList<String> list = new ArrayList<String>();
                if (((TabularLevelHandle)input).getDefaultValue() != null) {
                    list.add(((TabularLevelHandle)input).getDefaultValue());
                } else {
                    list.add(LevelPropertyDialog.dummyChoice);
                }
                return list.toArray();
            }
            return new Object[0];
        }
    };
    private ITableLabelProvider staticLabelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return Messages.getString("LevelPropertyDialog.MSG.Static.CreateNew");
                }
                if (element instanceof RuleHandle) {
                    return ((RuleHandle)element).getDisplayExpression();
                }
                return "";
            }
            if (columnIndex == 2) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return "";
                }
                if (element instanceof RuleHandle) {
                    return ((RuleHandle)element).getRuleExpression();
                }
                return "";
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ITableLabelProvider defaultValueLabelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return Messages.getString("LevelPropertyDialog.MSG.DefaultValue");
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }
            if (columnIndex == 2) {
                return Messages.getString("LevelPropertyDialog.MSG.Tooltip");
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ITableLabelProvider dynamicLabelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (element == LevelPropertyDialog.dummyChoice) {
                    return Messages.getString("LevelPropertyDialog.MSG.Dynamic.CreateNew");
                }
                if (element instanceof LevelAttributeHandle) {
                    return ((LevelAttributeHandle)element).getName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier dynamicCellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof LevelAttributeHandle) {
                LevelAttributeHandle handle = (LevelAttributeHandle)element;
                LevelPropertyDialog.this.resetEditorItems(handle.getName());
                int i = 0;
                while (i < LevelPropertyDialog.this.editor.getItems().length) {
                    if (handle.getName().equals(LevelPropertyDialog.this.editor.getItems()[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            if (element instanceof String) {
                LevelPropertyDialog.this.resetEditorItems();
            }
            return -1;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if ((Integer)value > -1 && (Integer)value < LevelPropertyDialog.this.editor.getItems().length) {
                if (element instanceof LevelAttributeHandle) {
                    LevelAttributeHandle handle = (LevelAttributeHandle)element;
                    try {
                        handle.setName(LevelPropertyDialog.this.editor.getItems()[(Integer)value]);
                        if (LevelPropertyDialog.this.dataset != null) {
                            ResultSetColumnHandle dataField = OlapUtil.getDataField(LevelPropertyDialog.this.dataset, handle.getName());
                            handle.setDataType(dataField.getDataType());
                        }
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    LevelAttribute attribute = StructureFactory.createLevelAttribute();
                    attribute.setName(LevelPropertyDialog.this.editor.getItems()[(Integer)value]);
                    if (LevelPropertyDialog.this.dataset != null) {
                        ResultSetColumnHandle dataField = OlapUtil.getDataField(LevelPropertyDialog.this.dataset, attribute.getName());
                        attribute.setDataType(dataField.getDataType());
                    }
                    try {
                        LevelPropertyDialog.this.input.getPropertyHandle("attributes").addItem((IStructure)attribute);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                LevelPropertyDialog.this.refreshDynamicViewer();
            }
        }
    };
    private ICellModifier staticCellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            if (property.equals(LevelPropertyDialog.Prop_Name)) {
                return true;
            }
            return element != LevelPropertyDialog.dummyChoice;
        }

        public Object getValue(Object element, String property) {
            if (property.equals(LevelPropertyDialog.Prop_Name)) {
                if (element != LevelPropertyDialog.dummyChoice && element instanceof RuleHandle) {
                    return ((RuleHandle)element).getDisplayExpression();
                }
                return "";
            }
            if (element != LevelPropertyDialog.dummyChoice && element instanceof RuleHandle) {
                String result = ((RuleHandle)element).getRuleExpression();
                return result == null ? "" : result;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (property.equals(LevelPropertyDialog.Prop_Name) && !value.toString().trim().equals("") && !value.equals(LevelPropertyDialog.dummyChoice)) {
                if (element instanceof RuleHandle) {
                    ((RuleHandle)element).setDisplayExpression(value.toString());
                } else {
                    Rule rule = StructureFactory.createRule();
                    rule.setProperty("displayExpre", (Object)value.toString());
                    rule.setProperty("ruleExpre", (Object)"");
                    try {
                        LevelPropertyDialog.this.input.getPropertyHandle("staticValues").addItem((IStructure)rule);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                LevelPropertyDialog.this.refreshStaticViewer();
            } else if (property.equals(LevelPropertyDialog.prop_Expression) && element instanceof RuleHandle) {
                if (element != LevelPropertyDialog.dummyChoice && !value.toString().trim().equals("")) {
                    ((RuleHandle)element).setRuleExpression(value.toString());
                } else {
                    ((RuleHandle)element).setRuleExpression(null);
                }
                LevelPropertyDialog.this.refreshStaticViewer();
            }
        }
    };
    private ICellModifier defaultValueCellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return property.equals(LevelPropertyDialog.Prop_DefaultValue);
        }

        public Object getValue(Object element, String property) {
            if (property.equals(LevelPropertyDialog.Prop_DefaultValue) && element != LevelPropertyDialog.dummyChoice && element instanceof String) {
                return (String)element;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (property.equals(LevelPropertyDialog.Prop_DefaultValue)) {
                try {
                    if (!value.toString().trim().equals("") && !value.equals(LevelPropertyDialog.dummyChoice)) {
                        LevelPropertyDialog.this.input.setDefaultValue(value.toString());
                    } else {
                        LevelPropertyDialog.this.input.setDefaultValue(null);
                    }
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            LevelPropertyDialog.this.refreshStaticViewer();
        }
    };
    private int dynamicSelectIndex;
    String[] attributeItems = new String[0];
    private TabularLevelHandle input;
    private TableViewer dynamicViewer;
    private Text nameText;
    private ComboBoxCellEditor editor;
    private TableViewer staticViewer;
    private Composite staticArea;
    private Button dynamicButton;
    private Button staticButton;
    protected int staticSelectIndex;
    private static final String Prop_Name = "Name";
    private static final String prop_Expression = "Expression";
    private static final String prop_Attribute = "Attribute";
    private static final String Prop_DefaultValue = "DefaultValue";
    private static final String prop_Tooltip = "Tooltip";
    private Table dynamicTable;
    private ExpressionCellEditor expressionEditor;
    private Combo staticDataTypeCombo;
    private Text staticNameText;
    private Combo fieldCombo;
    private Combo dynamicDataTypeCombo;
    private Combo displayKeyCombo;
    private TableViewer defaultValueViewer;
    private Table defaultValueTable;
    private TableColumn[] defaultValueColumns;
    private TableColumn[] staticColumns;

    private IChoice[] getAvailableDataTypeChoices() {
        IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getElement("Level").getProperty("dataType").getAllowedChoices().getChoices();
        ArrayList<IChoice> choiceList = new ArrayList<IChoice>();
        int i = 0;
        while (i < dataTypes.length) {
            choiceList.add(dataTypes[i]);
            ++i;
        }
        return choiceList.toArray(new IChoice[0]);
    }

    public String[] getDataTypeNames() {
        IChoice[] choices = this.getAvailableDataTypeChoices();
        if (choices == null) {
            return new String[0];
        }
        String[] names = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            names[i] = choices[i].getName();
            ++i;
        }
        return names;
    }

    public String getDataTypeDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Level").getProperty("dataType").getAllowedChoices());
    }

    private String[] getDataTypeDisplayNames() {
        IChoice[] choices = this.getAvailableDataTypeChoices();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    public LevelPropertyDialog(boolean isNew) {
        super(UIUtil.getDefaultShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.isNew = isNew;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.LevelPropertyDialog_ID");
        this.getShell().setText(Messages.getString("LevelPropertyDialog.Shell.Title"));
        if (this.isNew) {
            this.setTitle(Messages.getString("LevelPropertyDialog.Title.Add"));
        } else {
            this.setTitle(Messages.getString("LevelPropertyDialog.Title.Edit"));
        }
        this.setMessage(Messages.getString("LevelPropertyDialog.Message"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = 400;
        contents.setLayoutData((Object)data);
        this.createChoiceArea(contents);
        this.dynamicArea = this.createDynamicArea(contents);
        this.staticArea = this.createStaticArea(contents);
        WidgetUtil.createGridPlaceholder((Composite)contents, (int)1, (boolean)true);
        this.initLevelDialog();
        parent.layout();
        return contents;
    }

    private void initLevelDialog() {
        if (this.input != null) {
            this.expressionEditor.setExpressionProvider((IExpressionProvider)new CubeExpressionProvider((DesignElementHandle)this.input));
            if (this.input.getLevelType() == null) {
                try {
                    this.input.setLevelType("dynamic");
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            this.refreshDynamicViewer();
            this.dataset = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)this.input.getContainer());
            if (this.dataset != null) {
                this.attributeItems = OlapUtil.getDataFieldNames(this.dataset);
            }
            this.resetEditorItems();
            if (this.input.getName() != null) {
                this.nameText.setText(this.input.getName());
            }
            this.dynamicDataTypeCombo.setItems(this.getDataTypeDisplayNames());
            this.dynamicDataTypeCombo.setText(this.getDataTypeDisplayName(this.input.getDataType()));
            this.fieldCombo.setItems(OlapUtil.getDataFieldNames(this.dataset));
            if (this.input.getColumnName() != null) {
                this.fieldCombo.setText(this.input.getColumnName());
            } else {
                this.fieldCombo.select(0);
            }
            this.displayKeyCombo.setItems(OlapUtil.getDataFieldNames(this.dataset));
            this.displayKeyCombo.add(Messages.getString("LevelPropertyDialog.None"), 0);
            if (this.input.getDisplayColumnName() != null) {
                this.displayKeyCombo.setText(this.input.getDisplayColumnName());
            } else if (this.displayKeyCombo.getItemCount() > 0) {
                this.displayKeyCombo.select(0);
            }
            this.staticDataTypeCombo.setItems(this.getDataTypeDisplayNames());
            this.staticNameText.setText(this.input.getName());
            this.staticDataTypeCombo.setText(this.getDataTypeDisplayName(this.input.getDataType()));
            this.refreshStaticViewer();
            if (this.input.getLevelType().equals("dynamic")) {
                this.dynamicButton.setSelection(true);
                this.updateButtonStatus(this.dynamicButton);
            } else {
                this.staticButton.setSelection(true);
                this.updateButtonStatus(this.staticButton);
            }
        }
    }

    private void refreshDynamicViewer() {
        Iterator attrIter = this.input.attributesIterator();
        final LinkedList attrList = new LinkedList();
        while (attrIter.hasNext()) {
            attrList.add(attrIter.next());
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LevelPropertyDialog.this.dynamicViewer.setInput((Object)attrList);
            }
        });
    }

    private void refreshStaticViewer() {
        Iterator valuesIter = this.input.staticValuesIterator();
        final LinkedList valuesList = new LinkedList();
        while (valuesIter.hasNext()) {
            valuesList.add(valuesIter.next());
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LevelPropertyDialog.this.staticViewer.setInput((Object)valuesList);
                LevelPropertyDialog.this.defaultValueViewer.setInput((Object)LevelPropertyDialog.this.input);
            }
        });
    }

    protected void okPressed() {
        if (this.dynamicButton.getSelection()) {
            try {
                this.input.setLevelType("dynamic");
                if (this.nameText.getText() != null && !this.nameText.getText().trim().equals("")) {
                    this.input.setName(this.nameText.getText());
                }
                if (this.fieldCombo.getText() != null) {
                    this.input.setColumnName(this.fieldCombo.getText());
                }
                if (this.displayKeyCombo.getText().trim().length() > 0 && !this.displayKeyCombo.getText().equals(Messages.getString("LevelPropertyDialog.None"))) {
                    this.input.setDisplayColumnName(this.displayKeyCombo.getText());
                } else {
                    this.input.setDisplayColumnName(null);
                }
                if (this.dynamicDataTypeCombo.getText() != null) {
                    this.input.setDataType(this.getDataTypeNames()[this.dynamicDataTypeCombo.getSelectionIndex()]);
                }
                this.input.getPropertyHandle("staticValues").clearValue();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
        }
        if (this.staticButton.getSelection()) {
            try {
                this.input.setLevelType("mirrored");
                if (this.staticNameText.getText() != null && !this.staticNameText.getText().trim().equals("")) {
                    this.input.setName(this.staticNameText.getText());
                }
                if (this.staticDataTypeCombo.getText() != null) {
                    this.input.setDataType(this.getDataTypeNames()[this.staticDataTypeCombo.getSelectionIndex()]);
                }
                this.input.getPropertyHandle("attributes").clearValue();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
        }
        super.okPressed();
    }

    protected Composite createDynamicArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(768);
        contents.setLayoutData((Object)data);
        Group groupGroup = new Group(contents, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        groupGroup.setLayout((Layout)layout);
        groupGroup.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label((Composite)groupGroup, 0);
        nameLabel.setText(Messages.getString("LevelPropertyDialog.Name"));
        this.nameText = new Text((Composite)groupGroup, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        Label fieldLabel = new Label((Composite)groupGroup, 0);
        fieldLabel.setText(Messages.getString("LevelPropertyDialog.KeyField"));
        this.fieldCombo = new Combo((Composite)groupGroup, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fieldCombo.setLayoutData((Object)gd);
        this.fieldCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        Label displayKeyLabel = new Label((Composite)groupGroup, 0);
        displayKeyLabel.setText(Messages.getString("LevelPropertyDialog.DisplayField"));
        this.displayKeyCombo = new Combo((Composite)groupGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.displayKeyCombo.setLayoutData((Object)gd);
        this.displayKeyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LevelPropertyDialog.this.displayKeyCombo.getSelectionIndex() > 0) {
                    LevelPropertyDialog.this.displayKeyCombo.setText(DEUtil.getResultSetColumnExpression((String)LevelPropertyDialog.this.displayKeyCombo.getText()));
                }
            }
        });
        Button expressionButton = new Button((Composite)groupGroup, 8);
        UIUtil.setExpressionButtonImage((Button)expressionButton);
        expressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.openExpression();
            }

            private void openExpression() {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(LevelPropertyDialog.this.displayKeyCombo.getText().trim().equals(Messages.getString("LevelPropertyDialog.None")) ? "" : LevelPropertyDialog.this.displayKeyCombo.getText().trim());
                CubeExpressionProvider provider = new CubeExpressionProvider((DesignElementHandle)LevelPropertyDialog.this.input);
                expressionBuilder.setExpressionProvier((IExpressionProvider)provider);
                if (expressionBuilder.open() == 0) {
                    LevelPropertyDialog.this.displayKeyCombo.setText(expressionBuilder.getResult());
                }
            }
        });
        new Label((Composite)groupGroup, 0).setText(Messages.getString("LevelPropertyDialog.DataType"));
        this.dynamicDataTypeCombo = new Combo((Composite)groupGroup, 2056);
        this.dynamicDataTypeCombo.setLayoutData((Object)new GridData(768));
        this.dynamicDataTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.dynamicDataTypeCombo.setLayoutData((Object)gd);
        this.dynamicTable = new Table(contents, 68356);
        gd = new GridData(1808);
        gd.heightHint = 150;
        this.dynamicTable.setLayoutData((Object)gd);
        this.dynamicTable.setLinesVisible(true);
        this.dynamicTable.setHeaderVisible(true);
        this.dynamicTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int itemCount = LevelPropertyDialog.this.dynamicTable.getItemCount();
                    if (LevelPropertyDialog.this.dynamicSelectIndex == itemCount) {
                        return;
                    }
                    if (LevelPropertyDialog.this.dynamicSelectIndex == itemCount - 1) {
                        LevelPropertyDialog levelPropertyDialog = LevelPropertyDialog.this;
                        levelPropertyDialog.dynamicSelectIndex = levelPropertyDialog.dynamicSelectIndex - 1;
                    }
                    try {
                        LevelPropertyDialog.this.handleDynamicDelEvent();
                    }
                    catch (Exception e1) {
                        WidgetUtil.processError((Shell)LevelPropertyDialog.this.getShell(), (Exception)e1);
                    }
                    LevelPropertyDialog.this.refreshDynamicViewer();
                }
            }
        });
        this.dynamicViewer = new TableViewer(this.dynamicTable);
        String[] columns = new String[]{" ", Messages.getString("LevelPropertyDialog.Label.Attribute")};
        TableColumn column = new TableColumn(this.dynamicTable, 16384);
        column.setText(columns[0]);
        column.setWidth(15);
        TableColumn column1 = new TableColumn(this.dynamicTable, 16384);
        column1.setResizable(columns[1] != null);
        if (columns[1] != null) {
            column1.setText(columns[1]);
        }
        column1.setWidth(200);
        this.dynamicViewer.setColumnProperties(new String[]{"", prop_Attribute});
        this.editor = new ComboBoxCellEditor((Composite)this.dynamicViewer.getTable(), this.attributeItems, 8);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.editor;
        CellEditor[] cellEditors = cellEditorArray;
        this.dynamicViewer.setCellEditors(cellEditors);
        this.dynamicViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.dynamicViewer.setLabelProvider((IBaseLabelProvider)this.dynamicLabelProvider);
        this.dynamicViewer.setCellModifier(this.dynamicCellModifier);
        return contents;
    }

    private void resetEditorItems() {
        this.resetEditorItems(null);
    }

    private void resetEditorItems(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(this.attributeItems));
        Iterator attrIter = this.input.attributesIterator();
        while (attrIter.hasNext()) {
            LevelAttributeHandle handle = (LevelAttributeHandle)attrIter.next();
            list.remove(handle.getName());
        }
        list.remove(this.input.getColumnName());
        if (name != null && !list.contains(name)) {
            list.add(0, name);
        }
        String[] temps = new String[list.size()];
        list.toArray(temps);
        this.editor.setItems(temps);
    }

    protected void handleDynamicDelEvent() {
        Object element;
        if (this.dynamicViewer.getSelection() != null && this.dynamicViewer.getSelection() instanceof StructuredSelection && (element = ((StructuredSelection)this.dynamicViewer.getSelection()).getFirstElement()) instanceof LevelAttributeHandle) {
            try {
                ((LevelAttributeHandle)element).drop();
            }
            catch (PropertyValueException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    protected void handleStaticDelEvent() {
        Object element;
        if (this.staticViewer.getSelection() != null && this.staticViewer.getSelection() instanceof StructuredSelection && (element = ((StructuredSelection)this.staticViewer.getSelection()).getFirstElement()) instanceof RuleHandle) {
            try {
                ((RuleHandle)element).drop();
            }
            catch (PropertyValueException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private void createChoiceArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(768);
        contents.setLayoutData((Object)data);
        this.dynamicButton = new Button(contents, 16);
        this.dynamicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    LevelPropertyDialog.this.input.setLevelType("dynamic");
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                LevelPropertyDialog.this.updateButtonStatus(LevelPropertyDialog.this.dynamicButton);
            }
        });
        this.staticButton = new Button(contents, 16);
        this.staticButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    LevelPropertyDialog.this.input.setLevelType("mirrored");
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                LevelPropertyDialog.this.updateButtonStatus(LevelPropertyDialog.this.staticButton);
            }
        });
        this.dynamicButton.setText(Messages.getString("LevelPropertyDialog.Button.Dynamic"));
        this.staticButton.setText(Messages.getString("LevelPropertyDialog.Button.Static"));
    }

    protected void updateButtonStatus(Button button) {
        if (button == this.dynamicButton) {
            this.staticButton.setSelection(false);
            this.dynamicButton.setSelection(true);
            LevelPropertyDialog.setExcludeGridData((Control)this.staticArea, true);
            LevelPropertyDialog.setExcludeGridData((Control)this.dynamicArea, false);
            try {
                this.input.setLevelType("dynamic");
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else if (button == this.staticButton) {
            this.dynamicButton.setSelection(false);
            this.staticButton.setSelection(true);
            LevelPropertyDialog.setExcludeGridData((Control)this.dynamicArea, true);
            LevelPropertyDialog.setExcludeGridData((Control)this.staticArea, false);
            try {
                this.input.setLevelType("mirrored");
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.getShell().layout();
        this.checkOkButtonStatus();
    }

    protected Composite createStaticArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Group properties = new Group(container, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        properties.setLayout((Layout)layout);
        properties.setLayoutData((Object)new GridData(768));
        new Label((Composite)properties, 0).setText(Messages.getString("LevelPropertyDialog.Name"));
        this.staticNameText = new Text((Composite)properties, 2048);
        this.staticNameText.setLayoutData((Object)new GridData(768));
        this.staticNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        new Label((Composite)properties, 0).setText(Messages.getString("LevelPropertyDialog.DataType"));
        this.staticDataTypeCombo = new Combo((Composite)properties, 2056);
        this.staticDataTypeCombo.setLayoutData((Object)new GridData(768));
        this.staticDataTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelPropertyDialog.this.checkOkButtonStatus();
            }
        });
        Group contents = new Group(container, 0);
        layout = new GridLayout();
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(768));
        final Table staticTable = new Table((Composite)contents, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        staticTable.setLayoutData((Object)gd);
        staticTable.setLinesVisible(true);
        staticTable.setHeaderVisible(true);
        staticTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int itemCount = staticTable.getItemCount();
                    if (LevelPropertyDialog.this.staticSelectIndex == itemCount) {
                        return;
                    }
                    if (LevelPropertyDialog.this.staticSelectIndex == itemCount - 1) {
                        --LevelPropertyDialog.this.staticSelectIndex;
                    }
                    try {
                        LevelPropertyDialog.this.handleStaticDelEvent();
                    }
                    catch (Exception e1) {
                        WidgetUtil.processError((Shell)LevelPropertyDialog.this.getShell(), (Exception)e1);
                    }
                    LevelPropertyDialog.this.refreshStaticViewer();
                }
            }
        });
        this.staticViewer = new TableViewer(staticTable);
        String[] columns = new String[]{"", Messages.getString("LevelPropertyDialog.Label.Name"), Messages.getString("LevelPropertyDialog.Label.Expression")};
        int[] widths = new int[]{15, 150, 150};
        this.staticColumns = new TableColumn[3];
        int i = 0;
        while (i < columns.length) {
            this.staticColumns[i] = new TableColumn(staticTable, 16384);
            this.staticColumns[i].setResizable(columns[i] != null);
            if (columns[i] != null) {
                this.staticColumns[i].setText(columns[i]);
            }
            this.staticColumns[i].setWidth(widths[i]);
            this.staticColumns[i].addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    LevelPropertyDialog.this.defaultValueColumns[0].setWidth(LevelPropertyDialog.this.staticColumns[0].getWidth());
                    LevelPropertyDialog.this.defaultValueColumns[1].setWidth(LevelPropertyDialog.this.staticColumns[1].getWidth());
                    LevelPropertyDialog.this.defaultValueColumns[2].setWidth(LevelPropertyDialog.this.staticColumns[2].getWidth());
                }
            });
            ++i;
        }
        this.staticViewer.setColumnProperties(new String[]{"", Prop_Name, prop_Expression});
        this.expressionEditor = new ExpressionCellEditor((Composite)staticTable);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new TextCellEditor((Composite)staticTable);
        cellEditorArray[2] = this.expressionEditor;
        CellEditor[] cellEditors = cellEditorArray;
        this.staticViewer.setCellEditors(cellEditors);
        this.staticViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.staticViewer.setLabelProvider((IBaseLabelProvider)this.staticLabelProvider);
        this.staticViewer.setCellModifier(this.staticCellModifier);
        this.defaultValueTable = new Table((Composite)contents, 68356);
        this.defaultValueTable.setHeaderVisible(false);
        this.defaultValueTable.setLinesVisible(true);
        gd = new GridData(768);
        gd.heightHint = this.defaultValueTable.getItemHeight();
        this.defaultValueTable.setLayoutData((Object)gd);
        this.defaultValueViewer = new TableViewer(this.defaultValueTable);
        this.defaultValueColumns = new TableColumn[3];
        int i2 = 0;
        while (i2 < columns.length) {
            this.defaultValueColumns[i2] = new TableColumn(this.defaultValueTable, 16384);
            this.defaultValueColumns[i2].setResizable(columns[i2] != null);
            this.defaultValueColumns[i2].setWidth(widths[i2]);
            ++i2;
        }
        this.defaultValueViewer.setColumnProperties(new String[]{"", Prop_DefaultValue, prop_Tooltip});
        CellEditor[] cellEditorArray2 = new CellEditor[3];
        cellEditorArray2[1] = new TextCellEditor((Composite)this.defaultValueTable);
        cellEditors = cellEditorArray2;
        this.defaultValueViewer.setCellEditors(cellEditors);
        this.defaultValueViewer.setContentProvider((IContentProvider)this.defaultValueContentProvider);
        this.defaultValueViewer.setLabelProvider((IBaseLabelProvider)this.defaultValueLabelProvider);
        this.defaultValueViewer.setCellModifier(this.defaultValueCellModifier);
        return container;
    }

    public void setInput(TabularLevelHandle level) {
        this.input = level;
    }

    public static void setExcludeGridData(Control control, boolean exclude) {
        Object obj = control.getLayoutData();
        if (obj == null) {
            control.setLayoutData((Object)new GridData());
        } else if (!(obj instanceof GridData)) {
            return;
        }
        GridData data = (GridData)control.getLayoutData();
        data.heightHint = exclude ? 0 : -1;
        control.setLayoutData((Object)data);
        control.getParent().layout();
        control.setVisible(!exclude);
    }

    protected void checkOkButtonStatus() {
        if (this.dynamicButton.getSelection()) {
            if (this.nameText.getText() == null || this.nameText.getText().trim().equals("") || this.fieldCombo.getSelectionIndex() == -1 || this.dynamicDataTypeCombo.getSelectionIndex() == -1) {
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(false);
                }
                this.setMessage(null);
                this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.BlankName"));
            } else if (!UIUtil.validateDimensionName((String)this.nameText.getText())) {
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(false);
                }
                this.setMessage(null);
                this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.NumericName"));
            } else {
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(true);
                }
                this.setErrorMessage(null);
                this.setMessage(Messages.getString("LevelPropertyDialog.Message"));
            }
        } else if (this.staticNameText.getText() == null || this.staticNameText.getText().trim().equals("") || this.staticDataTypeCombo.getSelectionIndex() == -1) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.BlankName"));
        } else if (!UIUtil.validateDimensionName((String)this.staticNameText.getText())) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("LevelPropertyDialog.Message.NumericName"));
        } else {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("LevelPropertyDialog.Message"));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkOkButtonStatus();
        if (this.input != null && this.input.getLevelType() != null) {
            if (this.input.getLevelType().equals("dynamic")) {
                this.dynamicButton.setSelection(true);
                this.staticButton.setSelection(false);
            } else {
                this.dynamicButton.setSelection(false);
                this.staticButton.setSelection(true);
            }
        }
    }
}

