/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.commands;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetConstraintCommand
extends Command {
    private Point newPos;
    private Dimension newSize;
    private Object module;
    private String id;

    public void execute() {
        if (this.module == null || this.id == null) {
            return;
        }
        if (this.module instanceof ModuleHandle) {
            ModuleHandle module = (ModuleHandle)this.module;
            try {
                UIHelper.setIntProperty(module, this.id, "x", this.newPos.x);
                UIHelper.setIntProperty(module, this.id, "y", this.newPos.y);
                UIHelper.setIntProperty(module, this.id, "width", this.newSize.width);
                UIHelper.setIntProperty(module, this.id, "height", this.newSize.height);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public void setLocation(Rectangle r) {
        this.setLocation(r.getLocation());
        this.setSize(r.getSize());
    }

    private void setSize(Dimension dimension) {
        this.newSize = dimension;
    }

    public void setLocation(Point p) {
        this.newPos = p;
    }

    public void setModuleHandle(Object module) {
        this.module = module;
    }

    public void setId(String id) {
        this.id = id;
    }
}

