/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.EditCubeLevelAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TabularLevelNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        if (((LevelHandle)object).canEdit()) {
            menu.insertAfter("additions", (IAction)new EditCubeLevelAction(object, Messages.getString("CubeLevelNodeProvider.menu.text")));
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        menu.insertAfter("additions-refresh", (IAction)new RefreshAction(sourceViewer));
    }

    public String getNodeDisplayName(Object model) {
        LevelHandle handle = (LevelHandle)model;
        return handle.getName();
    }

    public Object[] getChildren(Object object) {
        LevelHandle level = (LevelHandle)object;
        ArrayList<LevelAttributeHandle> list = new ArrayList<LevelAttributeHandle>();
        Iterator attrIter = level.attributesIterator();
        while (attrIter.hasNext()) {
            LevelAttributeHandle handle = (LevelAttributeHandle)attrIter.next();
            list.add(handle);
        }
        return list.toArray();
    }

    public Object getParent(Object model) {
        HierarchyHandle hierarchy = (HierarchyHandle)((LevelHandle)model).getContainer();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getContainer();
    }

    public boolean hasChildren(Object object) {
        LevelHandle level = (LevelHandle)object;
        Iterator attrIter = level.attributesIterator();
        return attrIter.hasNext();
    }

    protected boolean performEdit(ReportElementHandle handle) {
        TabularLevelHandle level = (TabularLevelHandle)handle;
        CubeBuilder dialog = new CubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (TabularCubeHandle)level.getContainer().getContainer().getContainer());
        dialog.showPage("org.eclipse.birt.datasource.editor.cubebuilder.grouppage");
        return dialog.open() == 0;
    }

    public Image getNodeIcon(Object model) {
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        return UIHelper.getImage("icons/obj16/data_column.gif");
    }
}

