/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.css.dom.CellComputedStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Expression;

public class CellContent
extends AbstractContent
implements ICellContent {
    protected int rowSpan = -1;
    protected int colSpan = -1;
    protected int column = -1;
    protected Boolean displayGroupIcon;
    protected boolean repeatContent = false;
    CellDesign cellDesign = null;
    private String headers;
    private String scope;
    private String drop;
    protected static final short FIELD_ROW_SPAN = 100;
    protected static final short FIELD_COL_SPAN = 101;
    protected static final short FIELD_COLUMN = 102;
    protected static final short FIELD_START_OF_GROUP = 103;
    protected static final short FIELD_DISPLAY_GROUP_ICON = 104;
    protected static final short FIELD_DROP = 111;
    protected static final short FIELD_HEADERS = 112;
    protected static final short FIELD_SCOPE = 113;
    protected static final short FIELD_REPEAT_CONTENT = 114;
    private IColumn columnInstance;

    public int getContentType() {
        return 1;
    }

    CellContent(IReportContent report) {
        super(report);
    }

    CellContent(ICellContent cell) {
        super(cell);
        this.colSpan = cell.getColSpan();
        this.rowSpan = cell.getRowSpan();
        this.column = cell.getColumn();
        this.displayGroupIcon = new Boolean(cell.getDisplayGroupIcon());
        this.columnInstance = cell.getColumnInstance();
        if (this.generateBy instanceof CellDesign) {
            this.cellDesign = (CellDesign)this.generateBy;
        }
    }

    public void setGenerateBy(Object generateBy) {
        super.setGenerateBy(generateBy);
        if (generateBy instanceof CellDesign) {
            this.cellDesign = (CellDesign)generateBy;
        }
    }

    public int getRowSpan() {
        if (this.rowSpan == -1 && this.cellDesign != null) {
            this.rowSpan = this.cellDesign.getRowSpan();
        }
        return this.rowSpan;
    }

    public int getColSpan() {
        if (this.colSpan == -1 && this.cellDesign != null) {
            this.colSpan = this.cellDesign.getColSpan();
        }
        return this.colSpan;
    }

    public int getColumn() {
        if (this.column == -1 && this.cellDesign != null) {
            this.column = this.cellDesign.getColumn();
        }
        return this.column;
    }

    public int getRow() {
        if (this.parent != null && this.parent instanceof IRowContent) {
            return ((IRowContent)this.parent).getRowID();
        }
        return 0;
    }

    public void setDrop(String drop) {
        this.drop = drop;
    }

    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitCell(this, value);
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public IStyle getComputedStyle() {
        if (this.computedStyle == null) {
            if (this.inlineStyle == null || this.inlineStyle.isEmpty()) {
                ComputedStyle pcs;
                ComputedStyle cs;
                String columnStyleClass;
                IColumn tblColumn;
                String cacheKey = this.getStyleClass();
                ITableContent table = ((IRowContent)this.parent).getTable();
                int column = this.getColumn();
                if (column >= 0 && column < table.getColumnCount() && (tblColumn = table.getColumn(column)) != null && (columnStyleClass = tblColumn.getStyleClass()) != null) {
                    cacheKey = String.valueOf(cacheKey) + columnStyleClass;
                }
                if ((cs = (pcs = (ComputedStyle)((IContent)this.parent).getComputedStyle()).getCachedStyle(cacheKey)) == null) {
                    cs = new CellComputedStyle(this);
                    pcs.addCachedStyle(cacheKey, cs);
                }
                this.computedStyle = cs;
            } else {
                this.computedStyle = new CellComputedStyle(this);
            }
        }
        return this.computedStyle;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.rowSpan != -1) {
            IOUtil.writeShort((OutputStream)out, (short)100);
            IOUtil.writeInt((OutputStream)out, (int)this.rowSpan);
        }
        if (this.colSpan != -1) {
            IOUtil.writeShort((OutputStream)out, (short)101);
            IOUtil.writeInt((OutputStream)out, (int)this.colSpan);
        }
        if (this.column != -1) {
            IOUtil.writeShort((OutputStream)out, (short)102);
            IOUtil.writeInt((OutputStream)out, (int)this.column);
        }
        if (this.displayGroupIcon != null) {
            IOUtil.writeShort((OutputStream)out, (short)104);
            IOUtil.writeBool((OutputStream)out, (boolean)this.displayGroupIcon);
        }
        if (this.drop != null) {
            IOUtil.writeShort((OutputStream)out, (short)111);
            IOUtil.writeString((DataOutputStream)out, (String)this.drop);
        }
        if (this.headers != null) {
            IOUtil.writeShort((OutputStream)out, (short)112);
            IOUtil.writeString((DataOutputStream)out, (String)this.headers);
        }
        if (this.scope != null) {
            IOUtil.writeShort((OutputStream)out, (short)113);
            IOUtil.writeString((DataOutputStream)out, (String)this.scope);
        }
        if (this.repeatContent) {
            IOUtil.writeShort((OutputStream)out, (short)114);
            IOUtil.writeBool((OutputStream)out, (boolean)true);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 100: {
                this.rowSpan = IOUtil.readInt((InputStream)in);
                break;
            }
            case 101: {
                this.colSpan = IOUtil.readInt((InputStream)in);
                break;
            }
            case 102: {
                this.column = IOUtil.readInt((InputStream)in);
                break;
            }
            case 103: {
                IOUtil.readBool((InputStream)in);
                break;
            }
            case 104: {
                this.displayGroupIcon = IOUtil.readBool((InputStream)in);
                break;
            }
            case 111: {
                this.drop = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 112: {
                this.headers = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 113: {
                this.scope = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 114: {
                this.repeatContent = IOUtil.readBool((InputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    public boolean needSave() {
        if (this.rowSpan != -1 || this.colSpan != -1 || this.column != -1) {
            return true;
        }
        if (this.displayGroupIcon != null || this.headers != null || this.scope != null) {
            return true;
        }
        return super.needSave();
    }

    public boolean getDisplayGroupIcon() {
        if (this.displayGroupIcon == null) {
            if (this.cellDesign != null) {
                return this.cellDesign.getDisplayGroupIcon();
            }
            return false;
        }
        return this.displayGroupIcon;
    }

    public void setDisplayGroupIcon(boolean displayGroupIcon) {
        this.displayGroupIcon = displayGroupIcon;
    }

    public IColumn getColumnInstance() {
        int columnId;
        IRowContent row;
        ITableContent table;
        if (this.columnInstance != null) {
            return this.columnInstance;
        }
        if (this.parent instanceof IRowContent && (table = (row = (IRowContent)this.parent).getTable()) != null && (columnId = this.getColumn()) >= 0 && columnId < table.getColumnCount()) {
            this.columnInstance = table.getColumn(columnId);
        }
        return this.columnInstance;
    }

    protected IContent cloneContent() {
        return new CellContent(this);
    }

    public boolean hasDiagonalLine() {
        if (this.cellDesign != null) {
            return this.cellDesign.hasDiagonalLine();
        }
        return false;
    }

    public int getDiagonalNumber() {
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalNumber();
        }
        return 0;
    }

    public String getDiagonalStyle() {
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalStyle();
        }
        return null;
    }

    public DimensionType getDiagonalWidth() {
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalWidth();
        }
        return null;
    }

    public String getDiagonalColor() {
        if (this.cellDesign != null) {
            return this.cellDesign.getDiagonalColor();
        }
        return null;
    }

    public int getAntidiagonalNumber() {
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalNumber();
        }
        return 0;
    }

    public String getAntidiagonalStyle() {
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalStyle();
        }
        return null;
    }

    public DimensionType getAntidiagonalWidth() {
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalWidth();
        }
        return null;
    }

    public String getAntidiagonalColor() {
        if (this.cellDesign != null) {
            return this.cellDesign.getAntidiagonalColor();
        }
        return null;
    }

    public String getHeaders() {
        Expression expr;
        if (this.headers != null) {
            return this.headers;
        }
        if (this.cellDesign != null && (expr = this.cellDesign.getHeaders()) != null && expr.getType() == 0) {
            return expr.getScriptText();
        }
        return null;
    }

    public String getScope() {
        if (this.scope != null) {
            return this.scope;
        }
        if (this.cellDesign != null) {
            return this.cellDesign.getScope();
        }
        return null;
    }

    public void setHeaders(String headers) {
        Expression expr;
        if (this.cellDesign != null && (expr = this.cellDesign.getHeaders()) != null && expr.getType() == 0 && headers.equals(expr.getScriptText())) {
            this.headers = null;
            return;
        }
        this.headers = headers;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean repeatContent() {
        return this.repeatContent;
    }

    public void setRepeatContent(boolean repeatContent) {
        this.repeatContent = repeatContent;
    }
}

