/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.Report;

public class DataGenerationEngine
extends DteDataEngine {
    private DataOutputStream dos;

    public DataGenerationEngine(ExecutionContext context, IDocArchiveWriter writer) throws Exception {
        super(context, writer);
        DataSessionContext dteSessionContext = new DataSessionContext(1, null, context.getScriptContext(), context.getApplicationClassLoader());
        dteSessionContext.setDocumentWriter(writer);
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        dteEngineContext.setTimeZone(context.getTimeZone());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        this.dos = new DataOutputStream((OutputStream)writer.createRandomAccessStream("/Data/hierarchy"));
        DteMetaInfoIOUtil.startMetaInfo(this.dos);
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
        super.doPrepareQuery(report, appContext);
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResultSet, IQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IBaseResultSet resultSet = super.doExecuteQuery(parentResultSet, query, queryOwner, useCache);
        if (resultSet != null) {
            this.storeMetaInfo(parentResultSet, (IDataQueryDefinition)query, resultSet);
        }
        return resultSet;
    }

    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResultSet, ICubeQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IBaseResultSet resultSet = super.doExecuteCube(parentResultSet, query, queryOwner, useCache);
        if (resultSet != null) {
            this.storeMetaInfo(parentResultSet, (IDataQueryDefinition)query, resultSet);
        }
        return resultSet;
    }

    protected void storeMetaInfo(IBaseResultSet parentResultSet, IDataQueryDefinition query, IBaseResultSet resultSet) throws BirtException {
        String pRsetId = null;
        String rowId = "-1";
        if (parentResultSet != null) {
            pRsetId = parentResultSet instanceof QueryResultSet ? ((QueryResultSet)parentResultSet).getQueryResultsID() : ((CubeResultSet)parentResultSet).getQueryResultsID();
            rowId = parentResultSet.getRawID();
        }
        String queryID = (String)this.queryIDMap.get(query);
        this.storeDteMetaInfo(pRsetId, rowId, queryID, resultSet.getQueryResults().getID());
    }

    public void shutdown() {
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {}
            this.dos = null;
        }
        this.dteSession.shutdown();
    }

    private void storeDteMetaInfo(String pRsetId, String rowId, String queryId, String rsetId) {
        try {
            if (this.context.isExecutingMasterPage() && pRsetId == null) {
                rowId = "-1";
            }
            DteMetaInfoIOUtil.storeMetaInfo(this.dos, pRsetId, rowId, queryId, rsetId);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }
}

