/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.XMLEncodeUtil;

public class XMLWriter {
    protected static Logger log = Logger.getLogger(XMLWriter.class.getName());
    protected PrintWriter printWriter;
    protected String encoding = "UTF-8";
    protected int indentCount;
    protected boolean bPairedFlag = true;
    protected boolean bText = false;
    protected boolean bIndent = true;
    protected boolean bImplicitCloseTag = true;
    private static String[] indents = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t", "\t\t\t\t\t\t", "\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t"};

    public void open(OutputStream outputStream, String encoding) {
        assert (encoding != null);
        assert (outputStream != null);
        this.encoding = encoding;
        try {
            this.printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, encoding), false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.log(Level.SEVERE, "the character encoding {0} unsupported !", encoding);
        }
    }

    public void open(OutputStream outputStream) {
        this.open(outputStream, "UTF-8");
    }

    public void close() {
        this.printWriter.close();
    }

    public void startWriter() {
        this.printWriter.print("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
    }

    public void endWriter() {
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            if (this.bIndent) {
                this.printWriter.println();
            }
        }
        this.printWriter.flush();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void openTag(String tagName) {
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
        }
        if (this.bIndent) {
            this.printWriter.print('\n');
            this.printWriter.print(this.indent());
        }
        this.bPairedFlag = false;
        this.printWriter.print('<');
        this.printWriter.print(tagName);
        ++this.indentCount;
        this.bText = false;
    }

    public void closeTag(String tagName) {
        --this.indentCount;
        if (!this.bPairedFlag) {
            if (this.bImplicitCloseTag) {
                this.printWriter.print("/>");
            } else {
                this.printWriter.print("></");
                this.printWriter.print(tagName);
                this.printWriter.print('>');
            }
        } else {
            if (this.bIndent && !this.bText) {
                this.printWriter.print('\n');
                this.printWriter.print(this.indent());
            }
            this.printWriter.print("</");
            this.printWriter.print(tagName);
            this.printWriter.print('>');
        }
        this.bPairedFlag = true;
        this.bText = false;
    }

    public void attribute(String attrName, String attrValue) {
        if (attrValue != null && attrValue.length() > 0) {
            this.printWriter.print(' ');
            this.printWriter.print(attrName);
            this.printWriter.print("=\"");
            this.printWriter.print(this.encodeAttr(attrValue));
            this.printWriter.print('\"');
        }
    }

    public void attributeAllowEmpty(String attrName, String attrValue) {
        if (attrValue != null) {
            this.printWriter.print(' ');
            this.printWriter.print(attrName);
            this.printWriter.print("=\"");
            this.printWriter.print(this.encodeAttr(attrValue));
            this.printWriter.print('\"');
        }
    }

    public void attribute(String attrName, Object attrValue) {
        if (attrValue != null) {
            this.attribute(attrName, attrValue.toString());
        }
    }

    public void attribute(String attrName, float attrValue) {
        this.printWriter.print(String.valueOf(' ') + attrName + "=\"" + Float.toString(attrValue) + '\"');
    }

    public void attribute(String attrName, double attrValue) {
        this.printWriter.print(String.valueOf(' ') + attrName + "=\"" + Double.toString(attrValue) + '\"');
    }

    public void attribute(String attrName, int attrValue) {
        this.printWriter.print(String.valueOf(' ') + attrName + "=\"" + Integer.toString(attrValue) + '\"');
    }

    public void text(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        String stringToPrint = this.encodeText(value);
        this.printWriter.print(stringToPrint);
        this.bText = true;
    }

    public void cdata(String value) {
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        String text = this.encodeCdata(value);
        this.printWriter.print(text);
        if (this.bPairedFlag) {
            this.bText = true;
        }
    }

    public void literal(String value) {
        this.printWriter.print(value);
    }

    protected String indent() {
        if (!this.bIndent) {
            return "";
        }
        if (this.indentCount < 8) {
            return indents[this.indentCount];
        }
        StringBuffer indentContent = new StringBuffer(64);
        int i = 0;
        while (i < this.indentCount) {
            indentContent.append('\t');
            ++i;
        }
        return indentContent.toString();
    }

    protected String encodeText(String s) {
        return XMLEncodeUtil.encodeText(s);
    }

    protected String encodeAttr(String s) {
        return XMLEncodeUtil.encodeAttr(s);
    }

    protected String encodeCdata(String s) {
        return XMLEncodeUtil.encodeCdata(s);
    }

    public boolean isIndent() {
        return this.bIndent;
    }

    public void setIndent(boolean indent) {
        this.bIndent = indent;
    }

    public boolean isImplicitCloseTag() {
        return this.bImplicitCloseTag;
    }

    public void setImplicitCloseTag(boolean bImplicitCloseTag) {
        this.bImplicitCloseTag = bImplicitCloseTag;
    }
}

