/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexReader;
import org.eclipse.birt.report.engine.internal.index.v2.DocumentIndexV2Constants;
import org.eclipse.birt.report.engine.internal.index.v2.IndexReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentIndexReaderV2
implements IDocumentIndexReader,
ReportDocumentConstants,
DocumentIndexV2Constants {
    private IndexReader bookmarks;
    private IndexReader reportlets;
    private IndexReader pageNumbers;
    private IDocArchiveReader archive;

    public DocumentIndexReaderV2(IDocArchiveReader archive) throws IOException {
        this.archive = archive;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void close() {
        if (this.bookmarks != null) {
            try {
                this.bookmarks.close();
            }
            catch (IOException iOException) {}
            this.bookmarks = null;
        }
        if (this.reportlets != null) {
            try {
                this.reportlets.close();
            }
            catch (IOException iOException) {}
            this.reportlets = null;
        }
        if (this.pageNumbers != null) {
            try {
                this.pageNumbers.close();
            }
            catch (IOException iOException) {}
            this.pageNumbers = null;
        }
    }

    @Override
    public long getOffsetOfBookmark(String bookmark) throws IOException {
        if (this.bookmarks == null) {
            this.bookmarks = this.createIndexReader("/reportletBookmarks");
        }
        if (this.bookmarks != null) {
            return this.bookmarks.get(bookmark);
        }
        return -1L;
    }

    @Override
    public long getOffsetOfInstance(String instanceId) throws IOException {
        if (this.reportlets == null) {
            this.reportlets = this.createIndexReader("/reportlet");
        }
        if (this.reportlets != null) {
            return this.reportlets.get(instanceId);
        }
        return -1L;
    }

    @Override
    public long getPageOfBookmark(String bookmark) throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.createIndexReader("/bookmark");
        }
        if (this.pageNumbers != null) {
            return this.pageNumbers.get(bookmark);
        }
        return -1L;
    }

    @Override
    public List<String> getBookmarks() throws IOException {
        if (this.pageNumbers == null) {
            this.pageNumbers = this.createIndexReader("/bookmark");
        }
        if (this.pageNumbers != null) {
            final ArrayList<String> allBookmarks = new ArrayList<String>();
            this.pageNumbers.forAllKeys(new IndexReader.KeyListener(){

                public void onKey(String key) {
                    if (key != null && !key.startsWith("__TOC_")) {
                        allBookmarks.add(key);
                    }
                }
            });
            return allBookmarks;
        }
        return null;
    }

    private IndexReader createIndexReader(String stream) throws IOException {
        return new IndexReader(this.archive, stream);
    }
}

