/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.w3c.dom.css.CSSValue;

public abstract class HTMLAbstractLM
implements ILayoutManager {
    protected static final int LAYOUT_MANAGER_UNKNOW = -1;
    protected static final int LAYOUT_MANAGER_LEAF = 0;
    protected static final int LAYOUT_MANAGER_BLOCK = 1;
    protected static final int LAYOUT_MANAGER_PAGE = 2;
    protected static final int LAYOUT_MANAGER_TABLE = 3;
    protected static final int LAYOUT_MANAGER_TABLE_BAND = 4;
    protected static final int LAYOUT_MANAGER_ROW = 5;
    protected static final int LAYOUT_MANAGER_LIST = 6;
    protected static final int LAYOUT_MANAGER_LIST_BAND = 7;
    protected static final int LAYOUT_MANAGER_GROUP = 8;
    protected static final int STATUS_INTIALIZE = 0;
    protected static final int STATUS_START = 1;
    protected static final int STATUS_INPROGRESS = 2;
    protected static final int STATUS_END = 3;
    protected static final int STATUS_END_WITH_PAGE_BREAK = 4;
    protected static Logger logger = Logger.getLogger(HTMLAbstractLM.class.getName());
    protected HTMLReportLayoutEngine engine;
    protected HTMLLayoutContext context;
    protected HTMLAbstractLM parent;
    protected IContent content;
    protected IReportItemExecutor executor;
    protected IContentEmitter emitter;
    protected int status = 0;
    private Boolean allowPageBreak;

    public HTMLAbstractLM(HTMLLayoutManagerFactory factory) {
        this.engine = factory.getLayoutEngine();
        this.context = this.engine.getContext();
    }

    public int getType() {
        return -1;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        this.parent = parent;
        this.content = content;
        this.executor = executor;
        this.emitter = emitter;
        this.status = 0;
        this.allowPageBreak = null;
    }

    public HTMLAbstractLM getParent() {
        return this.parent;
    }

    protected abstract void start(boolean var1) throws BirtException;

    protected abstract void end(boolean var1) throws BirtException;

    public boolean layout() throws BirtException {
        switch (this.status) {
            case 0: {
                if (this.handleVisibility()) {
                    this.status = 3;
                    return false;
                }
                if (this.isPageBreakBefore()) {
                    this.status = 1;
                    return true;
                }
            }
            case 1: 
            case 2: {
                this.start(this.status != 2);
                boolean hasNext = this.layoutChildren();
                this.end(!hasNext);
                this.status = this.isChildrenFinished() ? 3 : 2;
                if (hasNext) {
                    return true;
                }
                return this.isPageBreakAfter();
            }
        }
        return false;
    }

    protected abstract boolean layoutChildren() throws BirtException;

    protected abstract boolean isChildrenFinished() throws BirtException;

    public boolean isFinished() {
        return this.status == 3;
    }

    protected IContentEmitter getEmitter() {
        return this.emitter;
    }

    protected boolean isPageBreakBefore() {
        if (this.canPageBreak()) {
            return this.needPageBreakBefore();
        }
        return false;
    }

    protected boolean isPageBreakAfter() {
        if (this.canPageBreak()) {
            return this.needPageBreakAfter();
        }
        return false;
    }

    protected boolean allowPageBreak() {
        return true;
    }

    protected boolean canPageBreak() {
        if (!this.context.allowPageBreak()) {
            return false;
        }
        if (this.allowPageBreak == null) {
            this.allowPageBreak = !this.allowPageBreak() ? Boolean.FALSE : (this.parent != null ? Boolean.valueOf(this.parent.canPageBreak()) : Boolean.TRUE);
        }
        return this.allowPageBreak;
    }

    protected boolean needPageBreakBefore() {
        if (this.content == null || this.content.getContentType() == 1) {
            return false;
        }
        if (this.hasMasterPageChanged()) {
            return true;
        }
        IStyle style = this.content.getStyle();
        CSSValue pageBreak = style.getProperty(22);
        return IStyle.ALWAYS_VALUE == pageBreak || IStyle.RIGHT_VALUE == pageBreak || IStyle.LEFT_VALUE == pageBreak || IStyle.SOFT_VALUE == pageBreak;
    }

    protected boolean needPageBreakAfter() {
        if (this.content == null || this.content.getContentType() == 1) {
            return false;
        }
        IStyle style = this.content.getStyle();
        CSSValue pageBreak = style.getProperty(23);
        return IStyle.ALWAYS_VALUE == pageBreak || IStyle.RIGHT_VALUE == pageBreak || IStyle.LEFT_VALUE == pageBreak;
    }

    protected boolean hasMasterPageChanged() {
        MasterPageDesign masterPageDesign;
        PageSetupDesign pageSetup;
        if (this.content == null || this.content.getContentType() == 1) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String newMasterPage = style.getMasterPage();
        if (newMasterPage == null || newMasterPage.length() == 0) {
            return false;
        }
        String masterPage = this.context.getMasterPage();
        if (!newMasterPage.equalsIgnoreCase(masterPage) && (pageSetup = this.content.getReportContent().getDesign().getPageSetup()).getMasterPageCount() > 0 && (masterPageDesign = pageSetup.findMasterPage(newMasterPage)) != null) {
            this.context.setNextMasterPage(newMasterPage);
            return true;
        }
        return false;
    }

    protected MasterPageDesign getMasterPage(IReportContent report) {
        String masterPage = this.context.getMasterPage();
        MasterPageDesign pageDesign = null;
        if (masterPage != null && !"".equals(masterPage) && (pageDesign = report.getDesign().findMasterPage(masterPage)) != null) {
            return pageDesign;
        }
        return this.getDefaultMasterPage(report);
    }

    private MasterPageDesign getDefaultMasterPage(IReportContent report) {
        PageSetupDesign pageSetup = report.getDesign().getPageSetup();
        int pageCount = pageSetup.getMasterPageCount();
        if (pageCount > 0) {
            MasterPageDesign pageDesign = pageSetup.getMasterPage(0);
            this.context.setMasterPage(pageDesign.getName());
            return pageDesign;
        }
        return null;
    }

    protected boolean handleVisibility() throws BirtException {
        assert (this.content != null);
        assert (this.executor != null);
        if (LayoutUtil.isHidden(this.content, this.emitter.getOutputFormat(), this.context.getOutputDisplayNone())) {
            this.traverse(this.executor, this.content);
            return true;
        }
        return false;
    }

    protected void startHiddenContent(IContentEmitter emitter, IContent content) throws BirtException {
        if (content != null) {
            switch (content.getContentType()) {
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    this.context.getPageBufferManager().startContent(content, emitter, false);
                    break;
                }
                default: {
                    this.context.getPageBufferManager().startContainer(content, true, emitter, false);
                }
            }
        }
    }

    protected void endHiddenContent(IContentEmitter emitter, IContent content) throws BirtException {
        if (content != null) {
            switch (content.getContentType()) {
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                default: {
                    this.context.getPageBufferManager().endContainer(content, true, emitter, false);
                }
            }
        }
    }

    private void traverse(IReportItemExecutor executor, IContent content) throws BirtException {
        assert (executor != null);
        IContentEmitter emitter = this.getEmitter();
        if (content != null) {
            this.startHiddenContent(emitter, content);
        }
        while (executor.hasNextChild()) {
            IReportItemExecutor child = executor.getNextChild();
            if (child == null) continue;
            IContent childContent = child.execute();
            this.traverse(child, childContent);
            child.close();
        }
        if (content != null) {
            this.endHiddenContent(emitter, content);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void execute(IContent content, IReportItemExecutor executor) throws BirtException {
        if (HTMLAbstractLM.$assertionsDisabled || executor != null) ** GOTO lbl11
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            childExecutor = executor.getNextChild();
            if (childExecutor == null) continue;
            childContent = childExecutor.execute();
            if (childContent != null && !content.getChildren().contains(childContent)) {
                content.getChildren().add(childContent);
            }
            this.execute(childContent, childExecutor);
            childExecutor.close();
lbl11:
            // 3 sources

            ** while (executor.hasNextChild())
        }
lbl12:
        // 1 sources

    }

    public void close() throws BirtException {
        this.engine.getFactory().releaseLayoutManager(this);
    }

    public void cancel() {
        this.status = 3;
    }

    protected IContent getContent() {
        return this.content;
    }
}

