/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFBlockContainerLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    public PDFBlockContainerLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected void createRoot() {
        this.root = (ContainerArea)PDFBlockContainerLM.createBlockContainer(this.content, this.isFirst, true);
    }

    protected boolean traverseSingleChild() throws BirtException {
        if (this.child != null) {
            boolean childBreak = false;
            childBreak = this.child.layout();
            if (childBreak) {
                if (this.child.isFinished()) {
                    this.child = null;
                } else {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static IContainerArea createBlockContainer(IContent content, boolean isFirst, boolean isLast) {
        IContainerArea containerArea = AreaFactory.createBlockContainer(content);
        IStyle style = containerArea.getStyle();
        if (!isFirst) {
            style.setProperty(44, IStyle.NUMBER_0);
            style.setProperty(11, IStyle.NUMBER_0);
            style.setProperty(2, IStyle.NUMBER_0);
        }
        if (!isLast) {
            style.setProperty(24, IStyle.NUMBER_0);
            style.setProperty(9, IStyle.NUMBER_0);
            style.setProperty(16, IStyle.NUMBER_0);
        }
        return containerArea;
    }
}

