/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.lowagie.text.Image;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ObjectContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageBlockContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageInlineContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineStackingArea;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

class ConcreteImageLayout
implements ILayout {
    protected static Logger logger = Logger.getLogger(ConcreteImageLayout.class.getName());
    private int resolutionX = 0;
    private int resolutionY = 0;
    private Image imageObject = null;
    private ContainerArea parent;
    protected static final int DEFAULT_WIDHT = 212000;
    protected static final int DEFAULT_HEIGHT = 130000;
    protected IImageContent image;
    protected ContainerArea root;
    private Dimension intrinsic;
    private static final String BOOKMARK_PREFIX = "javascript:catchBookmark('";
    private LayoutContext context;
    private boolean fitToContainer = false;

    public ConcreteImageLayout(LayoutContext context, ContainerArea parent, IImageContent content, Image imageObject) {
        this.context = context;
        this.image = content;
        this.parent = parent;
        this.imageObject = imageObject;
        Object reportItemDesign = content.getGenerateBy();
        if (reportItemDesign != null && reportItemDesign instanceof ImageItemDesign) {
            this.fitToContainer = ((ImageItemDesign)reportItemDesign).isFitToContainer();
        }
    }

    protected Dimension getIntrinsicDimension(IImageContent content, Image image) {
        if (image != null) {
            int contentResolution = content.getResolution();
            if (contentResolution != 0) {
                this.resolutionX = contentResolution;
                this.resolutionY = contentResolution;
            } else {
                this.resolutionX = image.getDpiX();
                this.resolutionY = image.getDpiY();
                if (this.resolutionX == 0 || this.resolutionY == 0) {
                    ReportDesignHandle designHandle = content.getReportContent().getDesign().getReportDesign();
                    this.resolutionX = designHandle.getImageDPI();
                    this.resolutionY = designHandle.getImageDPI();
                }
                if (this.resolutionX == 0 || this.resolutionY == 0) {
                    this.resolutionX = this.context.getDpi();
                    this.resolutionY = this.context.getDpi();
                }
                if (this.resolutionX == 0 || this.resolutionY == 0) {
                    this.resolutionX = 96;
                    this.resolutionY = 96;
                }
            }
            return new Dimension((int)(image.plainWidth() * 1000.0f / (float)this.resolutionX * 72.0f), (int)(image.plainHeight() * 1000.0f / (float)this.resolutionY * 72.0f));
        }
        return null;
    }

    protected int getResolution() {
        int resolution = 0;
        ReportDesignHandle designHandle = this.image.getReportContent().getDesign().getReportDesign();
        resolution = designHandle.getImageDPI();
        if (resolution == 0) {
            resolution = this.context.getDpi();
        }
        if (resolution == 0) {
            resolution = 96;
        }
        return resolution;
    }

    protected Dimension getSpecifiedDimension(IImageContent content, int pWidth, boolean scale) {
        Dimension dim = new Dimension(212000, 130000);
        try {
            this.intrinsic = this.getIntrinsicDimension(content, this.imageObject);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        int dpi = this.getResolution();
        int specifiedWidth = PropertyUtil.getDimensionValue(content, content.getWidth(), dpi, pWidth);
        int specifiedHeight = PropertyUtil.getDimensionValue(content, content.getHeight(), dpi, 0);
        if (this.intrinsic == null) {
            dim.setDimension(specifiedWidth == 0 ? 212000 : specifiedWidth, specifiedHeight == 0 ? 130000 : specifiedHeight);
            return dim;
        }
        if (scale) {
            double ratio = this.intrinsic.getRatio();
            if (specifiedWidth > 0) {
                if (specifiedHeight > 0) {
                    dim.setDimension(specifiedWidth, specifiedHeight);
                } else {
                    dim.setDimension(specifiedWidth, (int)((double)specifiedWidth / ratio));
                }
            } else if (specifiedHeight > 0) {
                dim.setDimension((int)((double)specifiedHeight * ratio), specifiedHeight);
            } else {
                dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
            }
        } else if (specifiedWidth > 0) {
            if (specifiedHeight > 0) {
                dim.setDimension(specifiedWidth, specifiedHeight);
            } else {
                dim.setDimension(specifiedWidth, this.intrinsic.getHeight());
            }
        } else if (specifiedHeight > 0) {
            dim.setDimension(this.intrinsic.getWidth(), specifiedHeight);
        } else {
            dim.setDimension(this.intrinsic.getWidth(), this.intrinsic.getHeight());
        }
        return dim;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void layout() throws BirtException {
        int aHeight;
        this.init();
        if (PropertyUtil.isInlineElement(this.image)) {
            assert (this.parent instanceof InlineStackingArea);
            InlineStackingArea lineParent = (InlineStackingArea)this.parent;
            if (this.root.getAllocatedWidth() <= this.parent.getCurrentMaxContentWidth()) {
                this.parent.add(this.root);
                this.root.finished = true;
                this.parent.update(this.root);
                return;
            }
            if (!lineParent.isEmptyLine()) {
                lineParent.endLine(false);
                this.layout();
                return;
            }
            this.parent.add(this.root);
            this.root.finished = true;
            this.parent.update(this.root);
            return;
        }
        this.parent.add(this.root);
        if (!this.parent.isInInlineStacking && this.context.isAutoPageBreak() && (aHeight = this.root.getAllocatedHeight()) + this.parent.getAbsoluteBP() > this.context.getMaxBP()) {
            this.parent.autoPageBreak();
        }
        this.root.finished = true;
        this.parent.update(this.root);
    }

    protected void init() throws BirtException {
        this.root = PropertyUtil.isInlineElement(this.image) ? new ImageInlineContainer(this.parent, this.context, this.image) : new ImageBlockContainer(this.parent, this.context, this.image);
        this.root.initialize();
        this.root.setAllocatedWidth(this.parent.getMaxAvaWidth());
        this.root.setMaxAvaWidth(this.root.getContentWidth());
        Dimension contentDimension = this.getSpecifiedDimension(this.image, this.root.getContentWidth(), true);
        ImageArea imageArea = this.createImageArea(this.image);
        int maxHeight = this.root.getMaxAvaHeight();
        int maxWidth = this.root.getMaxAvaWidth();
        int cHeight = contentDimension.getHeight();
        int cWidth = contentDimension.getWidth();
        int actualHeight = cHeight;
        int actualWidth = cWidth;
        if (cHeight > maxHeight || cWidth > maxWidth) {
            if (this.fitToContainer) {
                float rh = (float)maxHeight / (float)cHeight;
                float rw = (float)maxWidth / (float)cWidth;
                if (rh > rw) {
                    actualHeight = (int)((float)cHeight * (float)maxWidth / (float)cWidth);
                    actualWidth = maxWidth;
                } else {
                    actualHeight = maxHeight;
                    actualWidth = (int)((float)cWidth * (float)maxHeight / (float)cHeight);
                }
                imageArea.setWidth(actualWidth);
                imageArea.setHeight(actualHeight);
                this.root.setContentWidth(imageArea.getWidth());
                this.root.setContentHeight(imageArea.getHeight());
            } else if (this.context.getPageOverflow() == 2 || this.context.getPageOverflow() == 8) {
                imageArea.setWidth(actualWidth);
                imageArea.setHeight(actualHeight);
                this.root.setContentHeight(actualHeight);
                this.root.setContentWidth(actualWidth);
            } else {
                imageArea.setWidth(actualWidth);
                imageArea.setHeight(actualHeight);
                this.root.setNeedClip(true);
                this.root.setAllocatedHeight(Math.min(maxHeight, cHeight));
                this.root.setAllocatedWidth(Math.min(maxWidth, cWidth));
            }
        } else {
            imageArea.setWidth(actualWidth);
            imageArea.setHeight(actualHeight);
            this.root.setContentWidth(imageArea.getWidth());
            this.root.setContentHeight(imageArea.getHeight());
        }
        this.root.addChild(imageArea);
        imageArea.setPosition(this.root.getContentX(), this.root.getContentY());
        this.processChartLegend(this.image, imageArea);
        this.root.finished = false;
    }

    protected ImageArea createImageArea(IImageContent content) {
        ImageArea area = new ImageArea();
        switch (content.getImageSource()) {
            case 0: 
            case 3: {
                area.setUrl(content.getURI());
                area.setExtension(content.getExtension());
                area.setMIMEType(content.getMIMEType());
                break;
            }
            case 1: 
            case 2: {
                area.setData(content.getData());
                area.setExtension(content.getExtension());
                area.setMIMEType(content.getMIMEType());
            }
        }
        if (content instanceof ObjectContent) {
            ObjectContent object = (ObjectContent)content;
            area.setParameters(object.getParamters());
        }
        area.setAction(content.getHyperlinkAction());
        return area;
    }

    private void processChartLegend(IImageContent imageContent, IImageArea imageArea) {
        boolean hasImageMap;
        if (this.intrinsic == null) {
            return;
        }
        Object imageMapObject = imageContent.getImageMap();
        boolean bl = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
        if (hasImageMap) {
            this.createImageMap((String)imageMapObject, imageArea);
        }
    }

    private void createImageMap(String imageMapObject, IImageArea imageArea) {
        if (imageMapObject == null) {
            return;
        }
        String[] maps = imageMapObject.split("/>");
        Pattern pattern = Pattern.compile(" ([^=]*)=\"([^\"]*)\"");
        String[] stringArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            String map = stringArray[n2];
            if ((map = map.trim()).length() != 0) {
                TreeMap<String, String> attributes = new TreeMap<String, String>();
                Matcher matcher = pattern.matcher(map);
                while (matcher.find()) {
                    attributes.put(matcher.group(1), matcher.group(2));
                }
                try {
                    int[] area = this.getArea((String)attributes.get("coords"));
                    String url = (String)attributes.get("href");
                    String targetWindow = (String)attributes.get("target");
                    this.createImageMap(area, imageArea, url, targetWindow);
                }
                catch (NumberFormatException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    private void createImageMap(int[] area, IImageArea imageArea, String url, String targetWindow) {
        if (url == null) {
            return;
        }
        url = url.replaceAll("&amp;", "&");
        ActionContent link = new ActionContent();
        if (this.isBookmark(url)) {
            String bookmark = this.getBookmark(url);
            link.setBookmark(bookmark);
        } else {
            link.setHyperlink(url, targetWindow);
        }
        area = this.getAbsoluteArea(area, imageArea);
        this.createImageMapContainer(area[0], area[1], area[2], area[3], link);
    }

    private void createImageMapContainer(int x, int y, int width, int height, IHyperlinkAction link) {
        ReportContent cfr_ignored_0 = (ReportContent)this.image.getReportContent();
        BlockContainerArea area = new BlockContainerArea();
        area.setAction(link);
        area.setPosition(x, y);
        area.setWidth(width);
        area.setHeight(height);
        this.root.addChild(area);
    }

    private int[] getAbsoluteArea(int[] area, IImageArea imageArea) {
        assert (this.intrinsic != null);
        int i = 0;
        while (i < 4) {
            area[i] = this.getTranslatedLengthX(area[i]);
            area[++i] = this.getTranslatedLengthY(area[i]);
            ++i;
        }
        int[] result = new int[4];
        int imageX = imageArea.getX();
        int imageY = imageArea.getY();
        int imageHeight = imageArea.getHeight();
        int imageWidth = imageArea.getWidth();
        int intrinsicWidth = this.intrinsic.getWidth();
        int intrinsicHeight = this.intrinsic.getHeight();
        float ratio = (float)imageWidth / (float)intrinsicWidth;
        result[0] = imageX + (int)((float)area[0] * ratio);
        result[2] = (int)((float)area[2] * ratio);
        ratio = (float)imageHeight / (float)intrinsicHeight;
        result[1] = imageY + (int)((float)area[1] * ratio);
        result[3] = (int)((float)area[3] * ratio);
        return result;
    }

    private int getTranslatedLengthX(int length) {
        return length * 1000 / this.resolutionX * 72;
    }

    private int getTranslatedLengthY(int length) {
        return length * 1000 / this.resolutionY * 72;
    }

    private boolean isBookmark(String url) {
        return url.startsWith(BOOKMARK_PREFIX) && url.endsWith("')");
    }

    private String getBookmark(String url) {
        int start = url.indexOf(BOOKMARK_PREFIX) + BOOKMARK_PREFIX.length();
        int end = url.length() - 2;
        return url.substring(start, end);
    }

    private int[] getArea(String string) {
        int[] area;
        String[] rawDatas = string.split(",");
        area = new int[]{Integer.parseInt(rawDatas[0]), Integer.parseInt(rawDatas[1]), Integer.parseInt(rawDatas[4]) - area[0], Integer.parseInt(rawDatas[5]) - area[1]};
        return area;
    }

    protected void close() {
    }
}

