/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;

public abstract class RepeatableArea
extends BlockContainerArea {
    protected List repeatList = null;
    protected int repeatHeight = 0;
    protected boolean inHeaderBand = false;

    public RepeatableArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        if (this.needRepeat()) {
            this.repeatList = new ArrayList();
        }
    }

    public void setInHeaderBand(boolean inHeaderBand) {
        this.inHeaderBand = inHeaderBand;
    }

    protected void addRepeatedItem() throws BirtException {
        if (this.repeatList != null && this.repeatList.size() > 0 && !this.inHeaderBand) {
            if (this.getRepeatedHeight() < this.getMaxAvaHeight()) {
                int i = 0;
                while (i < this.repeatList.size()) {
                    ContainerArea row = (ContainerArea)this.repeatList.get(i);
                    ContainerArea cloneRow = row.deepClone();
                    if (i == 0 && cloneRow instanceof RowArea) {
                        ((RowArea)cloneRow).needResolveBorder = true;
                    }
                    this.children.add(i, cloneRow);
                    cloneRow.setParent(this);
                    this.update(cloneRow);
                    cloneRow.setAllocatedY(this.currentBP);
                    ++i;
                }
            } else {
                this.repeatList = null;
            }
        }
    }

    public int getMaxAvaHeight() {
        return super.getMaxAvaHeight() - this.getRepeatedHeight();
    }

    protected int getRepeatedHeight() {
        if (this.inHeaderBand) {
            return 0;
        }
        if (this.repeatHeight != 0) {
            return this.repeatHeight;
        }
        if (this.repeatList != null) {
            int i = 0;
            while (i < this.repeatList.size()) {
                AbstractArea area = (AbstractArea)this.repeatList.get(i);
                this.repeatHeight += area.getAllocatedHeight();
                ++i;
            }
            return this.repeatHeight;
        }
        return 0;
    }

    protected boolean isValidResult(List result) {
        if (this.repeatList != null && !this.inHeaderBand) {
            return result.size() > this.repeatList.size();
        }
        return super.isValidResult(result);
    }

    protected abstract boolean needRepeat();

    public RepeatableArea(RepeatableArea area) {
        super(area);
    }

    public void add(AbstractArea area) {
        int type;
        IElement parent;
        IContent content;
        super.add(area);
        if (this.repeatList != null && (content = ((ContainerArea)area).getContent()) != null && (parent = content.getParent()) != null && parent instanceof IBandContent && ((type = ((IBandContent)parent).getBandType()) == 1 || type == 3)) {
            if (content instanceof IRowContent) {
                RowDesign rowDesign = (RowDesign)content.getGenerateBy();
                if (rowDesign == null || rowDesign.getRepeatable()) {
                    this.repeatList.add(area);
                }
            } else {
                this.repeatList.add(area);
            }
        }
    }
}

