/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.WordRecognizerWrapper;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.DefaultHyphenationManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Hyphenation;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class TextCompositor {
    private FontInfo fontInfo;
    private int runLevel;
    int offset = 0;
    private ChunkGenerator remainChunks;
    private IWordRecognizer remainWords;
    private Word remainWord;
    private Word wordVestige;
    private boolean hasLineBreak = false;
    private boolean isNewLine = true;
    private static int LINE_BREAK_COLLAPSE_FREE = 0;
    private static int LINE_BREAK_COLLAPSE_STANDING_BY = 1;
    private static int LINE_BREAK_COLLAPSE_OCCUPIED = 2;
    private int lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
    private ITextContent textContent;
    private FontMappingManager fontManager;
    private LayoutContext context;
    private boolean textWrapping;
    protected TextStyle textStyle = null;

    public TextCompositor(ITextContent textContent, FontMappingManager fontManager, LayoutContext context) {
        this.textContent = textContent;
        this.fontManager = fontManager;
        this.context = context;
        IStyle style = textContent.getComputedStyle();
        this.textWrapping = context.getTextWrapping() && !PropertyUtil.isWhiteSpaceNoWrap(style.getProperty(57));
        this.remainChunks = new ChunkGenerator(fontManager, textContent, context.getBidiProcessing(), context.getFontSubstitution());
    }

    public boolean hasNextArea() {
        if (!this.textWrapping && this.hasLineBreak) {
            return false;
        }
        return this.offset < this.textContent.getText().length();
    }

    public void setNewLineStatus(boolean status) {
        this.isNewLine = status;
    }

    public TextArea getNextArea(int maxLineWidth) {
        if (!this.hasNextArea()) {
            throw new RuntimeException("No more text.");
        }
        TextArea textArea = this.getNextTextArea(maxLineWidth);
        this.offset += textArea.getTextLength();
        if (this.lineBreakCollapse == LINE_BREAK_COLLAPSE_OCCUPIED) {
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            return null;
        }
        return textArea;
    }

    private TextArea getNextTextArea(int maxLineWidth) {
        if (this.wordVestige != null) {
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            TextArea textArea = this.createTextArea(this.textContent, this.offset, this.runLevel, this.fontInfo);
            textArea.setMaxWidth(maxLineWidth);
            textArea.setWidth(0);
            this.addWordIntoTextArea(textArea, this.wordVestige);
            return textArea;
        }
        if (this.remainWord != null) {
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            TextArea textArea = this.createTextArea(this.textContent, this.offset, this.runLevel, this.fontInfo);
            textArea.setMaxWidth(maxLineWidth);
            textArea.setWidth(0);
            this.addWordIntoTextArea(textArea, this.remainWord);
            this.remainWord = null;
            return textArea;
        }
        if (this.remainWords == null || !this.remainWords.hasWord()) {
            Chunk chunk = this.remainChunks.getNext();
            if (chunk == Chunk.HARD_LINE_BREAK) {
                FontHandler handler = new FontHandler(this.fontManager, this.textContent, false);
                TextArea textArea = this.createTextArea(this.textContent, handler.getFontInfo(), true);
                textArea.setTextLength(chunk.getLength());
                this.hasLineBreak = true;
                if (this.lineBreakCollapse == LINE_BREAK_COLLAPSE_STANDING_BY) {
                    this.lineBreakCollapse = LINE_BREAK_COLLAPSE_OCCUPIED;
                }
                return textArea;
            }
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_FREE;
            this.fontInfo = chunk.getFontInfo();
            this.runLevel = chunk.getRunLevel();
            this.remainWords = new WordRecognizerWrapper(chunk.getText(), this.context.getLocale());
        }
        TextArea textArea = this.createTextArea(this.textContent, this.offset, this.runLevel, this.fontInfo);
        textArea.setMaxWidth(maxLineWidth);
        textArea.setWidth(0);
        this.addWordsIntoTextArea(textArea, this.remainWords);
        return textArea;
    }

    protected TextArea createTextArea(ITextContent textContent, FontInfo fontInfo, boolean blankLine) {
        if (this.textStyle == null || this.textStyle.getFontInfo() != fontInfo) {
            this.textStyle = TextAreaLayout.buildTextStyle(textContent, fontInfo);
        }
        TextArea area = new TextArea(this.textStyle);
        area.setOffset(this.offset);
        if (blankLine) {
            area.lineBreak = true;
            area.blankLine = true;
        } else {
            area.setOffset(0);
            area.setTextLength(textContent.getText().length());
        }
        return area;
    }

    protected TextArea createTextArea(ITextContent textContent, int offset, int runLevel, FontInfo fontInfo) {
        if (this.textStyle == null || this.textStyle.getFontInfo() != fontInfo) {
            this.textStyle = TextAreaLayout.buildTextStyle(textContent, fontInfo);
        }
        TextArea area = new TextArea(textContent.getText(), this.textStyle);
        area.setAction(textContent.getHyperlinkAction());
        area.setOffset(offset);
        area.setRunLevel(runLevel);
        area.setVerticalAlign(textContent.getComputedStyle().getProperty(49));
        return area;
    }

    private void addWordsIntoTextArea(TextArea textArea, IWordRecognizer words) {
        while (words.hasWord()) {
            Word word = words.getNextWord();
            this.addWordIntoTextArea(textArea, word);
            if (!textArea.isLineBreak()) continue;
            return;
        }
    }

    private void addWordIntoTextArea(TextArea textArea, Word word) {
        int textLength = word.getLength();
        int wordWidth = this.getWordWidth(this.fontInfo, word);
        if (textArea.hasSpace(wordWidth += this.textStyle.getLetterSpacing() * textLength)) {
            this.addWord(textArea, textLength, wordWidth);
            this.wordVestige = null;
            if (this.remainWords.hasWord()) {
                if (textArea.hasSpace(this.textStyle.getWordSpacing())) {
                    textArea.addWordSpacing(this.textStyle.getWordSpacing());
                } else {
                    textArea.setLineBreak(true);
                    this.hasLineBreak = true;
                    this.lineBreakCollapse = LINE_BREAK_COLLAPSE_STANDING_BY;
                }
            }
        } else {
            if (this.isNewLine && textArea.isEmpty()) {
                if (this.context.isEnableHyphenation()) {
                    this.doHyphenation(word.getValue(), textArea);
                } else {
                    this.addWord(textArea, textLength, wordWidth);
                }
            } else {
                this.wordVestige = null;
                this.remainWord = word;
            }
            textArea.setLineBreak(true);
            this.hasLineBreak = true;
            this.lineBreakCollapse = LINE_BREAK_COLLAPSE_STANDING_BY;
        }
    }

    private void doHyphenation(String str, TextArea area) {
        DefaultHyphenationManager hm = new DefaultHyphenationManager();
        Hyphenation hyph = hm.getHyphenation(str);
        FontInfo fi = area.getStyle().getFontInfo();
        if (area.getMaxWidth() < 0) {
            this.addWordVestige(area, 1, this.getTextWidth(fi, hyph.getHyphenText(0, 1)), str.substring(1, str.length()));
            return;
        }
        int endHyphenIndex = this.hyphen(0, area.getMaxWidth() - area.getWidth(), hyph, fi);
        if (endHyphenIndex == 0 && area.getWidth() == 0) {
            this.addWordVestige(area, 1, this.getTextWidth(fi, hyph.getHyphenText(0, 1)), str.substring(1, str.length()));
        } else {
            this.addWordVestige(area, endHyphenIndex, this.getTextWidth(fi, hyph.getHyphenText(0, endHyphenIndex)) + this.textStyle.getLetterSpacing() * (endHyphenIndex - 1), str.substring(endHyphenIndex, str.length()));
        }
    }

    private void addWordVestige(TextArea area, int vestigeTextLength, int vestigeWordWidth, String vestigeString) {
        this.addWord(area, vestigeTextLength, vestigeWordWidth);
        this.wordVestige = vestigeString.length() == 0 ? null : new Word(vestigeString, 0, vestigeString.length());
    }

    private int hyphen(int startIndex, int width, Hyphenation hyphenation, FontInfo fi) {
        assert (startIndex >= 0);
        if (startIndex > hyphenation.length() - 1) {
            return -1;
        }
        int last = 0;
        int current = 0;
        int i = startIndex + 1;
        while (i < hyphenation.length()) {
            last = current;
            String pre = hyphenation.getHyphenText(startIndex, i);
            current = (int)(fi.getWordWidth(pre) * 1000.0f) + this.textStyle.getLetterSpacing() * pre.length();
            if (width > last && width <= current) {
                return i - 1;
            }
            ++i;
        }
        return hyphenation.length() - 1;
    }

    private int getTextWidth(FontInfo fontInfo, String text) {
        return (int)(fontInfo.getWordWidth(text) * 1000.0f);
    }

    private int getWordWidth(FontInfo fontInfo, Word word) {
        return this.getTextWidth(fontInfo, word.getValue());
    }

    private void addWord(TextArea textArea, int textLength, int wordWidth) {
        textArea.addWord(textLength, wordWidth);
    }
}

