/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IListEventHandler;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.List;
import org.eclipse.birt.report.engine.script.internal.instance.ListInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListHandle;

public class ListScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(ListHandle listHandle, ExecutionContext context) {
        try {
            List list = new List(listHandle);
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listHandle, context);
            if (eh != null) {
                eh.onPrepare(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IListContent content, ExecutionContext context) {
        ReportItemDesign listDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ListScriptExecutor.needOnCreate(listDesign)) {
            return;
        }
        try {
            ListInstance list = new ListInstance(content, context, RunningState.CREATE);
            if (ListScriptExecutor.handleJS(list, listDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listDesign, context);
            if (eh != null) {
                eh.onCreate(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e, listDesign.getHandle());
        }
    }

    public static void handleOnRender(IListContent content, ExecutionContext context) {
        ReportItemDesign listDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ListScriptExecutor.needOnRender(listDesign)) {
            return;
        }
        try {
            ListInstance list = new ListInstance(content, context, RunningState.RENDER);
            if (ListScriptExecutor.handleJS(list, listDesign.getOnRender(), context).didRun()) {
                return;
            }
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listDesign, context);
            if (eh != null) {
                eh.onRender(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e, listDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(IListContent content, ExecutionContext context) {
        ReportItemDesign listDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ListScriptExecutor.needOnPageBreak(listDesign)) {
            return;
        }
        try {
            ListInstance list = new ListInstance(content, context, RunningState.PAGEBREAK);
            if (ListScriptExecutor.handleJS(list, listDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listDesign, context);
            if (eh != null) {
                eh.onPageBreak(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e, listDesign.getHandle());
        }
    }

    private static IListEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IListEventHandler)ListScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            ListScriptExecutor.addClassCastException(context, e, design.getHandle(), IListEventHandler.class);
        }
        catch (EngineException e) {
            ListScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }

    private static IListEventHandler getEventHandler(ListHandle handle, ExecutionContext context) {
        try {
            return (IListEventHandler)ListScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            ListScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, IListEventHandler.class);
        }
        catch (EngineException e) {
            ListScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }
}

