/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.EventHandlerManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class ScriptExecutor {
    public static final String PROPERTYSEPARATOR = EngineConstants.PROPERTYSEPARATOR;
    public static final String WEBAPP_CLASSPATH_KEY = "webapplication.projectclasspath";
    public static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    public static final String PROJECT_CLASSPATH_KEY = "user.projectclasspath";
    protected static Logger log = Logger.getLogger(ScriptExecutor.class.getName());

    protected static JSScriptStatus handleJS(Object scope, Expression expr, ExecutionContext context) throws BirtException {
        return ScriptExecutor.handleJSInternal(scope, expr, context);
    }

    private static JSScriptStatus handleJSInternal(Object scope, Expression expr, ExecutionContext context) throws BirtException {
        if (expr != null) {
            try {
                if (scope != null) {
                    context.newScope(scope);
                }
                Object result = null;
                result = context.evaluate(expr);
                JSScriptStatus jSScriptStatus = new JSScriptStatus(true, result);
                return jSScriptStatus;
            }
            finally {
                if (scope != null) {
                    context.exitScope();
                }
            }
        }
        return JSScriptStatus.NO_RUN;
    }

    protected static boolean needOnCreate(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnCreate() != null || design.getJavaClass() != null;
    }

    protected static boolean needOnRender(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnRender() != null || design.getJavaClass() != null;
    }

    protected static boolean needOnPageBreak(ReportItemDesign design) {
        if (design == null) {
            return false;
        }
        return design.getOnPageBreak() != null || design.getJavaClass() != null;
    }

    protected static Object getInstance(DesignElementHandle handle, ExecutionContext context) throws EngineException {
        EventHandlerManager eventHandlerManager = context.getEventHandlerManager();
        return eventHandlerManager.getInstance(handle, context);
    }

    protected static Object getInstance(String className, ExecutionContext context) throws EngineException {
        EventHandlerManager eventHandlerManager = context.getEventHandlerManager();
        return EventHandlerManager.getInstance(className, context);
    }

    protected static Object getInstance(ReportItemDesign design, ExecutionContext context) throws EngineException {
        EventHandlerManager eventHandlerManager = context.getEventHandlerManager();
        return eventHandlerManager.getInstance(design, context);
    }

    protected static void addClassCastException(ExecutionContext context, Exception e, DesignElementHandle handle, Class requiredInterface) {
        EngineException ex = new EngineException("Error.ScriptClassCastError", new Object[]{handle.getEventHandlerClass(), requiredInterface.getName()}, (Throwable)e);
        log.log(Level.WARNING, e.getMessage(), e);
        if (context == null) {
            return;
        }
        context.addException(handle, (BirtException)ex);
    }

    protected static void addException(ExecutionContext context, Exception e) {
        ScriptExecutor.addException(context, e, null);
    }

    protected static void addException(ExecutionContext context, Exception e, DesignElementHandle handle) {
        EngineException eex = null;
        eex = e instanceof EngineException ? (EngineException)((Object)e) : (e instanceof BirtException ? new EngineException((BirtException)((Object)e)) : new EngineException("Error.UnhandledScriptError", e));
        log.log(Level.WARNING, eex.getMessage(), (Throwable)((Object)eex));
        if (context == null) {
            return;
        }
        if (handle == null) {
            context.addException(eex);
        } else {
            context.addException(handle, (BirtException)eex);
        }
    }

    protected static class JSScriptStatus {
        private boolean didRun;
        private Object result;
        public static final JSScriptStatus NO_RUN = new JSScriptStatus(false, null);

        public JSScriptStatus(boolean didRun, Object result) {
            this.didRun = didRun;
            this.result = result;
        }

        public boolean didRun() {
            return this.didRun;
        }

        public Object result() {
            return this.result;
        }
    }
}

