/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data;

import java.util.Map;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.core.model.views.data.ReportDataHandle;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.IReportPageBookViewPage;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportEventRunnable;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.DataViewEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.views.RenameListener;
import org.eclipse.birt.report.designer.internal.ui.views.ViewContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ItemSorter;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDragListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDropListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.IDropConstraint;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.widget.ITreeViewerBackup;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DataViewTreeViewerPage
extends DataViewPage
implements AbstractModelEventProcessor.IModelEventFactory,
IValidationListener,
IReportPageBookViewPage {
    private static final String LABEL_DOUBLE_CLICK = Messages.getString((String)"DataViewTreeViewerPage.tooltip.DoubleClickToEdit");
    private ITreeViewerBackup backup;

    public DataViewTreeViewerPage(ModuleHandle reportHandle) {
        this.setReportHandle(reportHandle);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 770);
        return treeViewer;
    }

    protected void initPage() {
        this.createContextMenus();
        this.handleGlobalAction();
        new RenameListener(this.getTreeViewer()).apply();
        this.getTreeViewer().setSorter((ViewerSorter)new ItemSorter());
        this.getTreeViewer().getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == DataViewTreeViewerPage.this.getTreeViewer().getTree()) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = DataViewTreeViewerPage.this.getTreeViewer().getTree().getItem(pt);
                    DataViewTreeViewerPage.this.getTreeViewer().getTree().setToolTipText(DataViewTreeViewerPage.this.getTooltip(item));
                }
            }
        });
        this.getTreeViewer().getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (DataViewTreeViewerPage.this.getSelection() instanceof StructuredSelection) {
                    Object selectedObject = ((StructuredSelection)DataViewTreeViewerPage.this.getSelection()).getFirstElement();
                    try {
                        Tree tree = (Tree)e.getSource();
                        TreeItem[] selectedItems = tree.getSelection();
                        if (selectedItems.length > 0) {
                            if (selectedItems[0].getExpanded()) {
                                selectedItems[0].setExpanded(false);
                            } else {
                                DataViewTreeViewerPage.this.getTreeViewer().expandToLevel(selectedObject, selectedItems[0].getExpanded() ? 0 : 1);
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        if (this.backup != null) {
            this.backup.restoreBackup(this.getTreeViewer());
            this.getTreeViewer().getTree().addTreeListener(new TreeListener(){

                public void treeCollapsed(TreeEvent e) {
                    Item item = (Item)e.item;
                    DataViewTreeViewerPage.this.backup.updateCollapsedStatus(DataViewTreeViewerPage.this.getTreeViewer(), item.getData());
                }

                public void treeExpanded(TreeEvent e) {
                    Item item = (Item)e.item;
                    DataViewTreeViewerPage.this.backup.updateExpandedStatus(DataViewTreeViewerPage.this.getTreeViewer(), item.getData());
                }
            });
        }
    }

    private String getTooltip(TreeItem item) {
        if (item != null) {
            Object object = item.getData();
            if (object instanceof DataSourceHandle || object instanceof ParameterGroupHandle) {
                return LABEL_DOUBLE_CLICK;
            }
            StringBuffer tooltip = new StringBuffer();
            boolean canInsert = InsertInLayoutUtil.handleValidateInsertToLayout((Object)object, (EditPart)UIUtil.getCurrentEditPart());
            String text = "(" + item.getText() + ")";
            if (object instanceof DataSetHandle) {
                if (canInsert) {
                    tooltip.append(String.valueOf(Messages.getString((String)"DataViewTreeViewerPage.tooltip.DragToInsertDataSetColumns")) + text + "; ");
                }
                tooltip.append(LABEL_DOUBLE_CLICK);
            }
            if ((object instanceof DataSetItemModel || object instanceof ResultSetColumnHandle) && canInsert) {
                tooltip.append(String.valueOf(Messages.getString((String)"DataViewTreeViewerPage.tooltip.DragToInsertColumn")) + text);
            }
            if (object instanceof ParameterHandle) {
                if (canInsert) {
                    tooltip.append(Messages.getString((String)"DataViewTreeViewerPage.tooltip.DragToInsertParameter"));
                }
                tooltip.append(LABEL_DOUBLE_CLICK);
            }
            return tooltip.toString();
        }
        return "";
    }

    private void createContextMenus() {
        ViewContextMenuProvider menuManager = new ViewContextMenuProvider((ISelectionProvider)this.getTreeViewer());
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("#Pop up", (MenuManager)menuManager, this.getSite().getSelectionProvider());
    }

    protected void configTreeViewer() {
        ViewsTreeProvider provider = new ViewsTreeProvider();
        this.getTreeViewer().setContentProvider((IContentProvider)provider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.initRoot();
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new DesignerDragListener((StructuredViewer)this.getTreeViewer()));
        transfers = new Transfer[]{TemplateTransfer.getInstance()};
        ops = 3;
        DesignerDropListener dropListener = new DesignerDropListener(this.getTreeViewer());
        dropListener.addDropConstraint(CascadingParameterGroupHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                return -1;
            }
        });
        dropListener.addDropConstraint(ScalarParameterHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle targetParameter;
                if (target instanceof ScalarParameterHandle && (targetParameter = (ScalarParameterHandle)target).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        });
        IDropConstraint cascadingParameterGroupChildrenConstraint = new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle transferParameter;
                if (transfer instanceof Object[] && ((Object[])transfer).length > 0 && ((Object[])transfer)[0] instanceof ScalarParameterHandle && (transferParameter = (ScalarParameterHandle)((Object[])transfer)[0]).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        };
        dropListener.addDropConstraint(ScalarParameterHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(ParameterGroupHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(SlotHandle.class, cascadingParameterGroupChildrenConstraint);
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)dropListener);
    }

    private void initRoot() {
        this.getTreeViewer().setInput((Object)new ReportDataHandle(this.getRoot()));
        this.getRoot().addValidationListener((IValidationListener)this);
    }

    public ModuleHandle getRoot() {
        return this.getReportHandle();
    }

    public void dispose() {
        this.getRoot().removeValidationListener((IValidationListener)this);
        super.dispose();
    }

    private void deleteConfigVariable(final Map args) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                String variableName = null;
                variableName = (String)args.get("Variable Name");
                if (variableName != null) {
                    ConfigVariable cv = DataViewTreeViewerPage.this.getRoot().findConfigVariable(variableName);
                    try {
                        if (cv != null) {
                            DataViewTreeViewerPage.this.getRoot().getPropertyHandle("configVars").removeItem((Object)cv);
                        }
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            }
        });
    }

    protected boolean isDisposed() {
        Control ctrl = this.getControl();
        return ctrl == null || ctrl.isDisposed();
    }

    private void handleGlobalAction() {
        String id;
        int i = 0;
        while (i < GlobalActionFactory.GLOBAL_SELECTION_ACTIONS.length) {
            id = GlobalActionFactory.GLOBAL_SELECTION_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction((String)id, (ISelectionProvider)this));
            ++i;
        }
        i = 0;
        while (i < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length) {
            id = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createStackAction((String)id, (CommandStack)this.getRoot().getCommandStack()));
            ++i;
        }
        this.getSite().getActionBars().updateActionBars();
    }

    public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
        this.getTreeViewer().refresh();
    }

    public void setBackupState(ITreeViewerBackup dataBackup) {
        this.backup = dataBackup;
    }

    public IModelEventProcessor getModelProcessor() {
        return new DataViewEventProcessor((AbstractModelEventProcessor.IModelEventFactory)this);
    }

    public Runnable createModelEventRunnable(Object focus, final int type, final Map args) {
        switch (type) {
            case 0: 
            case 3: 
            case 5: {
                return new ReportEventRunnable(focus, type, args){

                    public void run() {
                        if (DataViewTreeViewerPage.this.isDispose()) {
                            return;
                        }
                        DataViewTreeViewerPage.this.getTreeViewer().refresh();
                        if (type == 0) {
                            Object obj = this.getArgs().get("Event Content");
                            DataViewTreeViewerPage.this.expandNodeAfterCreation(obj);
                        }
                        DataViewTreeViewerPage.this.deleteConfigVariable(args);
                    }
                };
            }
        }
        return new ReportEventRunnable(focus, type, args){

            public void run() {
                if (DataViewTreeViewerPage.this.isDispose()) {
                    return;
                }
                DataViewTreeViewerPage.this.getTreeViewer().refresh();
            }
        };
    }

    protected void expandNodeAfterCreation(Object obj) {
        if (obj instanceof IDesignElement) {
            IDesignElement element = (IDesignElement)obj;
            this.getTreeViewer().expandToLevel((Object)element.getHandle(this.getRoot().getModule()), 0);
            if (this.backup != null) {
                this.backup.updateStatus(this.getTreeViewer());
            }
        }
    }

    public boolean isDispose() {
        if (this.getTreeViewer() == null || this.getTreeViewer().getTree() == null) {
            return true;
        }
        return this.getTreeViewer().getTree().isDisposed();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.getTreeViewer();
    }
}

