/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IExternalizer;
import org.eclipse.birt.chart.factory.IResourceFinder;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.reportitem.BIRTActionEvaluator;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.QueryUIHelper;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.StandardChartDataSheet;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ChartExpressionProvider;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartDataSheet;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ApplyButtonHandler;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IButtonHandler;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.HyperlinkBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemBuilderUI;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChartReportItemBuilderImpl
extends ReportItemBuilderUI
implements IUIServiceProvider {
    private static boolean isChartWizardOpen = false;
    protected static int iInstanceCount = 0;
    protected transient ExtendedItemHandle extendedHandle = null;
    private transient String taskId = null;
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public ChartReportItemBuilderImpl() {
    }

    public ChartReportItemBuilderImpl(String taskId) {
        this.taskId = taskId;
    }

    public static boolean isChartWizardOpen() {
        return isChartWizardOpen;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int open(ExtendedItemHandle eih) {
        if (iInstanceCount > 0) {
            return 1;
        }
        ++iInstanceCount;
        if (ChartXTabUtil.isAxisChart((DesignElementHandle)eih)) {
            DesignElementHandle hostChart = eih.getElementProperty("hostChart");
            this.extendedHandle = (ExtendedItemHandle)hostChart;
        } else {
            this.extendedHandle = eih;
        }
        try {
            ExtendedItemHandle refHandle;
            IReportItem item = null;
            try {
                item = this.extendedHandle.getReportItem();
                if (item == null) {
                    this.extendedHandle.loadExtendedElement();
                    item = this.extendedHandle.getReportItem();
                }
            }
            catch (ExtendedElementException exception) {
                logger.log((Exception)((Object)exception));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemBuilderImpl.log.UnableToLocate"));
                return 1;
            }
            final CommandStack commandStack = this.extendedHandle.getRoot().getCommandStack();
            final String TRANS_NAME = org.eclipse.birt.chart.reportitem.i18n.Messages.getString((String)"ChartElementCommandImpl.editChart");
            commandStack.startTrans(TRANS_NAME);
            ChartReportItemImpl crii = (ChartReportItemImpl)item;
            Chart cm = (Chart)crii.getProperty("chart.instance");
            Chart cmClone = cm == null ? null : cm.copyInstance();
            final Object[] applyData = new Object[3];
            Shell parentShell = null;
            if (PlatformUI.isWorkbenchRunning()) {
                parentShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            }
            ChartWizard chartBuilder = new ChartWizard(parentShell);
            ReportDataServiceProvider dataProvider = new ReportDataServiceProvider(this.extendedHandle);
            StandardChartDataSheet dataSheet = new StandardChartDataSheet(this.extendedHandle, dataProvider);
            final ChartWizardContext context = new ChartWizardContext(cmClone, (IUIServiceProvider)this, (IDataServiceProvider)dataProvider, (IChartDataSheet)dataSheet);
            dataProvider.setWizardContext(context);
            if (dataProvider.checkState(32)) {
                context.setEnabled("Chart.Axis", false);
                context.setEnabled("Chart.Axis.X Axis", false);
                context.setEnabled("Chart.Axis.Y Axis", false);
                context.setEnabled("Chart.Axis.Z Axis", false);
                context.setEnabled("Chart.Legend", false);
                context.setEnabled("Chart.Title", false);
                context.setEnabled("Pie Chart", false);
                context.setEnabled("Meter Chart", false);
                context.setEnabled("Stock Chart", false);
                context.setEnabled("Bubble Chart", false);
                context.setEnabled("Difference Chart", false);
                context.setEnabled("Gantt Chart", false);
            }
            chartBuilder.addCustomButton((IButtonHandler)new ApplyButtonHandler(chartBuilder){

                public void run() {
                    super.run();
                    applyData[0] = context.getModel().copyInstance();
                    applyData[1] = context.getOutputFormat();
                    applyData[2] = context.isInheritColumnsOnly();
                    commandStack.commit();
                    commandStack.startTrans(TRANS_NAME);
                }
            });
            context.setRtL(crii.isLayoutDirectionRTL());
            context.setTextRtL(this.extendedHandle.isDirectionRTL());
            context.setResourceFinder((IResourceFinder)crii);
            context.setExternalizer((IExternalizer)crii);
            Object of = this.extendedHandle.getProperty("outputFormat");
            if (of instanceof String) {
                if (of.equals("GIF")) {
                    context.setOutputFormat("PNG");
                } else {
                    context.setOutputFormat((String)of);
                }
            }
            context.setInheritColumnsOnly(this.extendedHandle.getBooleanProperty("inheritColumns"));
            context.setExtendedItem((Object)this.extendedHandle);
            context.setProcessor((IStyleProcessor)new ChartReportStyleProcessor((DesignElementHandle)this.extendedHandle, false));
            ChartAdapter.beginIgnoreNotifications();
            if (dataProvider.checkState(2048) && (refHandle = ChartReportItemUtil.getChartReferenceItemHandle((ReportItemHandle)this.extendedHandle)) != null) {
                ChartReportItemUtil.copyChartSeriesDefinition((Chart)ChartReportItemUtil.getChartFromHandle((ExtendedItemHandle)refHandle), (Chart)context.getModel());
            }
            context.setActionEvaluator((IActionEvaluator)new BIRTActionEvaluator());
            ChartAdapter.endIgnoreNotifications();
            isChartWizardOpen = true;
            ChartWizardContext contextResult = (ChartWizardContext)chartBuilder.open(null, this.taskId, (IWizardContext)context);
            isChartWizardOpen = false;
            if (contextResult != null && contextResult.getModel() != null) {
                this.updateModel(this.extendedHandle, chartBuilder, crii, cm, contextResult.getModel(), contextResult.getOutputFormat(), contextResult.isInheritColumnsOnly());
                if (dataProvider.isPartChart() && ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.extendedHandle) instanceof AggregationCellHandle) {
                    ChartXTabUIUtil.updateXTabForAxis(ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.extendedHandle), this.extendedHandle, ChartXTabUIUtil.isTransposedChartWithAxes(cm), (ChartWithAxes)contextResult.getModel());
                }
                commandStack.commit();
                return 0;
            }
            if (applyData[0] != null) {
                commandStack.rollback();
                this.updateModel(this.extendedHandle, chartBuilder, crii, cm, (Chart)applyData[0], (String)applyData[1], (Boolean)applyData[2]);
                if (!dataProvider.isPartChart()) return 0;
                if (!(ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.extendedHandle) instanceof AggregationCellHandle)) return 0;
                commandStack.startTrans(TRANS_NAME);
                ChartXTabUIUtil.updateXTabForAxis(ChartXTabUtil.getXtabContainerCell((DesignElementHandle)this.extendedHandle), this.extendedHandle, ChartXTabUIUtil.isTransposedChartWithAxes(cm), (ChartWithAxes)applyData[0]);
                commandStack.commit();
                return 0;
            }
            commandStack.rollback();
            return 1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            --iInstanceCount;
            this.extendedHandle = null;
            isChartWizardOpen = false;
        }
    }

    private void updateModel(ExtendedItemHandle eih, ChartWizard chartBuilder, ChartReportItemImpl crii, Chart cmOld, Chart cmNew, String outputFormat, boolean bInheritColumnsOnly) {
        cmNew = crii.getSerializer().optimize(cmNew);
        ChartUtil.reviseVersion((Chart)cmNew);
        try {
            eih.setProperty("outputFormat", (Object)outputFormat);
            eih.setProperty("inheritColumns", (Object)bInheritColumnsOnly);
            crii.executeSetModelCommand(eih, cmOld, cmNew);
            if (cmNew.getBlock().getBounds() == null || cmNew.getBlock().getBounds().getWidth() == 0.0 || cmNew.getBlock().getBounds().getHeight() == 0.0) {
                cmNew.getBlock().setBounds(ChartReportItemUtil.createDefaultChartBounds((ExtendedItemHandle)eih, (Chart)cmNew));
            }
            Bounds bo = cmNew.getBlock().getBounds();
            NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
            if (eih.getWidth().getStringValue() == null) {
                eih.setWidth(String.valueOf(nf.format(bo.getWidth())) + "pt");
            }
            if (eih.getHeight().getStringValue() == null) {
                eih.setHeight(String.valueOf(nf.format(bo.getHeight())) + "pt");
            }
        }
        catch (SemanticException smx) {
            logger.log((Exception)((Object)smx));
        }
        if (crii.getDesignerRepresentation() != null) {
            ((DesignerRepresentation)((Object)crii.getDesignerRepresentation())).setDirty(true);
        }
    }

    public String invoke(String sExpression, Object oContext, String sTitle) {
        ExpressionBuilder eb = new ExpressionBuilder(sExpression);
        eb.setExpressionProvier((IExpressionProvider)new ExpressionProvider((DesignElementHandle)((ExtendedItemHandle)oContext)));
        if (sTitle != null) {
            eb.setDialogTitle(String.valueOf(eb.getDialogTitle()) + " - " + sTitle);
        }
        if (eb.open() == 0) {
            sExpression = eb.getResult();
        }
        return sExpression;
    }

    public String invoke(String sExpression, Object oContext, String sTitle, boolean isChartProvider) {
        ExpressionBuilder eb = new ExpressionBuilder(sExpression);
        eb.setExpressionProvier((IExpressionProvider)new ChartExpressionProvider());
        if (sTitle != null) {
            eb.setDialogTitle(String.valueOf(eb.getDialogTitle()) + " - " + sTitle);
        }
        if (eb.open() == 0) {
            sExpression = eb.getResult();
        }
        return sExpression;
    }

    public String[] validate(Chart cm, Object oContext) {
        ArrayList<String> alProblems = new ArrayList<String>(4);
        ExtendedItemHandle eih = (ExtendedItemHandle)oContext;
        if (DEUtil.getDataSetList((DesignElementHandle)eih).size() == 0 && ChartXTabUtil.getBindingCube((DesignElementHandle)eih) == null) {
            alProblems.add(Messages.getString("ChartReportItemBuilderImpl.problem.hasNotBeenFound"));
        }
        QueryUIHelper.SeriesQueries[] qsqa = new QueryUIHelper().getSeriesQueryDefinitions(cm);
        int i = 0;
        while (i < qsqa.length) {
            Collection<String> co = qsqa[i].validate();
            if (co != null) {
                alProblems.addAll(co);
            }
            ++i;
        }
        return alProblems.toArray(new String[alProblems.size()]);
    }

    public final List getRegisteredKeys() {
        return this.extendedHandle.getModuleHandle().getMessageKeys();
    }

    public final String getValue(String sKey) {
        String value = this.extendedHandle.getModuleHandle().getMessage(sKey);
        if (value == null || value.equals("")) {
            return sKey;
        }
        return value;
    }

    public final double getConvertedValue(double dOriginalValue, String sFromUnits, String sToUnits) {
        if (sFromUnits == null || sToUnits == null) {
            return dOriginalValue;
        }
        double dResult = -1.0;
        IDisplayServer ids = ChartUIUtil.getDisplayServer();
        if (sFromUnits.equalsIgnoreCase("pixels")) {
            dOriginalValue = dOriginalValue * 72.0 / (double)ids.getDpiResolution();
        }
        dResult = DimensionUtil.convertTo((double)dOriginalValue, (String)ChartReportItemBuilderImpl.getBIRTUnitsFor(sFromUnits), (String)ChartReportItemBuilderImpl.getBIRTUnitsFor(sToUnits)).getMeasure();
        if (sToUnits.equalsIgnoreCase("pixels")) {
            dResult = (double)ids.getDpiResolution() * dResult / 72.0;
        }
        return dResult;
    }

    private static String getBIRTUnitsFor(String sUnits) {
        if (sUnits.equalsIgnoreCase("inches")) {
            return "in";
        }
        if (sUnits.equalsIgnoreCase("centimeters")) {
            return "cm";
        }
        return "pt";
    }

    public String invoke(int command, String value, Object context, String sTitle) throws ChartException {
        final ChartExpressionProvider ep = new ChartExpressionProvider((DesignElementHandle)((ExtendedItemHandle)context), this.getExpressionBuilderStyle(command));
        Shell shell = null;
        switch (command) {
            case 6: 
            case 7: 
            case 8: {
                shell = new Shell(Display.getDefault(), 67696);
                ChartUIUtil.bindHelp((Control)shell, (String)"org.eclipse.birt.chart.cshelp.EditURL_ID");
                HyperlinkBuilder hb = new HyperlinkBuilder(shell, true){

                    protected ExpressionProvider getExpressionProvider() {
                        return ep;
                    }
                };
                try {
                    hb.setInputString(value, (DesignElementHandle)this.extendedHandle);
                    if (sTitle != null) {
                        hb.setTitle(String.valueOf(hb.getTitle()) + " - " + sTitle);
                    }
                    if (hb.open() != 0) break;
                    value = hb.getResultString();
                    break;
                }
                catch (Exception e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 13, (Throwable)e);
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                shell = new Shell(Display.getDefault(), 67696);
                ChartUIUtil.bindHelp((Control)shell, (String)"org.eclipse.birt.chart.cshelp.ExpressionBuilder_ID");
                ExpressionBuilder eb = new ExpressionBuilder(shell, value);
                eb.setExpressionProvier((IExpressionProvider)ep);
                if (sTitle != null) {
                    eb.setDialogTitle(String.valueOf(eb.getDialogTitle()) + " - " + sTitle);
                }
                if (eb.open() != 0) break;
                value = eb.getResult();
            }
        }
        return value;
    }

    public boolean isInvokingSupported() {
        return true;
    }

    public boolean isEclipseModeSupported() {
        return true;
    }

    private int getExpressionBuilderStyle(int builderCommand) {
        if (builderCommand == 1) {
            return 14;
        }
        if (builderCommand == 2) {
            return 1;
        }
        if (builderCommand == 4) {
            return 25;
        }
        if (builderCommand == 3) {
            return 24;
        }
        if (builderCommand == 5) {
            return 29;
        }
        if (builderCommand == 6) {
            return 10;
        }
        if (builderCommand == 7) {
            return 15;
        }
        if (builderCommand == 8) {
            return 58;
        }
        return 0;
    }
}

